"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Peer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const virtual_network_peering_1 = require("@cdktf/provider-azurerm/lib/virtual-network-peering");
const constructs_1 = require("constructs");
class Peer extends constructs_1.Construct {
    /**
     * Represents a Virtual Network Peering within Microsoft Azure.
     *
     * This class facilitates the peering between two virtual networks, allowing resources in either network to communicate
     * with each other as if they were within the same network. It supports advanced configurations such as traffic forwarding,
     * gateway transit, and access settings. This peering does not require a VPN gateway and offers low-latency, high-bandwidth
     * connections between resources in different virtual networks.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) application.
     * @param name - The unique name for this instance of the network peering.
     * @param props - Configuration properties for the network peering, derived from the PeerProps interface. These include:
     *                - `virtualNetwork`: The local virtual network object.
     *                - `remoteVirtualNetwork`: The remote virtual network object.
     *                - `localToRemoteSettings`: Configuration settings applied from the local virtual network to the remote virtual network.
     *                - `remoteToLocalSettings`: Configuration settings applied from the remote virtual network to the local virtual network.
     *
     * Example usage:
     * ```typescript
     * const vnetPeering = new Peer(this, 'VNetPeering', {
     *   virtualNetwork: myVNet,
     *   remoteVirtualNetwork: partnerVNet,
     *   localToRemoteSettings: {
     *     allowVirtualNetworkAccess: true,
     *     allowForwardedTraffic: false,
     *     allowGatewayTransit: false,
     *     useRemoteGateways: false
     *   },
     *   remoteToLocalSettings: {
     *     allowVirtualNetworkAccess: true,
     *     allowForwardedTraffic: true,
     *     allowGatewayTransit: false,
     *     useRemoteGateways: false
     *   }
     * });
     * ```
     * This class initializes a VNet peering with the specified configurations, enabling direct connectivity between
     * the specified virtual networks. It manages the creation and configuration of network peering settings, ensuring
     * that both VNets are appropriately linked and configured according to the defined properties.
     */
    constructor(scope, name, props) {
        super(scope, name);
        const localtoRemotePeerName = props.virtualNetwork.name + "to" + props.remoteVirtualNetwork.name;
        new virtual_network_peering_1.VirtualNetworkPeering(this, "VNetPeerLocaltoRemote", {
            name: localtoRemotePeerName,
            resourceGroupName: props.virtualNetwork.resourceGroup.name,
            virtualNetworkName: props.virtualNetwork.name,
            remoteVirtualNetworkId: props.remoteVirtualNetwork.id,
            ...props.localToRemoteSettings,
        });
        const remoteToLocalPeerName = props.remoteVirtualNetwork.name + "to" + props.virtualNetwork.name;
        new virtual_network_peering_1.VirtualNetworkPeering(this, "VNetPeerRemotetoLocal", {
            name: remoteToLocalPeerName,
            resourceGroupName: props.remoteVirtualNetwork.resourceGroup.name,
            virtualNetworkName: props.remoteVirtualNetwork.name,
            remoteVirtualNetworkId: props.virtualNetwork.id,
            ...props.remoteToLocalSettings,
        });
    }
}
exports.Peer = Peer;
_a = JSII_RTTI_SYMBOL_1;
Peer[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_virtualnetwork.Peer", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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