"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const vnet = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying a Virtual Network", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const network = new vnet.Network(stack, "testAzureVirtualNetworkDefaults", {
            name: `vnet-${randomName}`,
            location: "eastus",
            resourceGroup: resourceGroup,
            addressSpace: ["10.0.0.0/16"],
            subnets: [
                {
                    name: "subnet1",
                    addressPrefixes: ["10.0.1.0/24"],
                },
                {
                    name: "subnet2",
                    addressPrefixes: ["10.0.2.0/24"],
                },
            ],
        });
        const remotenetwork = new vnet.Network(stack, "testAzureRemoteVirtualNetworkDefaults", {
            name: `vnet-${randomName}2`,
            location: "westus",
            resourceGroup: resourceGroup,
            addressSpace: ["10.1.0.0/16"],
            subnets: [
                {
                    name: "subnet1",
                    addressPrefixes: ["10.1.1.0/24"],
                },
                {
                    name: "subnet2",
                    addressPrefixes: ["10.1.2.0/24"],
                },
            ],
        });
        const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(stack, "log_analytics", {
            location: "eastus",
            name: `la-${randomName}`,
            resourceGroupName: resourceGroup.name,
        });
        // Diag Settings
        network.addDiagSettings({
            name: "diagsettings",
            logAnalyticsWorkspaceId: logAnalyticsWorkspace.id,
            metric: [
                {
                    category: "AllMetrics",
                },
            ],
        });
        // RBAC
        network.addAccess(clientConfig.objectId, "Contributor");
        // Peer the networks
        network.addVnetPeering(remotenetwork);
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stac can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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