"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const vnet = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Virtual Network With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new vnet.Network(stack, "testAzureVirtualNetworkDefaults", {});
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Virtual Network with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXp1cmVWaXJ0dWFsTmV0d29yay5zcGVjLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2F6dXJlLXZpcnR1YWxuZXR3b3JrL3Rlc3QvQXp1cmVWaXJ0dWFsTmV0d29yay5zcGVjLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbUVBQXVFO0FBQ3ZFLGlDQUFnRDtBQUNoRCwyQkFBMkI7QUFDM0IsMkNBQThDO0FBQzlDLDJDQUF5QztBQUV6QyxRQUFRLENBQUMscUNBQXFDLEVBQUUsR0FBRyxFQUFFO0lBQ25ELElBQUksS0FBcUIsQ0FBQztJQUMxQixJQUFJLGVBQW9CLENBQUM7SUFFekIsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNkLE1BQU0sR0FBRyxHQUFHLGVBQU8sQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUMxQixLQUFLLEdBQUcsSUFBSSxzQkFBYyxDQUFDLEdBQUcsRUFBRSxNQUFNLENBQUMsQ0FBQztRQUV4QyxJQUFJLDBCQUFlLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRSxFQUFFLFFBQVEsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRTdELElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsaUNBQWlDLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFL0QsZUFBZSxHQUFHLGVBQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyw0QkFBNEI7SUFDMUUsQ0FBQyxDQUFDLENBQUM7SUFFSCxFQUFFLENBQUMsb0VBQW9FLEVBQUUsR0FBRyxFQUFFO1FBQzVFLE1BQU0sQ0FBQyxlQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUMsQ0FBQyxxQ0FBcUM7SUFDdkYsQ0FBQyxDQUFDLENBQUM7SUFFSCxFQUFFLENBQUMsd0RBQXdELEVBQUUsR0FBRyxFQUFFO1FBQ2hFLE1BQU0sQ0FBQyxlQUFlLENBQUMsQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLENBQUMsdUJBQXVCO0lBQ3ZFLENBQUMsQ0FBQyxDQUFDO0lBRUgsRUFBRSxDQUFDLDhCQUE4QixFQUFFLEdBQUcsRUFBRTtRQUN0QyxJQUFBLHVCQUFhLEVBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyx1QkFBdUI7SUFDekQsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEF6dXJlcm1Qcm92aWRlciB9IGZyb20gXCJAY2RrdGYvcHJvdmlkZXItYXp1cmVybS9saWIvcHJvdmlkZXJcIjtcbmltcG9ydCB7IFRlc3RpbmcsIFRlcnJhZm9ybVN0YWNrIH0gZnJvbSBcImNka3RmXCI7XG5pbXBvcnQgKiBhcyB2bmV0IGZyb20gXCIuLlwiO1xuaW1wb3J0IHsgVGVycmFmb3JtUGxhbiB9IGZyb20gXCIuLi8uLi90ZXN0aW5nXCI7XG5pbXBvcnQgXCJjZGt0Zi9saWIvdGVzdGluZy9hZGFwdGVycy9qZXN0XCI7XG5cbmRlc2NyaWJlKFwiQXp1cmUgVmlydHVhbCBOZXR3b3JrIFdpdGggRGVmYXVsdHNcIiwgKCkgPT4ge1xuICBsZXQgc3RhY2s6IFRlcnJhZm9ybVN0YWNrO1xuICBsZXQgZnVsbFN5bnRoUmVzdWx0OiBhbnk7XG5cbiAgYmVmb3JlRWFjaCgoKSA9PiB7XG4gICAgY29uc3QgYXBwID0gVGVzdGluZy5hcHAoKTtcbiAgICBzdGFjayA9IG5ldyBUZXJyYWZvcm1TdGFjayhhcHAsIFwidGVzdFwiKTtcblxuICAgIG5ldyBBenVyZXJtUHJvdmlkZXIoc3RhY2ssIFwiYXp1cmVGZWF0dXJlXCIsIHsgZmVhdHVyZXM6IHt9IH0pO1xuXG4gICAgbmV3IHZuZXQuTmV0d29yayhzdGFjaywgXCJ0ZXN0QXp1cmVWaXJ0dWFsTmV0d29ya0RlZmF1bHRzXCIsIHt9KTtcblxuICAgIGZ1bGxTeW50aFJlc3VsdCA9IFRlc3RpbmcuZnVsbFN5bnRoKHN0YWNrKTsgLy8gU2F2ZSB0aGUgcmVzdWx0IGZvciByZXVzZVxuICB9KTtcblxuICBpdChcInJlbmRlcnMgYW4gQXp1cmUgVmlydHVhbCBOZXR3b3JrIHdpdGggZGVmYXVsdHMgYW5kIGNoZWNrcyBzbmFwc2hvdFwiLCAoKSA9PiB7XG4gICAgZXhwZWN0KFRlc3Rpbmcuc3ludGgoc3RhY2spKS50b01hdGNoU25hcHNob3QoKTsgLy8gQ29tcGFyZSB0aGUgYWxyZWFkeSBwcmVwYXJlZCBzdGFja1xuICB9KTtcblxuICBpdChcImNoZWNrIGlmIHRoZSBwcm9kdWNlZCB0ZXJyYWZvcm0gY29uZmlndXJhdGlvbiBpcyB2YWxpZFwiLCAoKSA9PiB7XG4gICAgZXhwZWN0KGZ1bGxTeW50aFJlc3VsdCkudG9CZVZhbGlkVGVycmFmb3JtKCk7IC8vIFVzZSB0aGUgc2F2ZWQgcmVzdWx0XG4gIH0pO1xuXG4gIGl0KFwiY2hlY2sgaWYgdGhpcyBjYW4gYmUgcGxhbm5lZFwiLCAoKSA9PiB7XG4gICAgVGVycmFmb3JtUGxhbihmdWxsU3ludGhSZXN1bHQpOyAvLyBVc2UgdGhlIHNhdmVkIHJlc3VsdFxuICB9KTtcbn0pO1xuIl19