"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiagnosticSettings = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
//import { DataAzurermMonitorDiagnosticCategories } from "@cdktf/provider-azurerm/lib/data-azurerm-monitor-diagnostic-categories";
const monitor_diagnostic_setting_1 = require("@cdktf/provider-azurerm/lib/monitor-diagnostic-setting");
const constructs_1 = require("constructs");
class DiagnosticSettings extends constructs_1.Construct {
    /**
     * Manages the diagnostic settings for monitoring Azure resources.
     *
     * This class is responsible for configuring Azure Monitor Diagnostic Settings to collect and route metrics and logs from
     * Azure resources to monitoring and analytics services. Diagnostic settings can be applied to resources like VMs,
     * App Services, and more, allowing collected data to be sent to Event Hubs, Log Analytics workspaces, or Azure Storage.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the diagnostic settings.
     * @param props - Configuration properties for diagnostic settings. These properties include:
     *                - `name`: Optional. The name of the diagnostic settings. If not provided, a unique name will be generated.
     *                - `targetResourceId`: The ID of the Azure resource to which these diagnostic settings apply.
     *                - `storageAccountId`: Optional. The ID of the Azure Storage account to which logs and metrics are sent.
     *                - `eventhubAuthorizationRuleId`: Optional. The authorization rule ID for the Event Hub namespace.
     *                - `eventhubName`: Optional. The name of the Event Hub where metrics and logs will be sent.
     *                - `logAnalyticsWorkspaceId`: Optional. The ID of the Log Analytics workspace to which logs and metrics are sent.
     *                - `partnerSolutionId`: Optional. ID of a partner solution that configurations are fetched from.
     *                - `logCategories`: Optional. Categories of logs to collect.
     *                - `metricCategories`: Optional. Categories of metrics to collect.
     *                - `logAnalyticsDestinationType`: Optional. Specifies whether logs should be stored in a dedicated table or the
     *                  legacy AzureDiagnostics table in the Log Analytics workspace.
     *
     * Example usage:
     * ```typescript
     * const resourceGroup = new ResourceGroup(this, 'ResourceGroup', { ... });
     * const diagnostics = new DiagnosticSettings(this, 'MyDiagnostics', {
     *   name: 'example-diagnostics',
     *   targetResourceId: resourceGroup.id,
     *   logAnalyticsWorkspaceId: logAnalyticsWorkspace.id,
     *   storageAccountId: storageAccount.id,
     *   logCategories: ['Write', 'Delete'],
     *   metricCategories: ['AllMetrics']
     * });
     * ```
     * This class configures the diagnostic settings to collect specific logs and metrics from the target resource and routes them
     * to specified destinations such as Log Analytics, Storage Account, or Event Hubs.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        // Get the list of available diagnostic categories
        // const categories = new DataAzurermMonitorDiagnosticCategories(
        //   this,
        //   "diagcategories",
        //   {
        //     resourceId: props.targetResourceId,
        //   },
        // );
        //const logCategories = props.logCategories ?? categories.logCategoryTypes;
        //const metricCategories = props.metricCategories ?? categories.metrics;
        new monitor_diagnostic_setting_1.MonitorDiagnosticSetting(this, "diagsettings", {
            name: props.name || "diagsettings",
            targetResourceId: props.targetResourceId,
            logAnalyticsDestinationType: props.logAnalyticsDestinationType,
            storageAccountId: props.storageAccountId,
            logAnalyticsWorkspaceId: props.logAnalyticsWorkspaceId,
            eventhubAuthorizationRuleId: props.eventhubAuthorizationRuleId,
            eventhubName: props.eventhubName,
            partnerSolutionId: props.partnerSolutionId,
            metric: props.metric,
            enabledLog: props.log,
        });
    }
}
exports.DiagnosticSettings = DiagnosticSettings;
_a = JSII_RTTI_SYMBOL_1;
DiagnosticSettings[_a] = { fqn: "@microsoft/terraform-cdk-constructs.core_azure.DiagnosticSettings", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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