"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rbac = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_assignment_1 = require("@cdktf/provider-azurerm/lib/role-assignment");
const constructs_1 = require("constructs");
class Rbac extends constructs_1.Construct {
    /**
     * Manages Role-Based Access Control (RBAC) assignments within Azure.
     *
     * This class is responsible for creating and managing RBAC role assignments in Azure, which control permissions for Azure AD
     * identities to manage Azure resources. It supports assigning roles at different scopes such as subscriptions, resource groups,
     * or specific resources.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the RBAC assignment.
     * @param props - Configuration properties for the RBAC assignment. These properties include:
     *                - `objectId`: The Azure AD object ID for the user, group, or service principal to which the role is assigned.
     *                - `roleDefinitionUUID`: Optional. The UUID of the Azure RBAC role definition. This can be obtained via Azure CLI.
     *                - `roleDefinitionName`: The name of the role to be assigned, such as 'Contributor', 'Reader', or 'Owner'.
     *                - `scope`: The scope at which the role is assigned, which could be a subscription, resource group, or specific resource.
     *
     * Example usage:
     * ```typescript
     * const rbac = new Rbac(this, 'rbacAssignment', {
     *   objectId: 'user-or-group-object-id',
     *   roleDefinitionName: 'Contributor',
     *   scope: '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}'
     * });
     * ```
     * This RBAC instance assigns the 'Contributor' role to a user or group specified by 'objectId' at the scope of a specific resource group.
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Create a new role assignment using the provided properties.
        new role_assignment_1.RoleAssignment(this, "role", {
            name: props.roleDefinitionUUID,
            principalId: props.objectId,
            roleDefinitionName: props.roleDefinitionName,
            scope: props.scope,
        });
    }
}
exports.Rbac = Rbac;
_a = JSII_RTTI_SYMBOL_1;
Rbac[_a] = { fqn: "@microsoft/terraform-cdk-constructs.core_azure.Rbac", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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