"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzureResourceWithAlert = exports.AzureResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const constructs_1 = require("constructs");
const diagsettings_1 = require("./diagsettings");
const rbac_1 = require("./rbac");
const metricalert = require("../../azure-metricalert");
const queryalert = require("../../azure-queryrulealert");
class AzureResource extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.id = id;
    }
    /**
     * Adds an access role assignment for a specified Azure AD object (e.g., user, group, service principal) within this RBAC construct's scope.
     *
     * This method creates a new role assignment which grants the specified Azure AD object access to resources
     * at the scope defined by this construct. This is useful for programmatically managing access controls,
     * ensuring only authorized users or systems can perform specific actions on Azure resources.
     *
     * @param objectId - The unique identifier of the Azure AD object (user, group, or service principal) that will receive the role assignment.
     * @param customRoleName - The human-readable name of the Azure RBAC role to be assigned. This role defines the permissions that the object will have.
     *
     * Example usage:
     * ```typescript
     * // Example: Assign a "Reader" role to a user for the current RBAC scope
     * rbacInstance.addAccess('user-object-id', 'Reader');
     * ```
     */
    addAccess(objectId, customRoleName) {
        new rbac_1.Rbac(this, objectId + customRoleName, {
            objectId: objectId,
            roleDefinitionName: customRoleName,
            scope: this.id,
        });
    }
    /**
     * Adds diagnostic settings to a specified resource within this construct.
     *
     * This method creates and configures a new DiagnosticSettings instance which captures and routes
     * diagnostic data (logs and metrics) to the specified destinations such as Azure Monitor,
     * an Event Hubs instance, a Log Analytics workspace, or an Azure Storage account.
     *
     * @param props - The properties required to configure the diagnostic settings. These include:
     *                - `name`: Optional. The name of the diagnostic settings resource. Defaults to 'diag-settings'.
     *                - `logAnalyticsWorkspaceId`: Optional. The identifier of the Log Analytics workspace to send logs.
     *                - `eventhubAuthorizationRuleId`: Optional. The authorization rule ID for an Event Hub where logs will be forwarded.
     *                - `eventhubName`: Optional. The name of the Event Hub to which logs will be sent.
     *                - `storageAccountId`: Optional. The identifier of the Azure Storage account where logs will be stored.
     *                - `logAnalyticsDestinationType`: Optional. Determines if logs are sent to dedicated or legacy tables in Log Analytics. Defaults to undefined which uses the default settings.
     *                The `targetResourceId` is automatically set to the ID of this construct instance.
     *
     * @returns An instance of the DiagnosticSettings class, configured with the provided properties.
     *
     * Example usage:
     * ```typescript
     * const diagSettings = resource.addDiagSettings({
     *   name: 'custom-diag-settings',
     *   logAnalyticsWorkspaceId: 'workspace-id',
     *   eventhubAuthorizationRuleId: 'auth-rule-id',
     *   eventhubName: 'eventhub-name',
     *   storageAccountId: 'storage-account-id'
     * });
     * ```
     */
    addDiagSettings(props) {
        return new diagsettings_1.DiagnosticSettings(this, "diagsettings", {
            name: props.name || "diag-settings",
            logAnalyticsWorkspaceId: props.logAnalyticsWorkspaceId,
            eventhubAuthorizationRuleId: props.eventhubAuthorizationRuleId,
            eventhubName: props.eventhubName,
            storageAccountId: props.storageAccountId,
            targetResourceId: this.id,
            logAnalyticsDestinationType: undefined,
            log: props?.log,
            metric: props?.metric,
        });
    }
    setupResourceGroup(props) {
        if (!props.resourceGroup) {
            // Create a new resource group
            const newResourceGroup = new resource_group_1.ResourceGroup(this, "rg", {
                name: `rg-${props.name}`,
                location: props.location || "eastus",
                tags: props.tags,
            });
            // Use the name of the new resource group
            return newResourceGroup;
        }
        else {
            // Use the provided resource group name
            return props.resourceGroup;
        }
    }
}
exports.AzureResource = AzureResource;
_a = JSII_RTTI_SYMBOL_1;
AzureResource[_a] = { fqn: "@microsoft/terraform-cdk-constructs.core_azure.AzureResource", version: "0.0.3-pre.12" };
class AzureResourceWithAlert extends AzureResource {
    addQueryRuleAlert(props) {
        new queryalert.QueryRuleAlert(this, "queryrulealert", {
            ...props,
            scopes: [this.id],
        });
    }
    addMetricAlert(props) {
        new metricalert.MetricAlert(this, "metricalert", {
            ...props,
            resourceGroup: this.resourceGroup,
            scopes: [this.id],
        });
    }
}
exports.AzureResourceWithAlert = AzureResourceWithAlert;
_b = JSII_RTTI_SYMBOL_1;
AzureResourceWithAlert[_b] = { fqn: "@microsoft/terraform-cdk-constructs.core_azure.AzureResourceWithAlert", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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