"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const container_registry_1 = require("@cdktf/provider-azurerm/lib/container-registry");
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
const lib_1 = require("../lib");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying an Azure Resource", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        class TestACR extends lib_1.AzureResource {
            constructor(scope, name, resourceGroup, location) {
                super(scope, name);
                const containerRegistry = new container_registry_1.ContainerRegistry(this, "containerRegistry", {
                    name: `acr${name}8898`,
                    resourceGroupName: resourceGroup.name,
                    location: location,
                    sku: "Basic",
                    adminEnabled: true,
                });
                this.id = containerRegistry.id;
                this.resourceGroup = resourceGroup;
            }
        }
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const acr = new TestACR(stack, `${randomName}`, resourceGroup, resourceGroup.location);
        // Test RBAC Methods
        acr.addAccess(clientConfig.objectId, "Contributor");
        acr.addAccess(clientConfig.objectId, "Monitoring Reader");
        const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(stack, "log_analytics", {
            location: "eastus",
            name: `la-${randomName}`,
            resourceGroupName: resourceGroup.name,
        });
        // Test Diag Settings
        acr.addDiagSettings({
            name: "diagsettings",
            logAnalyticsWorkspaceId: logAnalyticsWorkspace.id,
            metric: [
                {
                    category: "AllMetrics",
                },
            ],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if this can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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