/// <reference types="node" />
import { ExecSyncOptionsWithStringEncoding } from "child_process";
import { TerraformStack } from "cdktf";
import { Construct } from "constructs";
export declare class BaseTestStack extends TerraformStack {
    readonly name: string;
    constructor(scope: Construct, id: string);
}
export declare function execTerraformCommand(command: string, opts: ExecSyncOptionsWithStringEncoding, streamOutput: boolean): {
    stdout: string;
    stderr: string;
    exitCode: number;
};
export declare function TerraformApply(stack: any, streamOutput?: boolean): {
    stdout: string;
    stderr: string;
    error: any;
};
export declare function TerraformPlanExitCode(stack: any, streamOutput?: boolean): {
    stdout: string;
    stderr: string;
    exitCode: number;
    error: any;
};
export declare function TerraformIdempotentCheck(stack: any): AssertionReturn;
export declare function TerraformDestroy(stack: any, streamOutput?: boolean): AssertionReturn;
export declare function TerraformApplyAndCheckIdempotency(stack: any, streamOutput?: boolean): AssertionReturn;
export declare function TerraformApplyCheckAndDestroy(stack: any): void;
export declare function TerraformPlan(stack: any): AssertionReturn;
export declare class AssertionReturn {
    readonly message: string;
    readonly pass: boolean;
    /**
     * Create an AssertionReturn
     * @param message - String message containing information about the result of the assertion
     * @param pass - Boolean pass denoting the success of the assertion
     */
    constructor(message: string, pass: boolean);
}
export declare function cleanupCdkTfOutDirs(): void;
