"use strict";
// getAzureTenantId.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeTenantIdFromSnapshot = exports.getAzureTenantId = void 0;
const child_process_1 = require("child_process");
// Use Az CLI to collect TenantID, if not logged in substitute fake TenantID
function getAzureTenantId() {
    let tenantId;
    try {
        tenantId = (0, child_process_1.execSync)("az account show --query tenantId -o tsv")
            .toString()
            .trim();
    }
    catch (error) {
        console.log("Azure CLI is not logged in. Setting tenant ID to fake TenantID.");
        tenantId = "123e4567-e89b-12d3-a456-426614174000";
    }
    return tenantId;
}
exports.getAzureTenantId = getAzureTenantId;
// Removed TenantID from snapshot
function removeTenantIdFromSnapshot(obj) {
    for (let propName in obj) {
        if (propName === "tenant_id") {
            delete obj[propName];
        }
        else if (typeof obj[propName] === "object" && obj[propName] !== null) {
            removeTenantIdFromSnapshot(obj[propName]);
        }
    }
    return obj;
}
exports.removeTenantIdFromSnapshot = removeTenantIdFromSnapshot;
//# sourceMappingURL=data:application/json;base64,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