# Features for welds data type
WELDS_FEATURE_LIST = [
    "BP_CurrentCurve",
    "BP_VoltageCurve",
    "BP_ReferenceCurveLength",
    "BP_PSF",
    "BP_UIP",
    "BP_Energy",
    "BP_gunResistance",
    "BP_MaxResistance",
    "BP_ResistanceDrop",
    "BP_MeanVoltage",
    "BP_MeanPulse",
    "BP_MeanCurrent",
    "BP_meanCurrentSec",
    "BP_meanCurrentPrim",
    "BP_MeanResistance",
    "BP_Length",
    "BP_RmaxTime",
    "BP_ProtocolLogNo",
    "BP_spatterTime",
    "BP_MonitorStdActualValue",
    "BP_MonitorStdReferenceValue",
    "WP_WeldJobName",
    "WELD_ID",
    "WP_STCReference",
    "WP_GunResistance",
    "VEHICLE_ID",
    "WP_WeldTime",
    "WP_TimeMillisecond",
    "WP_TimerName",
    "WP_TipWearState",
    "WP_UnixEpoch",
    "WP_TipDressCount",
    "WP_TipWearCount",
    "WP_DiDt",
    "WP_Expulsion",
    "WP_Energy",
    "WP_Comment",
    "measurement_id",
    "inspection_id",
    "time_stamp_x",
    "nugget1",
    "nugget2",
    "indentation1",
    "indentation2",
    "frontplate1",
    "frontplate2",
    "stack1",
    "stack2",
    "pass_fg",
    "reason",
    "cscans",
    "meta_x",
    "time_stamp_y",
    "inspector_id",
    "inspection_mode",
    "meta_y",
    "update_status",
    "min_size",
    "setup_size",
    "min_ind",
    "max_ind",
    "stack_3T",
    "safety_fg",
    "robot_id",
    "robot_desc",
    "schedule",
    "cscans_integers",
    "cscan1",
    "cscan2",
    "resistance",
]

# Features for tabular classification data type
WELD_FEATURE_LIST = [
    "WP_ID",
    "WP_TIMERNAME",
    "WP_SPOTNAME",
    "WP_STCREFERENCE",
    "WP_UNIXEPOCH",
    "WP_TIPDRESSCOUNT",
    "WP_TIPWEARCOUNT",
    "WP_DIDT",
    "WP_EXPULSION",
    "WP_GUNRESISTANCE",
    "WP_TIPDIAMETER",
    "WP_TIPFACEDIAMETER",
    "WP_PARTIDENTIFIER",
    "WP_ENERGY",
    "WP_WELDTIME",
    "BP_MEANCURRENT",
    "BP_MEANVOLTAGE",
    "BP_MEANPULSE",
    "BP_MEANRESISTANCE",
    "BP_LENGTH",
    "BP_ENERGY",
    "BP_MAXRESISTANCE",
    "BP_RESISTANCEDROP",
    "BP_SEQCHKPARA",
    "BP_PSF",
    "BP_UIP",
    "BP_REFERENCECURVELENGTH",
    "BP_SPATTERTIME",
    "BP_GUNRESISTANCE",
    "BP_WELDPROTOCOL_LOG_T_ID",
    "BP_REFERENCEADAPTED",
    "BP_MEANCURRENTSEC",
    "BP_MEANCURRENTPRIM",
    "BP_RMAXTIME",
    "BP_MONITORSTDACTUALVALUE",
    "BP_MONITORSTDREFERENCEVALUE",
    "BP_MEANTORQUE",
    "DATA_TIMESTAMP",
    "MEASUREMENT_I D",
    "INSPECTION_ID",
    "NUGGET1",
    "NUGGET2",
    "INDENTATION1",
    "INDENTATION2",
    "FRONTPLATE1",
    "FRONTPLATE2",
    "STACK1",
    "STACK2",
    "PASS_FG",
    "REASON",
    "WELD_ID",
    "WELD_DESC",
    "MIN_SIZE",
    "SETUP_SIZE",
    "MIN_IND",
    "MAX_IND",
    "STACK_3T",
    "SAFETY_FG",
    "ROBOT_ID",
    "ROBOT_DESC",
    "SCHEDULE",
    "INSPECTION_DESC",
    "INSPECTOR_ID",
    "INSPECTION_MODE",
    "UPDATE_STATUS",
]

# Dictionary mapping dataset types to their feature lists
DATASET_FEATURE_MAPPING = {
    "welds_data": WELDS_FEATURE_LIST,
    "welds_inspections": WELDS_FEATURE_LIST,
    "weld_data": WELD_FEATURE_LIST,
}

# Methods available for feature interaction
METHOD_LIST = [
    "product",
    "ratio",
    "sum",
    "polynomial",
    "outlier simulation",
    "shuffle",
    "pca",
    "include",
    "exclude",
]

# Example usage format for each method
METHOD_EXAMPLES = {
    "product": "{'feature1': feature1, 'feature2': feature2, 'method': 'product'}",
    "ratio": "{'feature1': feature1, 'feature2': feature2, 'method': 'ratio'}",
    "sum": "{'feature1': feature1, 'feature2': feature2, 'method': 'sum'}",
    "polynomial": "{'feature1': feature1, 'feature2': feature2, 'method': 'polynomial'}",
    "outlier simulation": "{'feature1': feature1, 'feature2': None, 'method': 'outlier simulation'} or {'feature1': feature1, 'method': 'outlier simulation'}",
    "shuffle": "{'feature1': feature1, 'feature2': None, 'method': 'shuffle'} or {'feature1': feature1, 'method': 'shuffle'}",
    "pca": "{'feature1': feature1, 'feature2': None, 'method': 'pca'} or {'feature1': feature1, 'method': 'pca'}",
    "include": "{'feature_list': [feature1, feature2, ...], 'method': 'include'}",
    "exclude": "{'feature_list': [feature1, feature2, ...], 'method': 'exclude'}",
}
