"""add department mentions to comments

Revision ID: 0596674df51d
Revises: 9e5b3a9b0cee
Create Date: 2023-06-29 20:14:06.510015

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "0596674df51d"
down_revision = "9e5b3a9b0cee"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "comment_department_mentions",
        sa.Column(
            "comment",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "department",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["comment"],
            ["comment.id"],
        ),
        sa.ForeignKeyConstraint(
            ["department"],
            ["department.id"],
        ),
        sa.PrimaryKeyConstraint("comment", "department"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("comment_department_mentions")
    # ### end Alembic commands ###
