"""Fix schedule item

Revision ID: 10cf267d95c9
Revises: b45cb782bb9c
Create Date: 2019-08-21 17:11:00.542481

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
from sqlalchemy.dialects import postgresql
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "10cf267d95c9"
down_revision = "b45cb782bb9c"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "schedule_item",
        sa.Column(
            "object_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
    )
    op.create_index(
        op.f("ix_schedule_item_object_id"),
        "schedule_item",
        ["object_id"],
        unique=False,
    )
    op.drop_index("ix_schedule_item_entity_id", table_name="schedule_item")
    op.drop_constraint(
        "schedule_item_entity_id_fkey", "schedule_item", type_="foreignkey"
    )
    op.drop_column("schedule_item", "entity_id")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "schedule_item",
        sa.Column(
            "entity_id", postgresql.UUID(), autoincrement=False, nullable=True
        ),
    )
    op.create_foreign_key(
        "schedule_item_entity_id_fkey",
        "schedule_item",
        "entity",
        ["entity_id"],
        ["id"],
    )
    op.create_index(
        "ix_schedule_item_entity_id",
        "schedule_item",
        ["entity_id"],
        unique=False,
    )
    op.drop_index(
        op.f("ix_schedule_item_object_id"), table_name="schedule_item"
    )
    op.drop_column("schedule_item", "object_id")
    # ### end Alembic commands ###
