"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class AlbToLambda extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        defaults.CheckProps(props);
        if ((_b = props.listenerProps) === null || _b === void 0 ? void 0 : _b.certificateArns) {
            throw new Error('certificateArns is deprecated. Please supply certificates using props.listenerProps.certificates');
        }
        if ((props.existingLoadBalancerObj && (props.existingLoadBalancerObj.listeners.length === 0) || !props.existingLoadBalancerObj)
            && !props.listenerProps) {
            throw new Error("When adding the first listener and target to a load balancer, listenerProps must be specified and include at least a certificate or protocol: HTTP");
        }
        if (((props.existingLoadBalancerObj) && (props.existingLoadBalancerObj.listeners.length > 0)) &&
            props.listenerProps) {
            throw new Error("This load balancer already has a listener, listenerProps may not be specified");
        }
        if (((props.existingLoadBalancerObj) && (props.existingLoadBalancerObj.listeners.length > 0)) && !props.ruleProps) {
            throw new Error("When adding a second target to an existing listener, there must be rules provided");
        }
        // Check construct specific invalid inputs
        if (props.existingLoadBalancerObj && !props.existingVpc) {
            throw new Error("An existing ALB already exists in a VPC, that VPC must be provided in props.existingVpc for the rest of the construct to use.");
        }
        if (props.existingLoadBalancerObj) {
            defaults.printWarning("The public/private property of an exisng ALB must match the props.publicApi setting provided.");
        }
        // Obtain VPC for construct (existing or created)
        // Determine all the resources to use (existing or launch new)
        if (props.existingVpc) {
            this.vpc = props.existingVpc;
        }
        else {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: props.publicApi
                    ? defaults.DefaultPublicPrivateVpcProps()
                    : defaults.DefaultIsolatedVpcProps(),
                userVpcProps: props.vpcProps,
                constructVpcProps: props.publicApi
                    ? undefined
                    : { enableDnsHostnames: true, enableDnsSupport: true, },
            });
        }
        this.loadBalancer = defaults.ObtainAlb(this, id, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        // Obtain Lambda function for construct (existing or created)
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        if (this.loadBalancer.listeners.length === 0) {
            // This is a new listener, we need to create it along with the default target
            const newTargetGroup = defaults.CreateLambdaTargetGroup(this, `tg${this.loadBalancer.listeners.length + 1}`, this.lambdaFunction, props.targetProps);
            this.listener = defaults.AddListener(this, this.loadBalancer, newTargetGroup, props.listenerProps);
            // Testing occasionally caused a TargetGroup not found error, this
            // code ensures the Group will be complete before the Listener tries
            // to access it.
            const newListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            newListener.addDependsOn(cfnTargetGroup);
        }
        else {
            // We're adding a target to an existing listener. If this.loadBalancer.listeners.length
            // is >0, then this.loadBalancer was set from existingLoadBalancer
            this.listener = GetActiveListener(this.loadBalancer.listeners);
            defaults.AddTarget(this, defaults.CreateLambdaTargetGroup(this, `tg${this.loadBalancer.listeners.length + 1}`, this.lambdaFunction, props.targetProps), this.listener, props.ruleProps);
        }
    }
}
exports.AlbToLambda = AlbToLambda;
_a = JSII_RTTI_SYMBOL_1;
AlbToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-alb-lambda.AlbToLambda", version: "1.129.0" };
function GetActiveListener(listeners) {
    let listener;
    if (listeners.length === 1) {
        listener = listeners[0];
    }
    else {
        const correctListener = listeners.find(i => i.node.children[0].protocol === "HTTPS");
        if (correctListener) {
            listener = correctListener;
        }
        else {
            // This line should be unreachable
            throw new Error(`Two listeners in the ALB, but neither are HTTPS`);
        }
    }
    return listener;
}
//# sourceMappingURL=data:application/json;base64,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