# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/jerx.fewshot.llm.ipynb.

# %% auto 0
__all__ = ['log', 'DEFAULT_JERX_SYSTEM_MESSAGE_TEMPLATE_FOR_GPT', 'DEFAULT_JERX_CHAT_TEMPLATE_FOR_GPT',
           'DEFAULT_JERX_SYSTEM_MESSAGE_TEMPLATE_FOR_LLAMA', 'DEFAULT_JERX_CHAT_TEMPLATE_FOR_LLAMA',
           'parse_triplet_response', 'make_kg_triplet_extract_fn']

# %% ../../../nbs/jerx.fewshot.llm.ipynb 3
from llama_index.prompts import ChatPromptTemplate
from llama_index.llms import ChatMessage, OpenAI, LLM
from ..utils import parse_triplets
from ...logging import get_logger

log = get_logger(__name__)

# %% ../../../nbs/jerx.fewshot.llm.ipynb 5
DEFAULT_JERX_SYSTEM_MESSAGE_TEMPLATE_FOR_GPT = """
You are an excellent joint entity-relation extraction algorithm. Your extract knowledge triplets in the form of (subject, relation, object) from user's messages. The goal is to create a network of entities and their interrelations that enables answering complex, multi-hop questions. This requires careful analysis to identify and categorize entities (such as individuals, locations, organizations) and the specific, nuanced relationships between them.

# Guidelines
The goal is to build a detailed and accurate map of entities and their interrelations, enabling a comprehensive understanding of the document's content and supporting the answering of detailed, multi-hop questions derived from or related to the document. Prepare to adapt your extraction techniques to the nuances and specifics presented by the document, recognizing the diversity in structures and styles across documents.

# Core Objectives
- **Comprehensive Entity and Relation Identification**: Systematically identify all relevant entities and their relationships within the document. Each entity and relation must be captured with precision, reflecting the document's depth of information.

- **Entity Differentiation and Categorization**: Distinguish between different types of entities, avoiding the amalgamation of distinct entities into a single category. For instance, separate individuals from their professions or titles and define their relationship clearly.

- **Clarification of Relationships and Avoidance of Redundancy**: Ensure each relationship is clearly defined, avoiding duplicate information. Relations should form a coherent, logical network, mapping connections between entities accurately, especially in hierarchical or geographic contexts.

- **Inference of Implicit Relations**: Infer and articulate relations that are implied but not explicitly stated within the document. This nuanced understanding allows for a richer, more interconnected entity-relation map.

- **Consistency and Cross-Validation**: Maintain consistency in entity references throughout the document and cross-validate entities and relations for accuracy. This includes harmonizing multiple references to the same entity and ensuring the entity-relation map is free from contradictions.

- **Detail-Oriented Relation Extraction**: Pay attention to the details within relations, capturing temporal and quantitative aspects where relevant. This adds depth to the understanding of each relationship, enhancing the capability to answer nuanced questions. Capture date and time relations with full detail as much as possible.

# Disambiguation and Unique Identification:
- **Explicit Disambiguation of Identical Names**: When encountering entities with identical names, explicitly disambiguate them by adding context-specific qualifiers in parentheses. These qualifiers should reflect the nature or category of the entity to prevent confusion and ensure clear differentiation. For example, differentiate geographical locations from non-geographical entities, people from non-person entities, and temporal from non-temporal entities with appropriate qualifiers.

# Formatting
- Avoid stopwords.
- Encode dates in the format: January 1, 1990
- Employ the format: `entity1 | relation | entity2` for each extracted relation, ensuring clarity and precision in representation. Each triplet should be in a new line.
""".strip()


DEFAULT_JERX_CHAT_TEMPLATE_FOR_GPT = ChatPromptTemplate(
    message_templates=[
        ChatMessage(role="system", content=DEFAULT_JERX_SYSTEM_MESSAGE_TEMPLATE_FOR_GPT),
        ChatMessage(
            role="user",
            content="""
Glenhis Hernández (born 7 October 1990 in Havana) is a taekwondo practitioner from Cuba. She was the 2013 World
Champion in middleweight.

The current mayor of Havana ("President of the People's Power Provincial Assembly") is Marta Hernández Romero, she
was elected on March 5, 2011.
""".strip(),
        ),
        ChatMessage(
            role="assistant",
            content="""
Glenhis Hernández (Athlete) | born on | October 7, 1990
Glenhis Hernández (Athlete) | birth place | Havana
Glenhis Hernández (Athlete) | specializes in | taekwondo
Glenhis Hernández (Athlete) | won | 2013 World Champion title (Middleweight)
Marta Hernández Romero (Politician) | serves as | mayor of Havana
Marta Hernández Romero (Politician) | holds | the position of "President of the People's Power Provincial Assembly"
Marta Hernández Romero (Politician) | elected on | March 5, 2011.
""".strip(),
        ),
        ChatMessage(role="user", content="Alvinegro is the nickname of Agremiação Sportiva Arapiraquense."),
        ChatMessage(role="assistant", content="Agremiação Sportiva Arapiraquense | nickname | Alvinegro"),
        ChatMessage(
            role="user",
            content="Sausage is a main ingredient of Bacon Explosion but it also uses bacon. The icebreaker Aleksey Chirikov is 99.83 metres long. The country of Akron, Ohio, is United States, where Asian Americans are one of the ethnic groups.",
        ),
        ChatMessage(
            role="assistant",
            content="Bacon Explosion | ingredient | Bacon\nBacon Explosion | main ingredient | Sausage\nAleksey Chirikov (icebreaker) | length | 99.83\nUnited States | ethnic group | Asian Americans\nAkron, Ohio | country | United States",
        ),
        ChatMessage(role="user", content="{text}"),
    ]
)

# %% ../../../nbs/jerx.fewshot.llm.ipynb 6
DEFAULT_JERX_SYSTEM_MESSAGE_TEMPLATE_FOR_LLAMA = """
You are an excellent knowledge graph construction agent. Extract knowledge triplets in the form of (subject, relation, object) from user's messages. Avoid stopwords. Use ' | ' as delimiter and provide one triplet per line.
""".strip()


DEFAULT_JERX_CHAT_TEMPLATE_FOR_LLAMA = ChatPromptTemplate(
    message_templates=[
        ChatMessage(role="system", content=DEFAULT_JERX_SYSTEM_MESSAGE_TEMPLATE_FOR_LLAMA),
        ChatMessage(
            role="user",
            content="""
Glenhis Hernández (born 7 October 1990 in Havana) is a taekwondo practitioner from Cuba. She was the 2013 World
Champion in middleweight.

The current mayor of Havana ("President of the People's Power Provincial Assembly") is Marta Hernández Romero, she
was elected on March 5, 2011.
""".strip(),
        ),
        ChatMessage(
            role="assistant",
            content="""
Glenhis Hernández (Athlete) | born on | October 7, 1990
Glenhis Hernández (Athlete) | birth place | Havana
Glenhis Hernández (Athlete) | specializes in | taekwondo
Glenhis Hernández (Athlete) | won | 2013 World Champion title (Middleweight)
Marta Hernández Romero (Politician) | serves as | mayor of Havana
Marta Hernández Romero (Politician) | holds | the position of "President of the People's Power Provincial Assembly"
Marta Hernández Romero (Politician) | elected on | March 5, 2011.
""".strip(),
        ),
        ChatMessage(role="user", content="Alvinegro is the nickname of Agremiação Sportiva Arapiraquense."),
        ChatMessage(role="assistant", content="Agremiação Sportiva Arapiraquense | nickname | Alvinegro"),
        ChatMessage(
            role="user",
            content="Sausage is a main ingredient of Bacon Explosion but it also uses bacon. The icebreaker Aleksey Chirikov is 99.83 metres long. The country of Akron, Ohio, is United States, where Asian Americans are one of the ethnic groups.",
        ),
        ChatMessage(
            role="assistant",
            content="Bacon Explosion | ingredient | Bacon\nBacon Explosion | main ingredient | Sausage\nAleksey Chirikov (icebreaker) | length | 99.83\nUnited States | ethnic group | Asian Americans\nAkron, Ohio | country | United States",
        ),
        ChatMessage(role="user", content="{text}"),
    ]
)

# %% ../../../nbs/jerx.fewshot.llm.ipynb 7
def parse_triplet_response(response: str, *args, **kwargs) -> list[tuple[str, str, str]]:
    triplets = parse_triplets(response.strip())
    return [(e1, rel, e2) if e1 != e2 else (e1, rel, e2 + "(obj)") for e1, rel, e2 in triplets]


def make_kg_triplet_extract_fn(
    *,
    llm: LLM | None = None,
    chat_template: ChatPromptTemplate | None = None,
):
    if llm is None:
        llm = OpenAI(model="gpt-3.5-turbo")
    
    if chat_template is None:
        if "gpt" in llm.model:
            chat_template = DEFAULT_JERX_CHAT_TEMPLATE_FOR_GPT
        elif "llama" in llm.model:
            chat_template = DEFAULT_JERX_CHAT_TEMPLATE_FOR_LLAMA
        else:
            raise ValueError(f"Unsupported model name: {llm.model}")

    def extract_kg_triplets(text: str) -> list[tuple[str, str, str]]:
        messages = chat_template.format_messages(text=text)
        response = llm.chat(messages)
        return parse_triplet_response(response.message.content)

    return extract_kg_triplets
