import os
import sys
import imp
__parameters_path__ = os.path.join( os.path.dirname(os.path.realpath(__file__)), "pdbParserParams.py")



def get_parameters():
    if not os.path.exists(__parameters_path__):
        write_parameters(params={})
    # load and return
    (path, name) = os.path.split(__parameters_path__)
    (name, ext) = os.path.splitext(name)
    (file, filename, data) = imp.find_module(name, [path])
    try:
        mod = imp.load_module(name, file, filename, data)
    except:
        raise Exception("Unable to load module '%s'"%filename)
    return mod.parameters
    

def write_parameters(params=None, insureVMD=True):
    if params is None:
        params={}
    assert isinstance(params, dict), "params must be a dict"
    # open file
    try:
        fd = open(__parameters_path__, 'w')
    except:
        raise Exception("Can't open %s for writing"%__parameters_path__)
    # check if vmd path parameter exists, if not guess it as the following hoping that VMD is installed
    if not params.has_key('VMD_PATH') and insureVMD:
        if sys.platform == "win32":
            params["VMD_PATH"] = '"C:\\Program Files (x86)\\University of Illinois\\VMD\\vmd.exe"'
        elif sys.platform == "darwin":
            params["VMD_PATH"] = "/Applications/VMD 1.9.2.app/Contents/vmd/vmd_MACOSXX86"
        else:
            params["VMD_PATH"] = "/usr/local/bin/vmd"
    # write lines
    lines  = "# This file is generated by pdbParser" + "\n"
    lines += "parameters = {}" + "\n"
    for k, v in params.items():
        if isinstance(k, basestring):
            if isinstance(v, basestring):
                lines += "parameters['%s'] = '%s'\n"%(k.encode('string-escape'), v.encode('string-escape'))
            else:
                lines += "parameters['%s'] = %s\n"%(k.encode('string-escape'), v)
        elif isinstance(v, basestring):
            lines += "parameters[%s] = '%s'\n"%(k, v.encode('string-escape'))
        else:
            lines += "parameters[%s] = %s\n"%(k, v)
    # write params        
    fd.write(lines)  
    fd.close()
        
def update_parameters(params):
    p = get_parameters()
    p.update(params)
    write_parameters(params)
    
def set_vmd_path(path):
    params = get_parameters()
    params["VMD_PATH"] = path
    write_parameters(params)

def get_parameter_value(key):
    params = get_parameters()
    return params.get(key, None)
    
    
    
    
    
    
    
    
