# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodePoolOptionResult',
    'AwaitableGetNodePoolOptionResult',
    'get_node_pool_option',
    'get_node_pool_option_output',
]

@pulumi.output_type
class GetNodePoolOptionResult:
    """
    A collection of values returned by getNodePoolOption.
    """
    def __init__(__self__, compartment_id=None, id=None, images=None, kubernetes_versions=None, node_pool_option_id=None, shapes=None, sources=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if kubernetes_versions and not isinstance(kubernetes_versions, list):
            raise TypeError("Expected argument 'kubernetes_versions' to be a list")
        pulumi.set(__self__, "kubernetes_versions", kubernetes_versions)
        if node_pool_option_id and not isinstance(node_pool_option_id, str):
            raise TypeError("Expected argument 'node_pool_option_id' to be a str")
        pulumi.set(__self__, "node_pool_option_id", node_pool_option_id)
        if shapes and not isinstance(shapes, list):
            raise TypeError("Expected argument 'shapes' to be a list")
        pulumi.set(__self__, "shapes", shapes)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence[str]:
        """
        Deprecated. See sources. When creating a node pool, only image names contained in this property can be passed to the `node_image_name` property.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="kubernetesVersions")
    def kubernetes_versions(self) -> Sequence[str]:
        """
        Available Kubernetes versions.
        """
        return pulumi.get(self, "kubernetes_versions")

    @property
    @pulumi.getter(name="nodePoolOptionId")
    def node_pool_option_id(self) -> str:
        return pulumi.get(self, "node_pool_option_id")

    @property
    @pulumi.getter
    def shapes(self) -> Sequence[str]:
        """
        Available shapes for nodes.
        """
        return pulumi.get(self, "shapes")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetNodePoolOptionSourceResult']:
        """
        Available source of the node.
        """
        return pulumi.get(self, "sources")


class AwaitableGetNodePoolOptionResult(GetNodePoolOptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodePoolOptionResult(
            compartment_id=self.compartment_id,
            id=self.id,
            images=self.images,
            kubernetes_versions=self.kubernetes_versions,
            node_pool_option_id=self.node_pool_option_id,
            shapes=self.shapes,
            sources=self.sources)


def get_node_pool_option(compartment_id: Optional[str] = None,
                         node_pool_option_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodePoolOptionResult:
    """
    This data source provides details about a specific Node Pool Option resource in Oracle Cloud Infrastructure Container Engine service.

    Get options available for node pools.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_node_pool_option = oci.ContainerEngine.get_node_pool_option(node_pool_option_id=test_node_pool_option_oci_containerengine_node_pool_option["id"],
        compartment_id=compartment_id)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str node_pool_option_id: The id of the option set to retrieve. Use "all" get all options, or use a cluster ID to get options specific to the provided cluster.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['nodePoolOptionId'] = node_pool_option_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getNodePoolOption:getNodePoolOption', __args__, opts=opts, typ=GetNodePoolOptionResult).value

    return AwaitableGetNodePoolOptionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        images=pulumi.get(__ret__, 'images'),
        kubernetes_versions=pulumi.get(__ret__, 'kubernetes_versions'),
        node_pool_option_id=pulumi.get(__ret__, 'node_pool_option_id'),
        shapes=pulumi.get(__ret__, 'shapes'),
        sources=pulumi.get(__ret__, 'sources'))


@_utilities.lift_output_func(get_node_pool_option)
def get_node_pool_option_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                node_pool_option_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNodePoolOptionResult]:
    """
    This data source provides details about a specific Node Pool Option resource in Oracle Cloud Infrastructure Container Engine service.

    Get options available for node pools.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_node_pool_option = oci.ContainerEngine.get_node_pool_option(node_pool_option_id=test_node_pool_option_oci_containerengine_node_pool_option["id"],
        compartment_id=compartment_id)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str node_pool_option_id: The id of the option set to retrieve. Use "all" get all options, or use a cluster ID to get options specific to the provided cluster.
    """
    ...
