# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFastConnectProviderServicesResult',
    'AwaitableGetFastConnectProviderServicesResult',
    'get_fast_connect_provider_services',
    'get_fast_connect_provider_services_output',
]

@pulumi.output_type
class GetFastConnectProviderServicesResult:
    """
    A collection of values returned by getFastConnectProviderServices.
    """
    def __init__(__self__, compartment_id=None, fast_connect_provider_services=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if fast_connect_provider_services and not isinstance(fast_connect_provider_services, list):
            raise TypeError("Expected argument 'fast_connect_provider_services' to be a list")
        pulumi.set(__self__, "fast_connect_provider_services", fast_connect_provider_services)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="fastConnectProviderServices")
    def fast_connect_provider_services(self) -> Sequence['outputs.GetFastConnectProviderServicesFastConnectProviderServiceResult']:
        """
        The list of fast_connect_provider_services.
        """
        return pulumi.get(self, "fast_connect_provider_services")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFastConnectProviderServicesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetFastConnectProviderServicesResult(GetFastConnectProviderServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFastConnectProviderServicesResult(
            compartment_id=self.compartment_id,
            fast_connect_provider_services=self.fast_connect_provider_services,
            filters=self.filters,
            id=self.id)


def get_fast_connect_provider_services(compartment_id: Optional[str] = None,
                                       filters: Optional[Sequence[pulumi.InputType['GetFastConnectProviderServicesFilterArgs']]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFastConnectProviderServicesResult:
    """
    This data source provides the list of Fast Connect Provider Services in Oracle Cloud Infrastructure Core service.

    Lists the service offerings from supported providers. You need this
    information so you can specify your desired provider and service
    offering when you create a virtual circuit.

    For the compartment ID, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of your tenancy (the root compartment).

    For more information, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fast_connect_provider_services = oci.Core.get_fast_connect_provider_services(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getFastConnectProviderServices:getFastConnectProviderServices', __args__, opts=opts, typ=GetFastConnectProviderServicesResult).value

    return AwaitableGetFastConnectProviderServicesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        fast_connect_provider_services=pulumi.get(__ret__, 'fast_connect_provider_services'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_fast_connect_provider_services)
def get_fast_connect_provider_services_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFastConnectProviderServicesFilterArgs']]]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFastConnectProviderServicesResult]:
    """
    This data source provides the list of Fast Connect Provider Services in Oracle Cloud Infrastructure Core service.

    Lists the service offerings from supported providers. You need this
    information so you can specify your desired provider and service
    offering when you create a virtual circuit.

    For the compartment ID, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of your tenancy (the root compartment).

    For more information, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fast_connect_provider_services = oci.Core.get_fast_connect_provider_services(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    ...
