# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetInfrastructureTargetVersionResult',
    'AwaitableGetInfrastructureTargetVersionResult',
    'get_infrastructure_target_version',
    'get_infrastructure_target_version_output',
]

@pulumi.output_type
class GetInfrastructureTargetVersionResult:
    """
    A collection of values returned by getInfrastructureTargetVersion.
    """
    def __init__(__self__, compartment_id=None, id=None, target_db_version_history_entries=None, target_resource_id=None, target_resource_type=None, target_storage_version_history_entries=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if target_db_version_history_entries and not isinstance(target_db_version_history_entries, list):
            raise TypeError("Expected argument 'target_db_version_history_entries' to be a list")
        pulumi.set(__self__, "target_db_version_history_entries", target_db_version_history_entries)
        if target_resource_id and not isinstance(target_resource_id, str):
            raise TypeError("Expected argument 'target_resource_id' to be a str")
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_type and not isinstance(target_resource_type, str):
            raise TypeError("Expected argument 'target_resource_type' to be a str")
        pulumi.set(__self__, "target_resource_type", target_resource_type)
        if target_storage_version_history_entries and not isinstance(target_storage_version_history_entries, list):
            raise TypeError("Expected argument 'target_storage_version_history_entries' to be a list")
        pulumi.set(__self__, "target_storage_version_history_entries", target_storage_version_history_entries)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="targetDbVersionHistoryEntries")
    def target_db_version_history_entries(self) -> Sequence[str]:
        """
        The history entry of the target system software version for the database server patching operation.
        """
        return pulumi.get(self, "target_db_version_history_entries")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[str]:
        """
        The OCID of the target Exadata Infrastructure resource that will receive the maintenance update.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[str]:
        """
        The resource type of the target Exadata infrastructure resource that will receive the system software update.
        """
        return pulumi.get(self, "target_resource_type")

    @property
    @pulumi.getter(name="targetStorageVersionHistoryEntries")
    def target_storage_version_history_entries(self) -> Sequence[str]:
        """
        The history entry of the target storage cell system software version for the storage cell patching operation.
        """
        return pulumi.get(self, "target_storage_version_history_entries")


class AwaitableGetInfrastructureTargetVersionResult(GetInfrastructureTargetVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInfrastructureTargetVersionResult(
            compartment_id=self.compartment_id,
            id=self.id,
            target_db_version_history_entries=self.target_db_version_history_entries,
            target_resource_id=self.target_resource_id,
            target_resource_type=self.target_resource_type,
            target_storage_version_history_entries=self.target_storage_version_history_entries)


def get_infrastructure_target_version(compartment_id: Optional[str] = None,
                                      target_resource_id: Optional[str] = None,
                                      target_resource_type: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInfrastructureTargetVersionResult:
    """
    This data source provides details about a specific Infrastructure Target Version resource in Oracle Cloud Infrastructure Database service.

    Gets details of the Exadata Infrastructure target system software versions that can be applied to the specified infrastructure resource for maintenance updates.
    Applies to Exadata Cloud@Customer and Exadata Cloud instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_infrastructure_target_version = oci.Database.get_infrastructure_target_version(compartment_id=compartment_id,
        target_resource_id=test_target_resource["id"],
        target_resource_type=infrastructure_target_version_target_resource_type)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str target_resource_id: The target resource ID.
    :param str target_resource_type: The type of the target resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['targetResourceId'] = target_resource_id
    __args__['targetResourceType'] = target_resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getInfrastructureTargetVersion:getInfrastructureTargetVersion', __args__, opts=opts, typ=GetInfrastructureTargetVersionResult).value

    return AwaitableGetInfrastructureTargetVersionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        target_db_version_history_entries=pulumi.get(__ret__, 'target_db_version_history_entries'),
        target_resource_id=pulumi.get(__ret__, 'target_resource_id'),
        target_resource_type=pulumi.get(__ret__, 'target_resource_type'),
        target_storage_version_history_entries=pulumi.get(__ret__, 'target_storage_version_history_entries'))


@_utilities.lift_output_func(get_infrastructure_target_version)
def get_infrastructure_target_version_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                             target_resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                                             target_resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInfrastructureTargetVersionResult]:
    """
    This data source provides details about a specific Infrastructure Target Version resource in Oracle Cloud Infrastructure Database service.

    Gets details of the Exadata Infrastructure target system software versions that can be applied to the specified infrastructure resource for maintenance updates.
    Applies to Exadata Cloud@Customer and Exadata Cloud instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_infrastructure_target_version = oci.Database.get_infrastructure_target_version(compartment_id=compartment_id,
        target_resource_id=test_target_resource["id"],
        target_resource_type=infrastructure_target_version_target_resource_type)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str target_resource_id: The target resource ID.
    :param str target_resource_type: The type of the target resource.
    """
    ...
