# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCustomerSecretKeysResult',
    'AwaitableGetCustomerSecretKeysResult',
    'get_customer_secret_keys',
    'get_customer_secret_keys_output',
]

@pulumi.output_type
class GetCustomerSecretKeysResult:
    """
    A collection of values returned by getCustomerSecretKeys.
    """
    def __init__(__self__, customer_secret_keys=None, filters=None, id=None, user_id=None):
        if customer_secret_keys and not isinstance(customer_secret_keys, list):
            raise TypeError("Expected argument 'customer_secret_keys' to be a list")
        pulumi.set(__self__, "customer_secret_keys", customer_secret_keys)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="customerSecretKeys")
    def customer_secret_keys(self) -> Sequence['outputs.GetCustomerSecretKeysCustomerSecretKeyResult']:
        """
        The list of customer_secret_keys.
        """
        return pulumi.get(self, "customer_secret_keys")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCustomerSecretKeysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The OCID of the user the password belongs to.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetCustomerSecretKeysResult(GetCustomerSecretKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomerSecretKeysResult(
            customer_secret_keys=self.customer_secret_keys,
            filters=self.filters,
            id=self.id,
            user_id=self.user_id)


def get_customer_secret_keys(filters: Optional[Sequence[pulumi.InputType['GetCustomerSecretKeysFilterArgs']]] = None,
                             user_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomerSecretKeysResult:
    """
    This data source provides the list of Customer Secret Keys in Oracle Cloud Infrastructure Identity service.

    Lists the secret keys for the specified user. The returned object contains the secret key's OCID, but not
    the secret key itself. The actual secret key is returned only upon creation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_customer_secret_keys = oci.Identity.get_customer_secret_keys(user_id=test_user["id"])
    ```


    :param str user_id: The OCID of the user.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getCustomerSecretKeys:getCustomerSecretKeys', __args__, opts=opts, typ=GetCustomerSecretKeysResult).value

    return AwaitableGetCustomerSecretKeysResult(
        customer_secret_keys=pulumi.get(__ret__, 'customer_secret_keys'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        user_id=pulumi.get(__ret__, 'user_id'))


@_utilities.lift_output_func(get_customer_secret_keys)
def get_customer_secret_keys_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetCustomerSecretKeysFilterArgs']]]]] = None,
                                    user_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomerSecretKeysResult]:
    """
    This data source provides the list of Customer Secret Keys in Oracle Cloud Infrastructure Identity service.

    Lists the secret keys for the specified user. The returned object contains the secret key's OCID, but not
    the secret key itself. The actual secret key is returned only upon creation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_customer_secret_keys = oci.Identity.get_customer_secret_keys(user_id=test_user["id"])
    ```


    :param str user_id: The OCID of the user.
    """
    ...
