# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmArgs', 'Alarm']

@pulumi.input_type
class AlarmArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 destinations: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 metric_compartment_id: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 query: pulumi.Input[str],
                 severity: pulumi.Input[str],
                 body: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_notifications_per_metric_dimension_enabled: Optional[pulumi.Input[bool]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 metric_compartment_id_in_subtree: Optional[pulumi.Input[bool]] = None,
                 notification_version: Optional[pulumi.Input[str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]]] = None,
                 pending_duration: Optional[pulumi.Input[str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 suppression: Optional[pulumi.Input['AlarmSuppressionArgs']] = None):
        """
        The set of arguments for constructing a Alarm resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the alarm. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               This value determines the title of each alarm notification.
               
               Example: `High CPU Utilization`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the alarm is enabled.  Example: `true`
        :param pulumi.Input[str] metric_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        :param pulumi.Input[str] namespace: (Updatable) The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        :param pulumi.Input[str] query: (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
               
               Example of threshold alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85
               
               -----
               
               Example of absence alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()
               
               -----
        :param pulumi.Input[str] severity: (Updatable) The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        :param pulumi.Input[str] body: (Updatable) The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_notifications_per_metric_dimension_enabled: (Updatable) When set to `true`, splits alarm notifications per metric stream. When set to `false`, groups alarm notifications across metric streams. Example: `true`
        :param pulumi.Input[str] message_format: (Updatable) The format to use for alarm notifications. The formats are:
        :param pulumi.Input[bool] metric_compartment_id_in_subtree: (Updatable) When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        :param pulumi.Input[str] notification_version: (Updatable) The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]] overrides: (Updatable) A set of overrides that control evaluations of the alarm. 
               
               Each override can specify values for query, severity, body, and pending duration. When an alarm contains overrides, the Monitoring service evaluates each override in order, beginning with the first override in the array (index position `0`), and then evaluates the alarm's base values (`ruleName` value of `BASE`).
        :param pulumi.Input[str] pending_duration: (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
               
               The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.
               
               Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".
               
               The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.
               
               Example: `PT5M`
        :param pulumi.Input[str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.
               
               Default value: null (notifications are not re-submitted).
               
               Example: `PT2H`
        :param pulumi.Input[str] resolution: (Updatable) The time between calculated aggregation windows for the alarm. Supported value: `1m`
        :param pulumi.Input[str] resource_group: (Updatable) Resource group that you want to match. A null value returns only metric data that has no resource groups. The alarm retrieves metric data associated with the specified resource group only. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($). Avoid entering confidential information.  Example: `frontend-fleet`
        :param pulumi.Input[str] rule_name: (Updatable) Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  A valid ruleName value starts with an alphabetic character and includes only alphanumeric characters, underscores and square brackets.  Minimum number of characters: 3. Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param pulumi.Input['AlarmSuppressionArgs'] suppression: (Updatable) The configuration details for suppressing an alarm.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "metric_compartment_id", metric_compartment_id)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "severity", severity)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_notifications_per_metric_dimension_enabled is not None:
            pulumi.set(__self__, "is_notifications_per_metric_dimension_enabled", is_notifications_per_metric_dimension_enabled)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if metric_compartment_id_in_subtree is not None:
            pulumi.set(__self__, "metric_compartment_id_in_subtree", metric_compartment_id_in_subtree)
        if notification_version is not None:
            pulumi.set(__self__, "notification_version", notification_version)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if pending_duration is not None:
            pulumi.set(__self__, "pending_duration", pending_duration)
        if repeat_notification_duration is not None:
            pulumi.set(__self__, "repeat_notification_duration", repeat_notification_duration)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if suppression is not None:
            pulumi.set(__self__, "suppression", suppression)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name for the alarm. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        This value determines the title of each alarm notification.

        Example: `High CPU Utilization`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) Whether the alarm is enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="metricCompartmentId")
    def metric_compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        """
        return pulumi.get(self, "metric_compartment_id")

    @metric_compartment_id.setter
    def metric_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_compartment_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----

        Example of absence alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()

        -----
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[str]:
        """
        (Updatable) The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[str]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isNotificationsPerMetricDimensionEnabled")
    def is_notifications_per_metric_dimension_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) When set to `true`, splits alarm notifications per metric stream. When set to `false`, groups alarm notifications across metric streams. Example: `true`
        """
        return pulumi.get(self, "is_notifications_per_metric_dimension_enabled")

    @is_notifications_per_metric_dimension_enabled.setter
    def is_notifications_per_metric_dimension_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_notifications_per_metric_dimension_enabled", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The format to use for alarm notifications. The formats are:
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="metricCompartmentIdInSubtree")
    def metric_compartment_id_in_subtree(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        """
        return pulumi.get(self, "metric_compartment_id_in_subtree")

    @metric_compartment_id_in_subtree.setter
    def metric_compartment_id_in_subtree(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "metric_compartment_id_in_subtree", value)

    @property
    @pulumi.getter(name="notificationVersion")
    def notification_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        """
        return pulumi.get(self, "notification_version")

    @notification_version.setter
    def notification_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_version", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]]]:
        """
        (Updatable) A set of overrides that control evaluations of the alarm. 

        Each override can specify values for query, severity, body, and pending duration. When an alarm contains overrides, the Monitoring service evaluates each override in order, beginning with the first override in the array (index position `0`), and then evaluates the alarm's base values (`ruleName` value of `BASE`).
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.

        Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".

        The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.

        Example: `PT5M`
        """
        return pulumi.get(self, "pending_duration")

    @pending_duration.setter
    def pending_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pending_duration", value)

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.

        Default value: null (notifications are not re-submitted).

        Example: `PT2H`
        """
        return pulumi.get(self, "repeat_notification_duration")

    @repeat_notification_duration.setter
    def repeat_notification_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_notification_duration", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time between calculated aggregation windows for the alarm. Supported value: `1m`
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolution", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Resource group that you want to match. A null value returns only metric data that has no resource groups. The alarm retrieves metric data associated with the specified resource group only. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($). Avoid entering confidential information.  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  A valid ruleName value starts with an alphabetic character and includes only alphanumeric characters, underscores and square brackets.  Minimum number of characters: 3. Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def suppression(self) -> Optional[pulumi.Input['AlarmSuppressionArgs']]:
        """
        (Updatable) The configuration details for suppressing an alarm.
        """
        return pulumi.get(self, "suppression")

    @suppression.setter
    def suppression(self, value: Optional[pulumi.Input['AlarmSuppressionArgs']]):
        pulumi.set(self, "suppression", value)


@pulumi.input_type
class _AlarmState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 is_notifications_per_metric_dimension_enabled: Optional[pulumi.Input[bool]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 metric_compartment_id: Optional[pulumi.Input[str]] = None,
                 metric_compartment_id_in_subtree: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 notification_version: Optional[pulumi.Input[str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]]] = None,
                 pending_duration: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 suppression: Optional[pulumi.Input['AlarmSuppressionArgs']] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Alarm resources.
        :param pulumi.Input[str] body: (Updatable) The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the alarm. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               This value determines the title of each alarm notification.
               
               Example: `High CPU Utilization`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the alarm is enabled.  Example: `true`
        :param pulumi.Input[bool] is_notifications_per_metric_dimension_enabled: (Updatable) When set to `true`, splits alarm notifications per metric stream. When set to `false`, groups alarm notifications across metric streams. Example: `true`
        :param pulumi.Input[str] message_format: (Updatable) The format to use for alarm notifications. The formats are:
        :param pulumi.Input[str] metric_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        :param pulumi.Input[bool] metric_compartment_id_in_subtree: (Updatable) When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        :param pulumi.Input[str] namespace: (Updatable) The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        :param pulumi.Input[str] notification_version: (Updatable) The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]] overrides: (Updatable) A set of overrides that control evaluations of the alarm. 
               
               Each override can specify values for query, severity, body, and pending duration. When an alarm contains overrides, the Monitoring service evaluates each override in order, beginning with the first override in the array (index position `0`), and then evaluates the alarm's base values (`ruleName` value of `BASE`).
        :param pulumi.Input[str] pending_duration: (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
               
               The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.
               
               Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".
               
               The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.
               
               Example: `PT5M`
        :param pulumi.Input[str] query: (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
               
               Example of threshold alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85
               
               -----
               
               Example of absence alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()
               
               -----
        :param pulumi.Input[str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.
               
               Default value: null (notifications are not re-submitted).
               
               Example: `PT2H`
        :param pulumi.Input[str] resolution: (Updatable) The time between calculated aggregation windows for the alarm. Supported value: `1m`
        :param pulumi.Input[str] resource_group: (Updatable) Resource group that you want to match. A null value returns only metric data that has no resource groups. The alarm retrieves metric data associated with the specified resource group only. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($). Avoid entering confidential information.  Example: `frontend-fleet`
        :param pulumi.Input[str] rule_name: (Updatable) Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  A valid ruleName value starts with an alphabetic character and includes only alphanumeric characters, underscores and square brackets.  Minimum number of characters: 3. Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param pulumi.Input[str] severity: (Updatable) The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        :param pulumi.Input[str] state: The current lifecycle state of the alarm.  Example: `DELETED`
        :param pulumi.Input['AlarmSuppressionArgs'] suppression: (Updatable) The configuration details for suppressing an alarm.
        :param pulumi.Input[str] time_created: The date and time the alarm was created. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the alarm was last updated. Format defined by RFC3339.  Example: `2023-02-03T01:02:29.600Z`
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if is_notifications_per_metric_dimension_enabled is not None:
            pulumi.set(__self__, "is_notifications_per_metric_dimension_enabled", is_notifications_per_metric_dimension_enabled)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if metric_compartment_id is not None:
            pulumi.set(__self__, "metric_compartment_id", metric_compartment_id)
        if metric_compartment_id_in_subtree is not None:
            pulumi.set(__self__, "metric_compartment_id_in_subtree", metric_compartment_id_in_subtree)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if notification_version is not None:
            pulumi.set(__self__, "notification_version", notification_version)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if pending_duration is not None:
            pulumi.set(__self__, "pending_duration", pending_duration)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if repeat_notification_duration is not None:
            pulumi.set(__self__, "repeat_notification_duration", repeat_notification_duration)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if suppression is not None:
            pulumi.set(__self__, "suppression", suppression)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name for the alarm. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        This value determines the title of each alarm notification.

        Example: `High CPU Utilization`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the alarm is enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isNotificationsPerMetricDimensionEnabled")
    def is_notifications_per_metric_dimension_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) When set to `true`, splits alarm notifications per metric stream. When set to `false`, groups alarm notifications across metric streams. Example: `true`
        """
        return pulumi.get(self, "is_notifications_per_metric_dimension_enabled")

    @is_notifications_per_metric_dimension_enabled.setter
    def is_notifications_per_metric_dimension_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_notifications_per_metric_dimension_enabled", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The format to use for alarm notifications. The formats are:
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="metricCompartmentId")
    def metric_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        """
        return pulumi.get(self, "metric_compartment_id")

    @metric_compartment_id.setter
    def metric_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_compartment_id", value)

    @property
    @pulumi.getter(name="metricCompartmentIdInSubtree")
    def metric_compartment_id_in_subtree(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        """
        return pulumi.get(self, "metric_compartment_id_in_subtree")

    @metric_compartment_id_in_subtree.setter
    def metric_compartment_id_in_subtree(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "metric_compartment_id_in_subtree", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="notificationVersion")
    def notification_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        """
        return pulumi.get(self, "notification_version")

    @notification_version.setter
    def notification_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_version", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]]]:
        """
        (Updatable) A set of overrides that control evaluations of the alarm. 

        Each override can specify values for query, severity, body, and pending duration. When an alarm contains overrides, the Monitoring service evaluates each override in order, beginning with the first override in the array (index position `0`), and then evaluates the alarm's base values (`ruleName` value of `BASE`).
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.

        Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".

        The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.

        Example: `PT5M`
        """
        return pulumi.get(self, "pending_duration")

    @pending_duration.setter
    def pending_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pending_duration", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----

        Example of absence alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()

        -----
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.

        Default value: null (notifications are not re-submitted).

        Example: `PT2H`
        """
        return pulumi.get(self, "repeat_notification_duration")

    @repeat_notification_duration.setter
    def repeat_notification_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_notification_duration", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time between calculated aggregation windows for the alarm. Supported value: `1m`
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolution", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Resource group that you want to match. A null value returns only metric data that has no resource groups. The alarm retrieves metric data associated with the specified resource group only. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($). Avoid entering confidential information.  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  A valid ruleName value starts with an alphabetic character and includes only alphanumeric characters, underscores and square brackets.  Minimum number of characters: 3. Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the alarm.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def suppression(self) -> Optional[pulumi.Input['AlarmSuppressionArgs']]:
        """
        (Updatable) The configuration details for suppressing an alarm.
        """
        return pulumi.get(self, "suppression")

    @suppression.setter
    def suppression(self, value: Optional[pulumi.Input['AlarmSuppressionArgs']]):
        pulumi.set(self, "suppression", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the alarm was created. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the alarm was last updated. Format defined by RFC3339.  Example: `2023-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class Alarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 is_notifications_per_metric_dimension_enabled: Optional[pulumi.Input[bool]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 metric_compartment_id: Optional[pulumi.Input[str]] = None,
                 metric_compartment_id_in_subtree: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 notification_version: Optional[pulumi.Input[str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmOverrideArgs']]]]] = None,
                 pending_duration: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 suppression: Optional[pulumi.Input[pulumi.InputType['AlarmSuppressionArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Alarm resource in Oracle Cloud Infrastructure Monitoring service.

        Creates a new alarm in the specified compartment.
        For more information, see
        [Creating an Alarm](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-alarm.htm).
        For important limits information, see
        [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

        This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
        Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
        or transactions, per second (TPS) for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alarm = oci.monitoring.Alarm("test_alarm",
            compartment_id=compartment_id,
            destinations=[test_notification_topic["id"]],
            display_name=alarm_display_name,
            is_enabled=alarm_is_enabled,
            metric_compartment_id=alarm_metric_compartment_id,
            namespace=alarm_namespace,
            query=alarm_query,
            severity=alarm_severity,
            body=alarm_body,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            is_notifications_per_metric_dimension_enabled=alarm_is_notifications_per_metric_dimension_enabled,
            message_format=alarm_message_format,
            metric_compartment_id_in_subtree=alarm_metric_compartment_id_in_subtree,
            notification_version=alarm_notification_version,
            overrides=[oci.monitoring.AlarmOverrideArgs(
                body=alarm_overrides_body,
                pending_duration=alarm_overrides_pending_duration,
                query=alarm_overrides_query,
                rule_name=test_rule["name"],
                severity=alarm_overrides_severity,
            )],
            pending_duration=alarm_pending_duration,
            repeat_notification_duration=alarm_repeat_notification_duration,
            resolution=alarm_resolution,
            resource_group=alarm_resource_group,
            rule_name=test_rule["name"],
            suppression=oci.monitoring.AlarmSuppressionArgs(
                time_suppress_from=alarm_suppression_time_suppress_from,
                time_suppress_until=alarm_suppression_time_suppress_until,
                description=alarm_suppression_description,
            ))
        ```

        ## Import

        Alarms can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Monitoring/alarm:Alarm test_alarm "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: (Updatable) The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the alarm. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               This value determines the title of each alarm notification.
               
               Example: `High CPU Utilization`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the alarm is enabled.  Example: `true`
        :param pulumi.Input[bool] is_notifications_per_metric_dimension_enabled: (Updatable) When set to `true`, splits alarm notifications per metric stream. When set to `false`, groups alarm notifications across metric streams. Example: `true`
        :param pulumi.Input[str] message_format: (Updatable) The format to use for alarm notifications. The formats are:
        :param pulumi.Input[str] metric_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        :param pulumi.Input[bool] metric_compartment_id_in_subtree: (Updatable) When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        :param pulumi.Input[str] namespace: (Updatable) The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        :param pulumi.Input[str] notification_version: (Updatable) The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmOverrideArgs']]]] overrides: (Updatable) A set of overrides that control evaluations of the alarm. 
               
               Each override can specify values for query, severity, body, and pending duration. When an alarm contains overrides, the Monitoring service evaluates each override in order, beginning with the first override in the array (index position `0`), and then evaluates the alarm's base values (`ruleName` value of `BASE`).
        :param pulumi.Input[str] pending_duration: (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
               
               The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.
               
               Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".
               
               The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.
               
               Example: `PT5M`
        :param pulumi.Input[str] query: (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
               
               Example of threshold alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85
               
               -----
               
               Example of absence alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()
               
               -----
        :param pulumi.Input[str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.
               
               Default value: null (notifications are not re-submitted).
               
               Example: `PT2H`
        :param pulumi.Input[str] resolution: (Updatable) The time between calculated aggregation windows for the alarm. Supported value: `1m`
        :param pulumi.Input[str] resource_group: (Updatable) Resource group that you want to match. A null value returns only metric data that has no resource groups. The alarm retrieves metric data associated with the specified resource group only. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($). Avoid entering confidential information.  Example: `frontend-fleet`
        :param pulumi.Input[str] rule_name: (Updatable) Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  A valid ruleName value starts with an alphabetic character and includes only alphanumeric characters, underscores and square brackets.  Minimum number of characters: 3. Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param pulumi.Input[str] severity: (Updatable) The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        :param pulumi.Input[pulumi.InputType['AlarmSuppressionArgs']] suppression: (Updatable) The configuration details for suppressing an alarm.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Alarm resource in Oracle Cloud Infrastructure Monitoring service.

        Creates a new alarm in the specified compartment.
        For more information, see
        [Creating an Alarm](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-alarm.htm).
        For important limits information, see
        [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

        This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
        Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
        or transactions, per second (TPS) for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alarm = oci.monitoring.Alarm("test_alarm",
            compartment_id=compartment_id,
            destinations=[test_notification_topic["id"]],
            display_name=alarm_display_name,
            is_enabled=alarm_is_enabled,
            metric_compartment_id=alarm_metric_compartment_id,
            namespace=alarm_namespace,
            query=alarm_query,
            severity=alarm_severity,
            body=alarm_body,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            is_notifications_per_metric_dimension_enabled=alarm_is_notifications_per_metric_dimension_enabled,
            message_format=alarm_message_format,
            metric_compartment_id_in_subtree=alarm_metric_compartment_id_in_subtree,
            notification_version=alarm_notification_version,
            overrides=[oci.monitoring.AlarmOverrideArgs(
                body=alarm_overrides_body,
                pending_duration=alarm_overrides_pending_duration,
                query=alarm_overrides_query,
                rule_name=test_rule["name"],
                severity=alarm_overrides_severity,
            )],
            pending_duration=alarm_pending_duration,
            repeat_notification_duration=alarm_repeat_notification_duration,
            resolution=alarm_resolution,
            resource_group=alarm_resource_group,
            rule_name=test_rule["name"],
            suppression=oci.monitoring.AlarmSuppressionArgs(
                time_suppress_from=alarm_suppression_time_suppress_from,
                time_suppress_until=alarm_suppression_time_suppress_until,
                description=alarm_suppression_description,
            ))
        ```

        ## Import

        Alarms can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Monitoring/alarm:Alarm test_alarm "id"
        ```

        :param str resource_name: The name of the resource.
        :param AlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 is_notifications_per_metric_dimension_enabled: Optional[pulumi.Input[bool]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 metric_compartment_id: Optional[pulumi.Input[str]] = None,
                 metric_compartment_id_in_subtree: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 notification_version: Optional[pulumi.Input[str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmOverrideArgs']]]]] = None,
                 pending_duration: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[str]] = None,
                 resolution: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 suppression: Optional[pulumi.Input[pulumi.InputType['AlarmSuppressionArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmArgs.__new__(AlarmArgs)

            __props__.__dict__["body"] = body
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_enabled'")
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["is_notifications_per_metric_dimension_enabled"] = is_notifications_per_metric_dimension_enabled
            __props__.__dict__["message_format"] = message_format
            if metric_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'metric_compartment_id'")
            __props__.__dict__["metric_compartment_id"] = metric_compartment_id
            __props__.__dict__["metric_compartment_id_in_subtree"] = metric_compartment_id_in_subtree
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["notification_version"] = notification_version
            __props__.__dict__["overrides"] = overrides
            __props__.__dict__["pending_duration"] = pending_duration
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["repeat_notification_duration"] = repeat_notification_duration
            __props__.__dict__["resolution"] = resolution
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["rule_name"] = rule_name
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["suppression"] = suppression
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Alarm, __self__).__init__(
            'oci:Monitoring/alarm:Alarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            is_notifications_per_metric_dimension_enabled: Optional[pulumi.Input[bool]] = None,
            message_format: Optional[pulumi.Input[str]] = None,
            metric_compartment_id: Optional[pulumi.Input[str]] = None,
            metric_compartment_id_in_subtree: Optional[pulumi.Input[bool]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            notification_version: Optional[pulumi.Input[str]] = None,
            overrides: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmOverrideArgs']]]]] = None,
            pending_duration: Optional[pulumi.Input[str]] = None,
            query: Optional[pulumi.Input[str]] = None,
            repeat_notification_duration: Optional[pulumi.Input[str]] = None,
            resolution: Optional[pulumi.Input[str]] = None,
            resource_group: Optional[pulumi.Input[str]] = None,
            rule_name: Optional[pulumi.Input[str]] = None,
            severity: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            suppression: Optional[pulumi.Input[pulumi.InputType['AlarmSuppressionArgs']]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'Alarm':
        """
        Get an existing Alarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: (Updatable) The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the alarm. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               This value determines the title of each alarm notification.
               
               Example: `High CPU Utilization`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the alarm is enabled.  Example: `true`
        :param pulumi.Input[bool] is_notifications_per_metric_dimension_enabled: (Updatable) When set to `true`, splits alarm notifications per metric stream. When set to `false`, groups alarm notifications across metric streams. Example: `true`
        :param pulumi.Input[str] message_format: (Updatable) The format to use for alarm notifications. The formats are:
        :param pulumi.Input[str] metric_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        :param pulumi.Input[bool] metric_compartment_id_in_subtree: (Updatable) When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        :param pulumi.Input[str] namespace: (Updatable) The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        :param pulumi.Input[str] notification_version: (Updatable) The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmOverrideArgs']]]] overrides: (Updatable) A set of overrides that control evaluations of the alarm. 
               
               Each override can specify values for query, severity, body, and pending duration. When an alarm contains overrides, the Monitoring service evaluates each override in order, beginning with the first override in the array (index position `0`), and then evaluates the alarm's base values (`ruleName` value of `BASE`).
        :param pulumi.Input[str] pending_duration: (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
               
               The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.
               
               Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".
               
               The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.
               
               Example: `PT5M`
        :param pulumi.Input[str] query: (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
               
               Example of threshold alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85
               
               -----
               
               Example of absence alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()
               
               -----
        :param pulumi.Input[str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.
               
               Default value: null (notifications are not re-submitted).
               
               Example: `PT2H`
        :param pulumi.Input[str] resolution: (Updatable) The time between calculated aggregation windows for the alarm. Supported value: `1m`
        :param pulumi.Input[str] resource_group: (Updatable) Resource group that you want to match. A null value returns only metric data that has no resource groups. The alarm retrieves metric data associated with the specified resource group only. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($). Avoid entering confidential information.  Example: `frontend-fleet`
        :param pulumi.Input[str] rule_name: (Updatable) Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  A valid ruleName value starts with an alphabetic character and includes only alphanumeric characters, underscores and square brackets.  Minimum number of characters: 3. Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param pulumi.Input[str] severity: (Updatable) The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        :param pulumi.Input[str] state: The current lifecycle state of the alarm.  Example: `DELETED`
        :param pulumi.Input[pulumi.InputType['AlarmSuppressionArgs']] suppression: (Updatable) The configuration details for suppressing an alarm.
        :param pulumi.Input[str] time_created: The date and time the alarm was created. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the alarm was last updated. Format defined by RFC3339.  Example: `2023-02-03T01:02:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmState.__new__(_AlarmState)

        __props__.__dict__["body"] = body
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["is_notifications_per_metric_dimension_enabled"] = is_notifications_per_metric_dimension_enabled
        __props__.__dict__["message_format"] = message_format
        __props__.__dict__["metric_compartment_id"] = metric_compartment_id
        __props__.__dict__["metric_compartment_id_in_subtree"] = metric_compartment_id_in_subtree
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["notification_version"] = notification_version
        __props__.__dict__["overrides"] = overrides
        __props__.__dict__["pending_duration"] = pending_duration
        __props__.__dict__["query"] = query
        __props__.__dict__["repeat_notification_duration"] = repeat_notification_duration
        __props__.__dict__["resolution"] = resolution
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["severity"] = severity
        __props__.__dict__["state"] = state
        __props__.__dict__["suppression"] = suppression
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Alarm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[str]:
        """
        (Updatable) The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name for the alarm. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        This value determines the title of each alarm notification.

        Example: `High CPU Utilization`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether the alarm is enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isNotificationsPerMetricDimensionEnabled")
    def is_notifications_per_metric_dimension_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) When set to `true`, splits alarm notifications per metric stream. When set to `false`, groups alarm notifications across metric streams. Example: `true`
        """
        return pulumi.get(self, "is_notifications_per_metric_dimension_enabled")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> pulumi.Output[str]:
        """
        (Updatable) The format to use for alarm notifications. The formats are:
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="metricCompartmentId")
    def metric_compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        """
        return pulumi.get(self, "metric_compartment_id")

    @property
    @pulumi.getter(name="metricCompartmentIdInSubtree")
    def metric_compartment_id_in_subtree(self) -> pulumi.Output[bool]:
        """
        (Updatable) When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        """
        return pulumi.get(self, "metric_compartment_id_in_subtree")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        (Updatable) The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="notificationVersion")
    def notification_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        """
        return pulumi.get(self, "notification_version")

    @property
    @pulumi.getter
    def overrides(self) -> pulumi.Output[Sequence['outputs.AlarmOverride']]:
        """
        (Updatable) A set of overrides that control evaluations of the alarm. 

        Each override can specify values for query, severity, body, and pending duration. When an alarm contains overrides, the Monitoring service evaluates each override in order, beginning with the first override in the array (index position `0`), and then evaluates the alarm's base values (`ruleName` value of `BASE`).
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> pulumi.Output[str]:
        """
        (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.

        Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".

        The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.

        Example: `PT5M`
        """
        return pulumi.get(self, "pending_duration")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[str]:
        """
        (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----

        Example of absence alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()

        -----
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> pulumi.Output[str]:
        """
        (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.

        Default value: null (notifications are not re-submitted).

        Example: `PT2H`
        """
        return pulumi.get(self, "repeat_notification_duration")

    @property
    @pulumi.getter
    def resolution(self) -> pulumi.Output[str]:
        """
        (Updatable) The time between calculated aggregation windows for the alarm. Supported value: `1m`
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[str]:
        """
        (Updatable) Resource group that you want to match. A null value returns only metric data that has no resource groups. The alarm retrieves metric data associated with the specified resource group only. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($). Avoid entering confidential information.  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  A valid ruleName value starts with an alphabetic character and includes only alphanumeric characters, underscores and square brackets.  Minimum number of characters: 3. Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[str]:
        """
        (Updatable) The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the alarm.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def suppression(self) -> pulumi.Output['outputs.AlarmSuppression']:
        """
        (Updatable) The configuration details for suppressing an alarm.
        """
        return pulumi.get(self, "suppression")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the alarm was created. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the alarm was last updated. Format defined by RFC3339.  Example: `2023-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

