﻿'''_1713.py

PadFluidFilmBearing
'''


from mastapy._internal.implicit import overridable, enum_with_selected_value
from mastapy._internal import constructor
from mastapy.bearings import _1485
from mastapy.bearings.bearing_designs import _1683
from mastapy._internal.python_net import python_net_import

_PAD_FLUID_FILM_BEARING = python_net_import('SMT.MastaAPI.Bearings.BearingDesigns.FluidFilm', 'PadFluidFilmBearing')


__docformat__ = 'restructuredtext en'
__all__ = ('PadFluidFilmBearing',)


class PadFluidFilmBearing(_1683.DetailedBearing):
    '''PadFluidFilmBearing

    This is a mastapy class.
    '''

    TYPE = _PAD_FLUID_FILM_BEARING
    __hash__ = None

    def __init__(self, instance_to_wrap: 'PadFluidFilmBearing.TYPE'):
        super().__init__(instance_to_wrap)

    @property
    def number_of_pads(self) -> 'overridable.Overridable_int':
        '''overridable.Overridable_int: 'NumberOfPads' is the original name of this property.'''

        return constructor.new(overridable.Overridable_int)(self.wrapped.NumberOfPads) if self.wrapped.NumberOfPads else None

    @number_of_pads.setter
    def number_of_pads(self, value: 'overridable.Overridable_int.implicit_type()'):
        wrapper_type = overridable.Overridable_int.TYPE
        enclosed_type = overridable.Overridable_int.implicit_type()
        value = wrapper_type[enclosed_type](enclosed_type(value) if value else 0)
        self.wrapped.NumberOfPads = value

    @property
    def rotational_direction(self) -> 'enum_with_selected_value.EnumWithSelectedValue_RotationalDirections':
        '''enum_with_selected_value.EnumWithSelectedValue_RotationalDirections: 'RotationalDirection' is the original name of this property.'''

        return constructor.new(enum_with_selected_value.EnumWithSelectedValue_RotationalDirections)(self.wrapped.RotationalDirection) if self.wrapped.RotationalDirection else None

    @rotational_direction.setter
    def rotational_direction(self, value: 'enum_with_selected_value.EnumWithSelectedValue_RotationalDirections.implicit_type()'):
        wrapper_type = enum_with_selected_value.EnumWithSelectedValue_RotationalDirections.TYPE
        enclosed_type = enum_with_selected_value.EnumWithSelectedValue_RotationalDirections.implicit_type()
        value = wrapper_type[enclosed_type](value if value else None)
        self.wrapped.RotationalDirection = value

    @property
    def pad_angular_extent(self) -> 'overridable.Overridable_float':
        '''overridable.Overridable_float: 'PadAngularExtent' is the original name of this property.'''

        return constructor.new(overridable.Overridable_float)(self.wrapped.PadAngularExtent) if self.wrapped.PadAngularExtent else None

    @pad_angular_extent.setter
    def pad_angular_extent(self, value: 'overridable.Overridable_float.implicit_type()'):
        wrapper_type = overridable.Overridable_float.TYPE
        enclosed_type = overridable.Overridable_float.implicit_type()
        value = wrapper_type[enclosed_type](enclosed_type(value) if value else 0.0)
        self.wrapped.PadAngularExtent = value

    @property
    def pivot_angular_offset(self) -> 'float':
        '''float: 'PivotAngularOffset' is the original name of this property.'''

        return self.wrapped.PivotAngularOffset

    @pivot_angular_offset.setter
    def pivot_angular_offset(self, value: 'float'):
        self.wrapped.PivotAngularOffset = float(value) if value else 0.0

    @property
    def collar_surface_roughness(self) -> 'float':
        '''float: 'CollarSurfaceRoughness' is the original name of this property.'''

        return self.wrapped.CollarSurfaceRoughness

    @collar_surface_roughness.setter
    def collar_surface_roughness(self, value: 'float'):
        self.wrapped.CollarSurfaceRoughness = float(value) if value else 0.0

    @property
    def limiting_film_thickness(self) -> 'float':
        '''float: 'LimitingFilmThickness' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return self.wrapped.LimitingFilmThickness
