﻿'''_548.py

AGMAGleasonConicalGearMeshRating
'''


from mastapy._internal.implicit import overridable
from mastapy._internal import constructor, conversion
from mastapy.gears.gear_designs.conical import _588
from mastapy.gears.rating.conical import _479
from mastapy._internal.python_net import python_net_import

_AGMA_GLEASON_CONICAL_GEAR_MESH_RATING = python_net_import('SMT.MastaAPI.Gears.Rating.AGMAGleasonConical', 'AGMAGleasonConicalGearMeshRating')


__docformat__ = 'restructuredtext en'
__all__ = ('AGMAGleasonConicalGearMeshRating',)


class AGMAGleasonConicalGearMeshRating(_479.ConicalGearMeshRating):
    '''AGMAGleasonConicalGearMeshRating

    This is a mastapy class.
    '''

    TYPE = _AGMA_GLEASON_CONICAL_GEAR_MESH_RATING
    __hash__ = None

    def __init__(self, instance_to_wrap: 'AGMAGleasonConicalGearMeshRating.TYPE'):
        super().__init__(instance_to_wrap)

    @property
    def overload_factor_bending(self) -> 'overridable.Overridable_float':
        '''overridable.Overridable_float: 'OverloadFactorBending' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return constructor.new(overridable.Overridable_float)(self.wrapped.OverloadFactorBending) if self.wrapped.OverloadFactorBending else None

    @property
    def overload_factor_contact(self) -> 'overridable.Overridable_float':
        '''overridable.Overridable_float: 'OverloadFactorContact' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return constructor.new(overridable.Overridable_float)(self.wrapped.OverloadFactorContact) if self.wrapped.OverloadFactorContact else None

    @property
    def maximum_relative_displacement(self) -> 'float':
        '''float: 'MaximumRelativeDisplacement' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return self.wrapped.MaximumRelativeDisplacement

    @property
    def load_distribution_factor_method(self) -> '_588.LoadDistributionFactorMethods':
        '''LoadDistributionFactorMethods: 'LoadDistributionFactorMethod' is the original name of this property.

        Note:
            This property is readonly.
        '''

        value = conversion.pn_to_mp_enum(self.wrapped.LoadDistributionFactorMethod)
        return constructor.new(_588.LoadDistributionFactorMethods)(value) if value else None
