﻿'''_5894.py

WhineWaterfallReferenceValues
'''


from typing import Generic, TypeVar

from mastapy._internal import constructor
from mastapy._internal.implicit import overridable
from mastapy.system_model.analyses_and_results.modal_analyses import _5895
from mastapy.utility.units_and_measurements import _1035
from mastapy._internal.python_net import python_net_import

_WHINE_WATERFALL_REFERENCE_VALUES = python_net_import('SMT.MastaAPI.SystemModel.AnalysesAndResults.ModalAnalyses', 'WhineWaterfallReferenceValues')


__docformat__ = 'restructuredtext en'
__all__ = ('WhineWaterfallReferenceValues',)


TMeasurement = TypeVar('TMeasurement', bound='_1035.MeasurementBase')


class WhineWaterfallReferenceValues(_5895.WhineWaterfallReferenceValuesBase, Generic[TMeasurement]):
    '''WhineWaterfallReferenceValues

    This is a mastapy class.

    Generic Types:
        TMeasurement
    '''

    TYPE = _WHINE_WATERFALL_REFERENCE_VALUES
    __hash__ = None

    def __init__(self, instance_to_wrap: 'WhineWaterfallReferenceValues.TYPE'):
        super().__init__(instance_to_wrap)

    @property
    def decibel_reference(self) -> 'float':
        '''float: 'DecibelReference' is the original name of this property.'''

        return self.wrapped.DecibelReference

    @decibel_reference.setter
    def decibel_reference(self, value: 'float'):
        self.wrapped.DecibelReference = float(value) if value else 0.0

    @property
    def minimum(self) -> 'overridable.Overridable_float':
        '''overridable.Overridable_float: 'Minimum' is the original name of this property.'''

        return constructor.new(overridable.Overridable_float)(self.wrapped.Minimum) if self.wrapped.Minimum else None

    @minimum.setter
    def minimum(self, value: 'overridable.Overridable_float.implicit_type()'):
        wrapper_type = overridable.Overridable_float.TYPE
        enclosed_type = overridable.Overridable_float.implicit_type()
        value = wrapper_type[enclosed_type](enclosed_type(value) if value else 0.0)
        self.wrapped.Minimum = value

    @property
    def maximum(self) -> 'overridable.Overridable_float':
        '''overridable.Overridable_float: 'Maximum' is the original name of this property.'''

        return constructor.new(overridable.Overridable_float)(self.wrapped.Maximum) if self.wrapped.Maximum else None

    @maximum.setter
    def maximum(self, value: 'overridable.Overridable_float.implicit_type()'):
        wrapper_type = overridable.Overridable_float.TYPE
        enclosed_type = overridable.Overridable_float.implicit_type()
        value = wrapper_type[enclosed_type](enclosed_type(value) if value else 0.0)
        self.wrapped.Maximum = value
