﻿'''_6169.py

RollingRingAssemblyLoadCase
'''


from mastapy.system_model.part_model.couplings import _2131
from mastapy._internal import constructor
from mastapy.system_model.analyses_and_results.static_loads import _6176
from mastapy._internal.python_net import python_net_import

_ROLLING_RING_ASSEMBLY_LOAD_CASE = python_net_import('SMT.MastaAPI.SystemModel.AnalysesAndResults.StaticLoads', 'RollingRingAssemblyLoadCase')


__docformat__ = 'restructuredtext en'
__all__ = ('RollingRingAssemblyLoadCase',)


class RollingRingAssemblyLoadCase(_6176.SpecialisedAssemblyLoadCase):
    '''RollingRingAssemblyLoadCase

    This is a mastapy class.
    '''

    TYPE = _ROLLING_RING_ASSEMBLY_LOAD_CASE

    __hash__ = None

    def __init__(self, instance_to_wrap: 'RollingRingAssemblyLoadCase.TYPE'):
        super().__init__(instance_to_wrap)

    @property
    def assembly_design(self) -> '_2131.RollingRingAssembly':
        '''RollingRingAssembly: 'AssemblyDesign' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return constructor.new(_2131.RollingRingAssembly)(self.wrapped.AssemblyDesign) if self.wrapped.AssemblyDesign else None
