﻿'''_2479.py

RollingRingCompoundSystemDeflection
'''


from typing import List

from mastapy.system_model.part_model.couplings import _2042
from mastapy._internal import constructor, conversion
from mastapy.system_model.analyses_and_results.system_deflections import _2229
from mastapy.system_model.analyses_and_results.system_deflections.compound import _2435
from mastapy._internal.python_net import python_net_import

_ROLLING_RING_COMPOUND_SYSTEM_DEFLECTION = python_net_import('SMT.MastaAPI.SystemModel.AnalysesAndResults.SystemDeflections.Compound', 'RollingRingCompoundSystemDeflection')


__docformat__ = 'restructuredtext en'
__all__ = ('RollingRingCompoundSystemDeflection',)


class RollingRingCompoundSystemDeflection(_2435.CouplingHalfCompoundSystemDeflection):
    '''RollingRingCompoundSystemDeflection

    This is a mastapy class.
    '''

    TYPE = _ROLLING_RING_COMPOUND_SYSTEM_DEFLECTION
    __hash__ = None

    def __init__(self, instance_to_wrap: 'RollingRingCompoundSystemDeflection.TYPE'):
        super().__init__(instance_to_wrap)

    @property
    def component_design(self) -> '_2042.RollingRing':
        '''RollingRing: 'ComponentDesign' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return constructor.new(_2042.RollingRing)(self.wrapped.ComponentDesign) if self.wrapped.ComponentDesign else None

    @property
    def load_case_analyses_ready(self) -> 'List[_2229.RollingRingSystemDeflection]':
        '''List[RollingRingSystemDeflection]: 'LoadCaseAnalysesReady' is the original name of this property.

        Note:
            This property is readonly.
        '''

        value = conversion.pn_to_mp_objects_in_list(self.wrapped.LoadCaseAnalysesReady, constructor.new(_2229.RollingRingSystemDeflection))
        return value

    @property
    def component_system_deflection_load_cases(self) -> 'List[_2229.RollingRingSystemDeflection]':
        '''List[RollingRingSystemDeflection]: 'ComponentSystemDeflectionLoadCases' is the original name of this property.

        Note:
            This property is readonly.
        '''

        value = conversion.pn_to_mp_objects_in_list(self.wrapped.ComponentSystemDeflectionLoadCases, constructor.new(_2229.RollingRingSystemDeflection))
        return value

    @property
    def planetaries(self) -> 'List[RollingRingCompoundSystemDeflection]':
        '''List[RollingRingCompoundSystemDeflection]: 'Planetaries' is the original name of this property.

        Note:
            This property is readonly.
        '''

        value = conversion.pn_to_mp_objects_in_list(self.wrapped.Planetaries, constructor.new(RollingRingCompoundSystemDeflection))
        return value
