﻿'''_1920.py

CreateConnectedComponentOptions
'''


from typing import Callable, List

from mastapy._internal.implicit import enum_with_selected_value
from mastapy.system_model import _1796
from mastapy._internal import enum_with_selected_value_runtime, conversion, constructor
from mastapy import _0
from mastapy._internal.python_net import python_net_import

_CREATE_CONNECTED_COMPONENT_OPTIONS = python_net_import('SMT.MastaAPI.SystemModel.ImportedFEs', 'CreateConnectedComponentOptions')


__docformat__ = 'restructuredtext en'
__all__ = ('CreateConnectedComponentOptions',)


class CreateConnectedComponentOptions(_0.APIBase):
    '''CreateConnectedComponentOptions

    This is a mastapy class.
    '''

    TYPE = _CREATE_CONNECTED_COMPONENT_OPTIONS

    __hash__ = None

    def __init__(self, instance_to_wrap: 'CreateConnectedComponentOptions.TYPE'):
        super().__init__(instance_to_wrap)

    @property
    def component_type(self) -> 'enum_with_selected_value.EnumWithSelectedValue_DesignEntityId':
        '''enum_with_selected_value.EnumWithSelectedValue_DesignEntityId: 'ComponentType' is the original name of this property.'''

        value = enum_with_selected_value.EnumWithSelectedValue_DesignEntityId.wrapped_type()
        return enum_with_selected_value_runtime.create(self.wrapped.ComponentType, value) if self.wrapped.ComponentType else None

    @component_type.setter
    def component_type(self, value: 'enum_with_selected_value.EnumWithSelectedValue_DesignEntityId.implicit_type()'):
        wrapper_type = enum_with_selected_value_runtime.ENUM_WITH_SELECTED_VALUE
        enclosed_type = enum_with_selected_value.EnumWithSelectedValue_DesignEntityId.implicit_type()
        value = conversion.mp_to_pn_enum(value)
        value = wrapper_type[enclosed_type](value)
        self.wrapped.ComponentType = value

    @property
    def create_component(self) -> 'Callable[[], None]':
        '''Callable[[], None]: 'CreateComponent' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return self.wrapped.CreateComponent

    @property
    def report_names(self) -> 'List[str]':
        '''List[str]: 'ReportNames' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return self.wrapped.ReportNames

    def output_default_report_to(self, file_path: 'str'):
        ''' 'OutputDefaultReportTo' is the original name of this method.

        Args:
            file_path (str)
        '''

        file_path = str(file_path)
        self.wrapped.OutputDefaultReportTo(file_path if file_path else None)

    def get_default_report_with_encoded_images(self) -> 'str':
        ''' 'GetDefaultReportWithEncodedImages' is the original name of this method.

        Returns:
            str
        '''

        method_result = self.wrapped.GetDefaultReportWithEncodedImages()
        return method_result

    def output_active_report_to(self, file_path: 'str'):
        ''' 'OutputActiveReportTo' is the original name of this method.

        Args:
            file_path (str)
        '''

        file_path = str(file_path)
        self.wrapped.OutputActiveReportTo(file_path if file_path else None)

    def output_active_report_as_text_to(self, file_path: 'str'):
        ''' 'OutputActiveReportAsTextTo' is the original name of this method.

        Args:
            file_path (str)
        '''

        file_path = str(file_path)
        self.wrapped.OutputActiveReportAsTextTo(file_path if file_path else None)

    def get_active_report_with_encoded_images(self) -> 'str':
        ''' 'GetActiveReportWithEncodedImages' is the original name of this method.

        Returns:
            str
        '''

        method_result = self.wrapped.GetActiveReportWithEncodedImages()
        return method_result

    def output_named_report_to(self, report_name: 'str', file_path: 'str'):
        ''' 'OutputNamedReportTo' is the original name of this method.

        Args:
            report_name (str)
            file_path (str)
        '''

        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportTo(report_name if report_name else None, file_path if file_path else None)

    def output_named_report_as_masta_report(self, report_name: 'str', file_path: 'str'):
        ''' 'OutputNamedReportAsMastaReport' is the original name of this method.

        Args:
            report_name (str)
            file_path (str)
        '''

        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsMastaReport(report_name if report_name else None, file_path if file_path else None)

    def output_named_report_as_text_to(self, report_name: 'str', file_path: 'str'):
        ''' 'OutputNamedReportAsTextTo' is the original name of this method.

        Args:
            report_name (str)
            file_path (str)
        '''

        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsTextTo(report_name if report_name else None, file_path if file_path else None)

    def get_named_report_with_encoded_images(self, report_name: 'str') -> 'str':
        ''' 'GetNamedReportWithEncodedImages' is the original name of this method.

        Args:
            report_name (str)

        Returns:
            str
        '''

        report_name = str(report_name)
        method_result = self.wrapped.GetNamedReportWithEncodedImages(report_name if report_name else None)
        return method_result
