# -*- coding: utf-8 -*-
"""
Go language-specific code review checklist.
"""

CHECKLIST = """
## Go 代码审查检查清单

### 错误处理
- [ ] 是否正确检查和处理错误
- [ ] 是否遵循 Go 的错误处理惯例 (errors.Is, errors.As)
- [ ] 错误是否有足够的上下文信息

### 并发
- [ ] goroutine 是否会正常终止
- [ ] 是否存在竞态条件
- [ ] channel 使用是否正确
- [ ] 是否正确使用 sync 包
- [ ] 是否使用了上下文 (context) 进行超时控制

### 资源管理
- [ ] defer 是否正确使用
- [ ] 资源是否被正确关闭
- [ ] 是否有潜在的资源泄漏

### 性能
- [ ] 是否避免不必要的内存分配
- [ ] 切片和映射的容量是否合理
- [ ] 是否使用了高效的 IO 操作
- [ ] 大型结构体是否使用指针传递

### 代码风格与最佳实践
- [ ] 是否遵循官方 Go 代码风格
- [ ] 命名是否遵循 Go 的约定
- [ ] 是否避免了不必要的代码重复
- [ ] 是否正确使用接口
- [ ] 是否过度使用全局变量
- [ ] 包的设计是否合理

### 测试
- [ ] 是否有足够的单元测试
- [ ] 测试覆盖率是否合理
- [ ] 表格驱动测试是否得当

### 安全
- [ ] SQL 注入风险
- [ ] 命令注入风险
- [ ] 敏感信息是否安全存储

### 文档
- [ ] 导出的函数/类型是否有文档注释
- [ ] 复杂逻辑是否有注释说明
""" 