# -*- coding: utf-8 -*-
"""
PHP language-specific code review checklist.
"""

CHECKLIST = """
## PHP 代码审查检查清单

### 代码风格和规范
- [ ] 是否遵循 PSR 标准 (PSR-1, PSR-12)
- [ ] 命名约定是否一致 (类、方法、变量)
- [ ] 是否使用 PHP_CodeSniffer 等工具检查代码风格
- [ ] 缩进和格式是否一致
- [ ] 是否使用了最新的 PHP 语法特性

### 安全性
- [ ] 是否防范 SQL 注入 (使用 PDO 或预处理语句)
- [ ] 是否防范 XSS 攻击 (输出转义)
- [ ] 是否防范 CSRF 攻击
- [ ] 文件上传是否安全处理
- [ ] 是否使用安全的密码散列 (password_hash)
- [ ] 是否避免使用有安全隐患的函数 (eval, create_function)
- [ ] 敏感数据是否加密存储
- [ ] 会话和 Cookie 是否安全配置
- [ ] 是否正确进行 HTTPS 配置

### 性能优化
- [ ] 数据库查询是否优化
- [ ] 是否使用缓存机制
- [ ] 循环和数据处理是否高效
- [ ] 是否避免了内存密集型操作
- [ ] 是否考虑了代码的可扩展性
- [ ] 是否使用适当的数据结构
- [ ] 是否优化了 I/O 操作

### 错误处理
- [ ] 是否使用异常处理机制
- [ ] 是否适当捕获和记录错误
- [ ] 是否提供友好的错误信息
- [ ] 是否有合适的异常层次结构
- [ ] 生产环境是否适当配置错误显示

### 面向对象设计
- [ ] 是否遵循 SOLID 原则
- [ ] 类的职责是否单一明确
- [ ] 继承层次是否合理
- [ ] 是否使用接口定义契约
- [ ] 类之间的耦合是否最小化
- [ ] 是否使用设计模式解决复杂问题

### 依赖管理
- [ ] 是否使用 Composer 管理依赖
- [ ] 依赖版本是否指定
- [ ] 是否定期更新依赖以修复安全漏洞
- [ ] 是否最小化了第三方依赖
- [ ] composer.json 和 composer.lock 是否同步

### 测试
- [ ] 是否有单元测试 (PHPUnit)
- [ ] 测试是否覆盖核心功能和边界条件
- [ ] 是否使用模拟对象测试依赖
- [ ] 测试是否可重复执行且彼此独立
- [ ] 是否有集成测试

### 文档
- [ ] 公共 API 是否有 PHPDoc 注释
- [ ] 复杂逻辑是否有注释说明
- [ ] 是否记录了项目设置和依赖要求
- [ ] 是否有使用示例
- [ ] 注释是否与代码同步

### 框架特定检查 (如使用框架)
- [ ] 是否遵循框架的最佳实践
- [ ] 是否正确使用 ORM 和数据库迁移
- [ ] 是否适当使用中间件
- [ ] 路由定义是否合理
- [ ] MVC 结构是否清晰
""" 