# -*- coding: utf-8 -*-
"""
SQL language-specific code review checklist.
"""

CHECKLIST = """
## SQL 代码审查检查清单

### 查询设计和可读性
- [ ] SQL 语句是否格式化和缩进一致
- [ ] 是否使用有意义的表和列名
- [ ] 是否有注释说明复杂查询
- [ ] 是否使用了一致的命名约定
- [ ] 是否避免了过度复杂的查询
- [ ] 是否适当使用子查询和公共表表达式 (CTE)

### 性能优化
- [ ] 是否有合适的索引支持查询
- [ ] 大表查询是否使用了分页
- [ ] 是否避免了全表扫描
- [ ] WHERE 条件是否能有效利用索引
- [ ] JOIN 操作是否高效
- [ ] 是否避免了使用 SELECT *
- [ ] 是否避免了不必要的排序和聚合
- [ ] 是否使用了适当的索引提示
- [ ] 大批量操作是否分批处理
- [ ] 触发器和存储过程是否高效

### 数据完整性和约束
- [ ] 是否定义了适当的主键
- [ ] 是否使用了外键约束
- [ ] 是否添加了适当的 NOT NULL 约束
- [ ] 是否设置了合理的默认值
- [ ] 是否使用了检查约束验证数据
- [ ] 事务是否保持一致性

### 安全性
- [ ] 是否防范 SQL 注入
- [ ] 是否使用参数化查询
- [ ] 权限是否遵循最小权限原则
- [ ] 敏感数据是否加密存储
- [ ] 是否限制了查询结果集大小
- [ ] 是否避免了在查询中使用 SQL 动态构建

### 并发和锁定
- [ ] 是否考虑了并发访问
- [ ] 事务范围是否最小化
- [ ] 是否使用了适当的隔离级别
- [ ] 是否避免了长时间锁定资源
- [ ] 是否考虑了死锁问题
- [ ] 是否处理了锁超时错误

### 可维护性和兼容性
- [ ] 脚本是否是幂等的 (可重复运行)
- [ ] 是否有数据库版本控制和迁移策略
- [ ] 是否考虑了数据库引擎兼容性
- [ ] 是否有针对各种错误情况的处理
- [ ] 是否有回滚策略
- [ ] 模式更改是否安全可靠

### 特定数据库最佳实践
- [ ] 是否遵循特定数据库引擎的最佳实践
- [ ] 是否合理使用数据库特有功能
- [ ] 是否考虑了不同数据库方言的差异
- [ ] 是否使用了合适的数据类型

### 测试
- [ ] 是否有针对 SQL 的单元测试
- [ ] 是否测试了边缘情况
- [ ] 是否验证了结果集的正确性
- [ ] 是否测试了性能和负载
- [ ] 是否有数据恢复测试
""" 