

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_rgblibuniffi_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_rgblibuniffi_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_rgblibuniffi_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("rgblibuniffi")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 26
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_rgblibuniffi_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_rgblibuniffi_checksum_func_generate_keys() != 50781:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_func_restore_backup() != 4743:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_func_restore_keys() != 38408:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_invoice_invoice_data() != 31294:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_invoice_invoice_string() != 25144:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_recipientinfo_network() != 22005:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_recipientinfo_recipient_type() != 3457:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_transportendpoint_transport_type() != 33510:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_backup() != 41851:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_backup_info() != 7253:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_blind_receive() != 26641:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos() != 42058:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos_begin() != 30727:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos_end() != 50137:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_delete_transfers() != 43847:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to() != 60164:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to_begin() != 57452:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to_end() != 62328:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_fail_transfers() != 7914:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_address() != 23668:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_asset_balance() != 19662:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_asset_metadata() != 58573:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_btc_balance() != 40762:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_fee_estimation() != 64220:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_media_dir() != 64429:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_wallet_data() != 18071:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_get_wallet_dir() != 8726:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_go_online() != 46399:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_cfa() != 7716:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_nia() != 62154:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_uda() != 16444:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_list_assets() != 18027:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_list_transactions() != 40825:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_list_transfers() != 36530:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_list_unspents() != 62734:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_refresh() != 45223:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_send() != 57749:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_send_begin() != 46093:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc() != 15823:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc_begin() != 59961:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc_end() != 60404:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_send_end() != 1754:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_sign_psbt() != 10485:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_sync() != 22767:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_method_wallet_witness_receive() != 62755:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_constructor_address_new() != 59809:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_constructor_invoice_from_invoice_data() != 55197:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_constructor_invoice_new() != 37528:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_constructor_recipientinfo_new() != 13462:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_constructor_transportendpoint_new() != 59385:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rgblibuniffi_checksum_constructor_wallet_new() != 49006:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UniffiLib.uniffi_rgblibuniffi_fn_clone_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_clone_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_free_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_free_address.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_address_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_address_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_clone_invoice.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_clone_invoice.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_free_invoice.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_free_invoice.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_invoice_from_invoice_data.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_invoice_from_invoice_data.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_invoice_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_invoice_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_method_invoice_invoice_data.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_invoice_invoice_data.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_invoice_invoice_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_invoice_invoice_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_clone_recipientinfo.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_clone_recipientinfo.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_free_recipientinfo.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_free_recipientinfo.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_recipientinfo_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_recipientinfo_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_method_recipientinfo_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_recipientinfo_network.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_recipientinfo_recipient_type.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_recipientinfo_recipient_type.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_clone_transportendpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_clone_transportendpoint.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_free_transportendpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_free_transportendpoint.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_transportendpoint_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_transportendpoint_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_method_transportendpoint_transport_type.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_transportendpoint_transport_type.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_clone_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_clone_wallet.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_free_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_free_wallet.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_wallet_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_constructor_wallet_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_backup.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_backup.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_backup_info.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_backup_info.restype = ctypes.c_int8
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_blind_receive.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_blind_receive.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int8,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos.restype = ctypes.c_uint8
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos_begin.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int8,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos_begin.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos_end.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos_end.restype = ctypes.c_uint8
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_delete_transfers.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_delete_transfers.restype = ctypes.c_int8
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to_begin.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to_begin.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to_end.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to_end.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_fail_transfers.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_fail_transfers.restype = ctypes.c_int8
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_asset_balance.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_asset_balance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_asset_metadata.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_asset_metadata.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_btc_balance.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_btc_balance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_fee_estimation.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint16,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_fee_estimation.restype = ctypes.c_double
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_media_dir.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_media_dir.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_wallet_data.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_wallet_data.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_wallet_dir.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_wallet_dir.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_go_online.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int8,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_go_online.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_cfa.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_cfa.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_nia.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_nia.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_uda.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_uda.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_assets.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_assets.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_transactions.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_transactions.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_transfers.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_transfers.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_unspents.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_unspents.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_refresh.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_refresh.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_uint64,
    ctypes.c_uint8,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_begin.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_uint64,
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_begin.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.c_uint64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc_begin.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.c_uint64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc_begin.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc_end.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc_end.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_end.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_end.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_sign_psbt.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_sign_psbt.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_sync.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_sync.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_witness_receive.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_witness_receive.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_func_generate_keys.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_func_generate_keys.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rgblibuniffi_fn_func_restore_backup.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_func_restore_backup.restype = None
_UniffiLib.uniffi_rgblibuniffi_fn_func_restore_keys.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rgblibuniffi_fn_func_restore_keys.restype = _UniffiRustBuffer
_UniffiLib.ffi_rgblibuniffi_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_rgblibuniffi_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_rgblibuniffi_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rustbuffer_free.restype = None
_UniffiLib.ffi_rgblibuniffi_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u8.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u8.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i8.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i8.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u16.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u16.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i16.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i16.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_u64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_u64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_i64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_i64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_f32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_f32.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_f64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_f64.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_pointer.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_poll_void.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_cancel_void.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rgblibuniffi_rust_future_free_void.restype = None
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rgblibuniffi_rust_future_complete_void.restype = None
_UniffiLib.uniffi_rgblibuniffi_checksum_func_generate_keys.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_func_generate_keys.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_func_restore_backup.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_func_restore_backup.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_func_restore_keys.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_func_restore_keys.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_invoice_invoice_data.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_invoice_invoice_data.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_invoice_invoice_string.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_invoice_invoice_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_recipientinfo_network.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_recipientinfo_network.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_recipientinfo_recipient_type.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_recipientinfo_recipient_type.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_transportendpoint_transport_type.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_transportendpoint_transport_type.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_backup.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_backup.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_backup_info.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_backup_info.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_blind_receive.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_blind_receive.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos_begin.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos_begin.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos_end.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_create_utxos_end.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_delete_transfers.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_delete_transfers.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to_begin.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to_begin.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to_end.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_drain_to_end.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_fail_transfers.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_fail_transfers.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_address.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_asset_balance.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_asset_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_asset_metadata.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_asset_metadata.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_btc_balance.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_btc_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_fee_estimation.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_fee_estimation.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_media_dir.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_media_dir.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_wallet_data.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_wallet_data.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_wallet_dir.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_get_wallet_dir.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_go_online.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_go_online.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_cfa.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_cfa.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_nia.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_nia.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_uda.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_issue_asset_uda.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_assets.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_assets.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_transactions.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_transactions.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_transfers.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_transfers.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_unspents.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_list_unspents.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_refresh.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_refresh.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_begin.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_begin.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc_begin.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc_begin.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc_end.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_btc_end.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_end.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_send_end.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_sign_psbt.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_sign_psbt.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_sync.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_sync.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_witness_receive.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_method_wallet_witness_receive.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_address_new.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_address_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_invoice_from_invoice_data.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_invoice_from_invoice_data.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_invoice_new.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_invoice_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_recipientinfo_new.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_recipientinfo_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_transportendpoint_new.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_transportendpoint_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_wallet_new.argtypes = (
)
_UniffiLib.uniffi_rgblibuniffi_checksum_constructor_wallet_new.restype = ctypes.c_uint16
_UniffiLib.ffi_rgblibuniffi_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_rgblibuniffi_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt8(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u8"
    VALUE_MIN = 0
    VALUE_MAX = 2**8

    @staticmethod
    def read(buf):
        return buf.read_u8()

    @staticmethod
    def write(value, buf):
        buf.write_u8(value)

class _UniffiConverterUInt16(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u16"
    VALUE_MIN = 0
    VALUE_MAX = 2**16

    @staticmethod
    def read(buf):
        return buf.read_u16()

    @staticmethod
    def write(value, buf):
        buf.write_u16(value)

class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i32"
    VALUE_MIN = -2**31
    VALUE_MAX = 2**31

    @staticmethod
    def read(buf):
        return buf.read_i32()

    @staticmethod
    def write(value, buf):
        buf.write_i32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.read_i64()

    @staticmethod
    def write(value, buf):
        buf.write_i64(value)

class _UniffiConverterDouble(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_double()

    @staticmethod
    def write(value, buf):
        buf.write_double(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class AddressProtocol(typing.Protocol):
    pass


class Address:
    _pointer: ctypes.c_void_p
    def __init__(self, address_string: "str",bitcoin_network: "BitcoinNetwork"):
        _UniffiConverterString.check_lower(address_string)
        
        _UniffiConverterTypeBitcoinNetwork.check_lower(bitcoin_network)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_constructor_address_new,
        _UniffiConverterString.lower(address_string),
        _UniffiConverterTypeBitcoinNetwork.lower(bitcoin_network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_free_address, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_clone_address, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeAddress:

    @staticmethod
    def lift(value: int):
        return Address._make_instance_(value)

    @staticmethod
    def check_lower(value: Address):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AddressProtocol):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AddressProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class InvoiceProtocol(typing.Protocol):
    def invoice_data(self, ):
        raise NotImplementedError
    def invoice_string(self, ):
        raise NotImplementedError


class Invoice:
    _pointer: ctypes.c_void_p
    def __init__(self, invoice_string: "str"):
        _UniffiConverterString.check_lower(invoice_string)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_constructor_invoice_new,
        _UniffiConverterString.lower(invoice_string))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_free_invoice, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_clone_invoice, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_invoice_data(cls, invoice_data: "InvoiceData"):
        _UniffiConverterTypeInvoiceData.check_lower(invoice_data)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_constructor_invoice_from_invoice_data,
        _UniffiConverterTypeInvoiceData.lower(invoice_data))
        return cls._make_instance_(pointer)



    def invoice_data(self, ) -> "InvoiceData":
        return _UniffiConverterTypeInvoiceData.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_invoice_invoice_data,self._uniffi_clone_pointer(),)
        )





    def invoice_string(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_invoice_invoice_string,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeInvoice:

    @staticmethod
    def lift(value: int):
        return Invoice._make_instance_(value)

    @staticmethod
    def check_lower(value: Invoice):
        if not isinstance(value, Invoice):
            raise TypeError("Expected Invoice instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: InvoiceProtocol):
        if not isinstance(value, Invoice):
            raise TypeError("Expected Invoice instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: InvoiceProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class RecipientInfoProtocol(typing.Protocol):
    def network(self, ):
        raise NotImplementedError
    def recipient_type(self, ):
        raise NotImplementedError


class RecipientInfo:
    _pointer: ctypes.c_void_p
    def __init__(self, recipient_id: "str"):
        _UniffiConverterString.check_lower(recipient_id)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_constructor_recipientinfo_new,
        _UniffiConverterString.lower(recipient_id))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_free_recipientinfo, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_clone_recipientinfo, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def network(self, ) -> "BitcoinNetwork":
        return _UniffiConverterTypeBitcoinNetwork.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_recipientinfo_network,self._uniffi_clone_pointer(),)
        )





    def recipient_type(self, ) -> "RecipientType":
        return _UniffiConverterTypeRecipientType.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_recipientinfo_recipient_type,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeRecipientInfo:

    @staticmethod
    def lift(value: int):
        return RecipientInfo._make_instance_(value)

    @staticmethod
    def check_lower(value: RecipientInfo):
        if not isinstance(value, RecipientInfo):
            raise TypeError("Expected RecipientInfo instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: RecipientInfoProtocol):
        if not isinstance(value, RecipientInfo):
            raise TypeError("Expected RecipientInfo instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: RecipientInfoProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TransportEndpointProtocol(typing.Protocol):
    def transport_type(self, ):
        raise NotImplementedError


class TransportEndpoint:
    _pointer: ctypes.c_void_p
    def __init__(self, transport_endpoint: "str"):
        _UniffiConverterString.check_lower(transport_endpoint)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_constructor_transportendpoint_new,
        _UniffiConverterString.lower(transport_endpoint))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_free_transportendpoint, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_clone_transportendpoint, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def transport_type(self, ) -> "TransportType":
        return _UniffiConverterTypeTransportType.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_transportendpoint_transport_type,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTransportEndpoint:

    @staticmethod
    def lift(value: int):
        return TransportEndpoint._make_instance_(value)

    @staticmethod
    def check_lower(value: TransportEndpoint):
        if not isinstance(value, TransportEndpoint):
            raise TypeError("Expected TransportEndpoint instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TransportEndpointProtocol):
        if not isinstance(value, TransportEndpoint):
            raise TypeError("Expected TransportEndpoint instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TransportEndpointProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WalletProtocol(typing.Protocol):
    def backup(self, backup_path: "str",password: "str"):
        raise NotImplementedError
    def backup_info(self, ):
        raise NotImplementedError
    def blind_receive(self, asset_id: "typing.Optional[str]",amount: "typing.Optional[int]",duration_seconds: "typing.Optional[int]",transport_endpoints: "typing.List[str]",min_confirmations: "int"):
        raise NotImplementedError
    def create_utxos(self, online: "Online",up_to: "bool",num: "typing.Optional[int]",size: "typing.Optional[int]",fee_rate: "int",skip_sync: "bool"):
        raise NotImplementedError
    def create_utxos_begin(self, online: "Online",up_to: "bool",num: "typing.Optional[int]",size: "typing.Optional[int]",fee_rate: "int",skip_sync: "bool"):
        raise NotImplementedError
    def create_utxos_end(self, online: "Online",signed_psbt: "str",skip_sync: "bool"):
        raise NotImplementedError
    def delete_transfers(self, batch_transfer_idx: "typing.Optional[int]",no_asset_only: "bool"):
        raise NotImplementedError
    def drain_to(self, online: "Online",address: "str",destroy_assets: "bool",fee_rate: "int"):
        raise NotImplementedError
    def drain_to_begin(self, online: "Online",address: "str",destroy_assets: "bool",fee_rate: "int"):
        raise NotImplementedError
    def drain_to_end(self, online: "Online",signed_psbt: "str"):
        raise NotImplementedError
    def fail_transfers(self, online: "Online",batch_transfer_idx: "typing.Optional[int]",no_asset_only: "bool",skip_sync: "bool"):
        raise NotImplementedError
    def get_address(self, ):
        raise NotImplementedError
    def get_asset_balance(self, asset_id: "str"):
        raise NotImplementedError
    def get_asset_metadata(self, asset_id: "str"):
        raise NotImplementedError
    def get_btc_balance(self, online: "typing.Optional[Online]",skip_sync: "bool"):
        raise NotImplementedError
    def get_fee_estimation(self, online: "Online",blocks: "int"):
        raise NotImplementedError
    def get_media_dir(self, ):
        raise NotImplementedError
    def get_wallet_data(self, ):
        raise NotImplementedError
    def get_wallet_dir(self, ):
        raise NotImplementedError
    def go_online(self, skip_consistency_check: "bool",indexer_url: "str"):
        raise NotImplementedError
    def issue_asset_cfa(self, online: "Online",name: "str",details: "typing.Optional[str]",precision: "int",amounts: "typing.List[int]",file_path: "typing.Optional[str]"):
        raise NotImplementedError
    def issue_asset_nia(self, online: "Online",ticker: "str",name: "str",precision: "int",amounts: "typing.List[int]"):
        raise NotImplementedError
    def issue_asset_uda(self, online: "Online",ticker: "str",name: "str",details: "typing.Optional[str]",precision: "int",media_file_path: "typing.Optional[str]",attachments_file_paths: "typing.List[str]"):
        raise NotImplementedError
    def list_assets(self, filter_asset_schemas: "typing.List[AssetSchema]"):
        raise NotImplementedError
    def list_transactions(self, online: "typing.Optional[Online]",skip_sync: "bool"):
        raise NotImplementedError
    def list_transfers(self, asset_id: "typing.Optional[str]"):
        raise NotImplementedError
    def list_unspents(self, online: "typing.Optional[Online]",settled_only: "bool",skip_sync: "bool"):
        raise NotImplementedError
    def refresh(self, online: "Online",asset_id: "typing.Optional[str]",filter: "typing.List[RefreshFilter]",skip_sync: "bool"):
        raise NotImplementedError
    def send(self, online: "Online",recipient_map: "dict[str, typing.List[Recipient]]",donation: "bool",fee_rate: "int",min_confirmations: "int",skip_sync: "bool"):
        raise NotImplementedError
    def send_begin(self, online: "Online",recipient_map: "dict[str, typing.List[Recipient]]",donation: "bool",fee_rate: "int",min_confirmations: "int"):
        raise NotImplementedError
    def send_btc(self, online: "Online",address: "str",amount: "int",fee_rate: "int",skip_sync: "bool"):
        raise NotImplementedError
    def send_btc_begin(self, online: "Online",address: "str",amount: "int",fee_rate: "int",skip_sync: "bool"):
        raise NotImplementedError
    def send_btc_end(self, online: "Online",signed_psbt: "str",skip_sync: "bool"):
        raise NotImplementedError
    def send_end(self, online: "Online",signed_psbt: "str",skip_sync: "bool"):
        raise NotImplementedError
    def sign_psbt(self, unsigned_psbt: "str"):
        raise NotImplementedError
    def sync(self, online: "Online"):
        raise NotImplementedError
    def witness_receive(self, asset_id: "typing.Optional[str]",amount: "typing.Optional[int]",duration_seconds: "typing.Optional[int]",transport_endpoints: "typing.List[str]",min_confirmations: "int"):
        raise NotImplementedError


class Wallet:
    _pointer: ctypes.c_void_p
    def __init__(self, wallet_data: "WalletData"):
        _UniffiConverterTypeWalletData.check_lower(wallet_data)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_constructor_wallet_new,
        _UniffiConverterTypeWalletData.lower(wallet_data))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_free_wallet, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_clone_wallet, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def backup(self, backup_path: "str",password: "str") -> None:
        _UniffiConverterString.check_lower(backup_path)
        
        _UniffiConverterString.check_lower(password)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_backup,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(backup_path),
        _UniffiConverterString.lower(password))






    def backup_info(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_backup_info,self._uniffi_clone_pointer(),)
        )





    def blind_receive(self, asset_id: "typing.Optional[str]",amount: "typing.Optional[int]",duration_seconds: "typing.Optional[int]",transport_endpoints: "typing.List[str]",min_confirmations: "int") -> "ReceiveData":
        _UniffiConverterOptionalString.check_lower(asset_id)
        
        _UniffiConverterOptionalUInt64.check_lower(amount)
        
        _UniffiConverterOptionalUInt32.check_lower(duration_seconds)
        
        _UniffiConverterSequenceString.check_lower(transport_endpoints)
        
        _UniffiConverterUInt8.check_lower(min_confirmations)
        
        return _UniffiConverterTypeReceiveData.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_blind_receive,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalString.lower(asset_id),
        _UniffiConverterOptionalUInt64.lower(amount),
        _UniffiConverterOptionalUInt32.lower(duration_seconds),
        _UniffiConverterSequenceString.lower(transport_endpoints),
        _UniffiConverterUInt8.lower(min_confirmations))
        )





    def create_utxos(self, online: "Online",up_to: "bool",num: "typing.Optional[int]",size: "typing.Optional[int]",fee_rate: "int",skip_sync: "bool") -> "int":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterBool.check_lower(up_to)
        
        _UniffiConverterOptionalUInt8.check_lower(num)
        
        _UniffiConverterOptionalUInt32.check_lower(size)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterUInt8.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterBool.lower(up_to),
        _UniffiConverterOptionalUInt8.lower(num),
        _UniffiConverterOptionalUInt32.lower(size),
        _UniffiConverterUInt64.lower(fee_rate),
        _UniffiConverterBool.lower(skip_sync))
        )





    def create_utxos_begin(self, online: "Online",up_to: "bool",num: "typing.Optional[int]",size: "typing.Optional[int]",fee_rate: "int",skip_sync: "bool") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterBool.check_lower(up_to)
        
        _UniffiConverterOptionalUInt8.check_lower(num)
        
        _UniffiConverterOptionalUInt32.check_lower(size)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos_begin,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterBool.lower(up_to),
        _UniffiConverterOptionalUInt8.lower(num),
        _UniffiConverterOptionalUInt32.lower(size),
        _UniffiConverterUInt64.lower(fee_rate),
        _UniffiConverterBool.lower(skip_sync))
        )





    def create_utxos_end(self, online: "Online",signed_psbt: "str",skip_sync: "bool") -> "int":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(signed_psbt)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterUInt8.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_create_utxos_end,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(signed_psbt),
        _UniffiConverterBool.lower(skip_sync))
        )





    def delete_transfers(self, batch_transfer_idx: "typing.Optional[int]",no_asset_only: "bool") -> "bool":
        _UniffiConverterOptionalInt32.check_lower(batch_transfer_idx)
        
        _UniffiConverterBool.check_lower(no_asset_only)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_delete_transfers,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt32.lower(batch_transfer_idx),
        _UniffiConverterBool.lower(no_asset_only))
        )





    def drain_to(self, online: "Online",address: "str",destroy_assets: "bool",fee_rate: "int") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(address)
        
        _UniffiConverterBool.check_lower(destroy_assets)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(address),
        _UniffiConverterBool.lower(destroy_assets),
        _UniffiConverterUInt64.lower(fee_rate))
        )





    def drain_to_begin(self, online: "Online",address: "str",destroy_assets: "bool",fee_rate: "int") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(address)
        
        _UniffiConverterBool.check_lower(destroy_assets)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to_begin,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(address),
        _UniffiConverterBool.lower(destroy_assets),
        _UniffiConverterUInt64.lower(fee_rate))
        )





    def drain_to_end(self, online: "Online",signed_psbt: "str") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(signed_psbt)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_drain_to_end,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(signed_psbt))
        )





    def fail_transfers(self, online: "Online",batch_transfer_idx: "typing.Optional[int]",no_asset_only: "bool",skip_sync: "bool") -> "bool":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterOptionalInt32.check_lower(batch_transfer_idx)
        
        _UniffiConverterBool.check_lower(no_asset_only)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_fail_transfers,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterOptionalInt32.lower(batch_transfer_idx),
        _UniffiConverterBool.lower(no_asset_only),
        _UniffiConverterBool.lower(skip_sync))
        )





    def get_address(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_address,self._uniffi_clone_pointer(),)
        )





    def get_asset_balance(self, asset_id: "str") -> "Balance":
        _UniffiConverterString.check_lower(asset_id)
        
        return _UniffiConverterTypeBalance.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_asset_balance,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(asset_id))
        )





    def get_asset_metadata(self, asset_id: "str") -> "Metadata":
        _UniffiConverterString.check_lower(asset_id)
        
        return _UniffiConverterTypeMetadata.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_asset_metadata,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(asset_id))
        )





    def get_btc_balance(self, online: "typing.Optional[Online]",skip_sync: "bool") -> "BtcBalance":
        _UniffiConverterOptionalTypeOnline.check_lower(online)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterTypeBtcBalance.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_btc_balance,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalTypeOnline.lower(online),
        _UniffiConverterBool.lower(skip_sync))
        )





    def get_fee_estimation(self, online: "Online",blocks: "int") -> "float":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterUInt16.check_lower(blocks)
        
        return _UniffiConverterDouble.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_fee_estimation,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterUInt16.lower(blocks))
        )





    def get_media_dir(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_media_dir,self._uniffi_clone_pointer(),)
        )





    def get_wallet_data(self, ) -> "WalletData":
        return _UniffiConverterTypeWalletData.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_wallet_data,self._uniffi_clone_pointer(),)
        )





    def get_wallet_dir(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_get_wallet_dir,self._uniffi_clone_pointer(),)
        )





    def go_online(self, skip_consistency_check: "bool",indexer_url: "str") -> "Online":
        _UniffiConverterBool.check_lower(skip_consistency_check)
        
        _UniffiConverterString.check_lower(indexer_url)
        
        return _UniffiConverterTypeOnline.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_go_online,self._uniffi_clone_pointer(),
        _UniffiConverterBool.lower(skip_consistency_check),
        _UniffiConverterString.lower(indexer_url))
        )





    def issue_asset_cfa(self, online: "Online",name: "str",details: "typing.Optional[str]",precision: "int",amounts: "typing.List[int]",file_path: "typing.Optional[str]") -> "AssetCfa":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(name)
        
        _UniffiConverterOptionalString.check_lower(details)
        
        _UniffiConverterUInt8.check_lower(precision)
        
        _UniffiConverterSequenceUInt64.check_lower(amounts)
        
        _UniffiConverterOptionalString.check_lower(file_path)
        
        return _UniffiConverterTypeAssetCfa.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_cfa,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(name),
        _UniffiConverterOptionalString.lower(details),
        _UniffiConverterUInt8.lower(precision),
        _UniffiConverterSequenceUInt64.lower(amounts),
        _UniffiConverterOptionalString.lower(file_path))
        )





    def issue_asset_nia(self, online: "Online",ticker: "str",name: "str",precision: "int",amounts: "typing.List[int]") -> "AssetNia":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(ticker)
        
        _UniffiConverterString.check_lower(name)
        
        _UniffiConverterUInt8.check_lower(precision)
        
        _UniffiConverterSequenceUInt64.check_lower(amounts)
        
        return _UniffiConverterTypeAssetNia.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_nia,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(ticker),
        _UniffiConverterString.lower(name),
        _UniffiConverterUInt8.lower(precision),
        _UniffiConverterSequenceUInt64.lower(amounts))
        )





    def issue_asset_uda(self, online: "Online",ticker: "str",name: "str",details: "typing.Optional[str]",precision: "int",media_file_path: "typing.Optional[str]",attachments_file_paths: "typing.List[str]") -> "AssetUda":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(ticker)
        
        _UniffiConverterString.check_lower(name)
        
        _UniffiConverterOptionalString.check_lower(details)
        
        _UniffiConverterUInt8.check_lower(precision)
        
        _UniffiConverterOptionalString.check_lower(media_file_path)
        
        _UniffiConverterSequenceString.check_lower(attachments_file_paths)
        
        return _UniffiConverterTypeAssetUda.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_issue_asset_uda,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(ticker),
        _UniffiConverterString.lower(name),
        _UniffiConverterOptionalString.lower(details),
        _UniffiConverterUInt8.lower(precision),
        _UniffiConverterOptionalString.lower(media_file_path),
        _UniffiConverterSequenceString.lower(attachments_file_paths))
        )





    def list_assets(self, filter_asset_schemas: "typing.List[AssetSchema]") -> "Assets":
        _UniffiConverterSequenceTypeAssetSchema.check_lower(filter_asset_schemas)
        
        return _UniffiConverterTypeAssets.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_assets,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeAssetSchema.lower(filter_asset_schemas))
        )





    def list_transactions(self, online: "typing.Optional[Online]",skip_sync: "bool") -> "typing.List[Transaction]":
        _UniffiConverterOptionalTypeOnline.check_lower(online)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterSequenceTypeTransaction.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_transactions,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalTypeOnline.lower(online),
        _UniffiConverterBool.lower(skip_sync))
        )





    def list_transfers(self, asset_id: "typing.Optional[str]") -> "typing.List[Transfer]":
        _UniffiConverterOptionalString.check_lower(asset_id)
        
        return _UniffiConverterSequenceTypeTransfer.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_transfers,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalString.lower(asset_id))
        )





    def list_unspents(self, online: "typing.Optional[Online]",settled_only: "bool",skip_sync: "bool") -> "typing.List[Unspent]":
        _UniffiConverterOptionalTypeOnline.check_lower(online)
        
        _UniffiConverterBool.check_lower(settled_only)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterSequenceTypeUnspent.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_list_unspents,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalTypeOnline.lower(online),
        _UniffiConverterBool.lower(settled_only),
        _UniffiConverterBool.lower(skip_sync))
        )





    def refresh(self, online: "Online",asset_id: "typing.Optional[str]",filter: "typing.List[RefreshFilter]",skip_sync: "bool") -> "dict[int, RefreshedTransfer]":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterOptionalString.check_lower(asset_id)
        
        _UniffiConverterSequenceTypeRefreshFilter.check_lower(filter)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterMapInt32TypeRefreshedTransfer.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_refresh,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterOptionalString.lower(asset_id),
        _UniffiConverterSequenceTypeRefreshFilter.lower(filter),
        _UniffiConverterBool.lower(skip_sync))
        )





    def send(self, online: "Online",recipient_map: "dict[str, typing.List[Recipient]]",donation: "bool",fee_rate: "int",min_confirmations: "int",skip_sync: "bool") -> "SendResult":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterMapStringSequenceTypeRecipient.check_lower(recipient_map)
        
        _UniffiConverterBool.check_lower(donation)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        _UniffiConverterUInt8.check_lower(min_confirmations)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterTypeSendResult.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterMapStringSequenceTypeRecipient.lower(recipient_map),
        _UniffiConverterBool.lower(donation),
        _UniffiConverterUInt64.lower(fee_rate),
        _UniffiConverterUInt8.lower(min_confirmations),
        _UniffiConverterBool.lower(skip_sync))
        )





    def send_begin(self, online: "Online",recipient_map: "dict[str, typing.List[Recipient]]",donation: "bool",fee_rate: "int",min_confirmations: "int") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterMapStringSequenceTypeRecipient.check_lower(recipient_map)
        
        _UniffiConverterBool.check_lower(donation)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        _UniffiConverterUInt8.check_lower(min_confirmations)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_begin,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterMapStringSequenceTypeRecipient.lower(recipient_map),
        _UniffiConverterBool.lower(donation),
        _UniffiConverterUInt64.lower(fee_rate),
        _UniffiConverterUInt8.lower(min_confirmations))
        )





    def send_btc(self, online: "Online",address: "str",amount: "int",fee_rate: "int",skip_sync: "bool") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(amount)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(address),
        _UniffiConverterUInt64.lower(amount),
        _UniffiConverterUInt64.lower(fee_rate),
        _UniffiConverterBool.lower(skip_sync))
        )





    def send_btc_begin(self, online: "Online",address: "str",amount: "int",fee_rate: "int",skip_sync: "bool") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(amount)
        
        _UniffiConverterUInt64.check_lower(fee_rate)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc_begin,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(address),
        _UniffiConverterUInt64.lower(amount),
        _UniffiConverterUInt64.lower(fee_rate),
        _UniffiConverterBool.lower(skip_sync))
        )





    def send_btc_end(self, online: "Online",signed_psbt: "str",skip_sync: "bool") -> "str":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(signed_psbt)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_btc_end,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(signed_psbt),
        _UniffiConverterBool.lower(skip_sync))
        )





    def send_end(self, online: "Online",signed_psbt: "str",skip_sync: "bool") -> "SendResult":
        _UniffiConverterTypeOnline.check_lower(online)
        
        _UniffiConverterString.check_lower(signed_psbt)
        
        _UniffiConverterBool.check_lower(skip_sync)
        
        return _UniffiConverterTypeSendResult.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_send_end,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online),
        _UniffiConverterString.lower(signed_psbt),
        _UniffiConverterBool.lower(skip_sync))
        )





    def sign_psbt(self, unsigned_psbt: "str") -> "str":
        _UniffiConverterString.check_lower(unsigned_psbt)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_sign_psbt,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(unsigned_psbt))
        )





    def sync(self, online: "Online") -> None:
        _UniffiConverterTypeOnline.check_lower(online)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_sync,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOnline.lower(online))






    def witness_receive(self, asset_id: "typing.Optional[str]",amount: "typing.Optional[int]",duration_seconds: "typing.Optional[int]",transport_endpoints: "typing.List[str]",min_confirmations: "int") -> "ReceiveData":
        _UniffiConverterOptionalString.check_lower(asset_id)
        
        _UniffiConverterOptionalUInt64.check_lower(amount)
        
        _UniffiConverterOptionalUInt32.check_lower(duration_seconds)
        
        _UniffiConverterSequenceString.check_lower(transport_endpoints)
        
        _UniffiConverterUInt8.check_lower(min_confirmations)
        
        return _UniffiConverterTypeReceiveData.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_method_wallet_witness_receive,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalString.lower(asset_id),
        _UniffiConverterOptionalUInt64.lower(amount),
        _UniffiConverterOptionalUInt32.lower(duration_seconds),
        _UniffiConverterSequenceString.lower(transport_endpoints),
        _UniffiConverterUInt8.lower(min_confirmations))
        )






class _UniffiConverterTypeWallet:

    @staticmethod
    def lift(value: int):
        return Wallet._make_instance_(value)

    @staticmethod
    def check_lower(value: Wallet):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WalletProtocol):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WalletProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))


class AssetCfa:
    asset_id: "str"
    asset_iface: "AssetIface"
    name: "str"
    details: "typing.Optional[str]"
    precision: "int"
    issued_supply: "int"
    timestamp: "int"
    added_at: "int"
    balance: "Balance"
    media: "typing.Optional[Media]"
    def __init__(self, *, asset_id: "str", asset_iface: "AssetIface", name: "str", details: "typing.Optional[str]", precision: "int", issued_supply: "int", timestamp: "int", added_at: "int", balance: "Balance", media: "typing.Optional[Media]"):
        self.asset_id = asset_id
        self.asset_iface = asset_iface
        self.name = name
        self.details = details
        self.precision = precision
        self.issued_supply = issued_supply
        self.timestamp = timestamp
        self.added_at = added_at
        self.balance = balance
        self.media = media

    def __str__(self):
        return "AssetCfa(asset_id={}, asset_iface={}, name={}, details={}, precision={}, issued_supply={}, timestamp={}, added_at={}, balance={}, media={})".format(self.asset_id, self.asset_iface, self.name, self.details, self.precision, self.issued_supply, self.timestamp, self.added_at, self.balance, self.media)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.asset_iface != other.asset_iface:
            return False
        if self.name != other.name:
            return False
        if self.details != other.details:
            return False
        if self.precision != other.precision:
            return False
        if self.issued_supply != other.issued_supply:
            return False
        if self.timestamp != other.timestamp:
            return False
        if self.added_at != other.added_at:
            return False
        if self.balance != other.balance:
            return False
        if self.media != other.media:
            return False
        return True

class _UniffiConverterTypeAssetCfa(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AssetCfa(
            asset_id=_UniffiConverterString.read(buf),
            asset_iface=_UniffiConverterTypeAssetIface.read(buf),
            name=_UniffiConverterString.read(buf),
            details=_UniffiConverterOptionalString.read(buf),
            precision=_UniffiConverterUInt8.read(buf),
            issued_supply=_UniffiConverterUInt64.read(buf),
            timestamp=_UniffiConverterInt64.read(buf),
            added_at=_UniffiConverterInt64.read(buf),
            balance=_UniffiConverterTypeBalance.read(buf),
            media=_UniffiConverterOptionalTypeMedia.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.asset_id)
        _UniffiConverterTypeAssetIface.check_lower(value.asset_iface)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.details)
        _UniffiConverterUInt8.check_lower(value.precision)
        _UniffiConverterUInt64.check_lower(value.issued_supply)
        _UniffiConverterInt64.check_lower(value.timestamp)
        _UniffiConverterInt64.check_lower(value.added_at)
        _UniffiConverterTypeBalance.check_lower(value.balance)
        _UniffiConverterOptionalTypeMedia.check_lower(value.media)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.asset_id, buf)
        _UniffiConverterTypeAssetIface.write(value.asset_iface, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.details, buf)
        _UniffiConverterUInt8.write(value.precision, buf)
        _UniffiConverterUInt64.write(value.issued_supply, buf)
        _UniffiConverterInt64.write(value.timestamp, buf)
        _UniffiConverterInt64.write(value.added_at, buf)
        _UniffiConverterTypeBalance.write(value.balance, buf)
        _UniffiConverterOptionalTypeMedia.write(value.media, buf)


class AssetNia:
    asset_id: "str"
    asset_iface: "AssetIface"
    ticker: "str"
    name: "str"
    details: "typing.Optional[str]"
    precision: "int"
    issued_supply: "int"
    timestamp: "int"
    added_at: "int"
    balance: "Balance"
    media: "typing.Optional[Media]"
    def __init__(self, *, asset_id: "str", asset_iface: "AssetIface", ticker: "str", name: "str", details: "typing.Optional[str]", precision: "int", issued_supply: "int", timestamp: "int", added_at: "int", balance: "Balance", media: "typing.Optional[Media]"):
        self.asset_id = asset_id
        self.asset_iface = asset_iface
        self.ticker = ticker
        self.name = name
        self.details = details
        self.precision = precision
        self.issued_supply = issued_supply
        self.timestamp = timestamp
        self.added_at = added_at
        self.balance = balance
        self.media = media

    def __str__(self):
        return "AssetNia(asset_id={}, asset_iface={}, ticker={}, name={}, details={}, precision={}, issued_supply={}, timestamp={}, added_at={}, balance={}, media={})".format(self.asset_id, self.asset_iface, self.ticker, self.name, self.details, self.precision, self.issued_supply, self.timestamp, self.added_at, self.balance, self.media)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.asset_iface != other.asset_iface:
            return False
        if self.ticker != other.ticker:
            return False
        if self.name != other.name:
            return False
        if self.details != other.details:
            return False
        if self.precision != other.precision:
            return False
        if self.issued_supply != other.issued_supply:
            return False
        if self.timestamp != other.timestamp:
            return False
        if self.added_at != other.added_at:
            return False
        if self.balance != other.balance:
            return False
        if self.media != other.media:
            return False
        return True

class _UniffiConverterTypeAssetNia(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AssetNia(
            asset_id=_UniffiConverterString.read(buf),
            asset_iface=_UniffiConverterTypeAssetIface.read(buf),
            ticker=_UniffiConverterString.read(buf),
            name=_UniffiConverterString.read(buf),
            details=_UniffiConverterOptionalString.read(buf),
            precision=_UniffiConverterUInt8.read(buf),
            issued_supply=_UniffiConverterUInt64.read(buf),
            timestamp=_UniffiConverterInt64.read(buf),
            added_at=_UniffiConverterInt64.read(buf),
            balance=_UniffiConverterTypeBalance.read(buf),
            media=_UniffiConverterOptionalTypeMedia.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.asset_id)
        _UniffiConverterTypeAssetIface.check_lower(value.asset_iface)
        _UniffiConverterString.check_lower(value.ticker)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.details)
        _UniffiConverterUInt8.check_lower(value.precision)
        _UniffiConverterUInt64.check_lower(value.issued_supply)
        _UniffiConverterInt64.check_lower(value.timestamp)
        _UniffiConverterInt64.check_lower(value.added_at)
        _UniffiConverterTypeBalance.check_lower(value.balance)
        _UniffiConverterOptionalTypeMedia.check_lower(value.media)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.asset_id, buf)
        _UniffiConverterTypeAssetIface.write(value.asset_iface, buf)
        _UniffiConverterString.write(value.ticker, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.details, buf)
        _UniffiConverterUInt8.write(value.precision, buf)
        _UniffiConverterUInt64.write(value.issued_supply, buf)
        _UniffiConverterInt64.write(value.timestamp, buf)
        _UniffiConverterInt64.write(value.added_at, buf)
        _UniffiConverterTypeBalance.write(value.balance, buf)
        _UniffiConverterOptionalTypeMedia.write(value.media, buf)


class AssetUda:
    asset_id: "str"
    asset_iface: "AssetIface"
    ticker: "str"
    name: "str"
    details: "typing.Optional[str]"
    precision: "int"
    issued_supply: "int"
    timestamp: "int"
    added_at: "int"
    balance: "Balance"
    token: "typing.Optional[TokenLight]"
    def __init__(self, *, asset_id: "str", asset_iface: "AssetIface", ticker: "str", name: "str", details: "typing.Optional[str]", precision: "int", issued_supply: "int", timestamp: "int", added_at: "int", balance: "Balance", token: "typing.Optional[TokenLight]"):
        self.asset_id = asset_id
        self.asset_iface = asset_iface
        self.ticker = ticker
        self.name = name
        self.details = details
        self.precision = precision
        self.issued_supply = issued_supply
        self.timestamp = timestamp
        self.added_at = added_at
        self.balance = balance
        self.token = token

    def __str__(self):
        return "AssetUda(asset_id={}, asset_iface={}, ticker={}, name={}, details={}, precision={}, issued_supply={}, timestamp={}, added_at={}, balance={}, token={})".format(self.asset_id, self.asset_iface, self.ticker, self.name, self.details, self.precision, self.issued_supply, self.timestamp, self.added_at, self.balance, self.token)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.asset_iface != other.asset_iface:
            return False
        if self.ticker != other.ticker:
            return False
        if self.name != other.name:
            return False
        if self.details != other.details:
            return False
        if self.precision != other.precision:
            return False
        if self.issued_supply != other.issued_supply:
            return False
        if self.timestamp != other.timestamp:
            return False
        if self.added_at != other.added_at:
            return False
        if self.balance != other.balance:
            return False
        if self.token != other.token:
            return False
        return True

class _UniffiConverterTypeAssetUda(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AssetUda(
            asset_id=_UniffiConverterString.read(buf),
            asset_iface=_UniffiConverterTypeAssetIface.read(buf),
            ticker=_UniffiConverterString.read(buf),
            name=_UniffiConverterString.read(buf),
            details=_UniffiConverterOptionalString.read(buf),
            precision=_UniffiConverterUInt8.read(buf),
            issued_supply=_UniffiConverterUInt64.read(buf),
            timestamp=_UniffiConverterInt64.read(buf),
            added_at=_UniffiConverterInt64.read(buf),
            balance=_UniffiConverterTypeBalance.read(buf),
            token=_UniffiConverterOptionalTypeTokenLight.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.asset_id)
        _UniffiConverterTypeAssetIface.check_lower(value.asset_iface)
        _UniffiConverterString.check_lower(value.ticker)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.details)
        _UniffiConverterUInt8.check_lower(value.precision)
        _UniffiConverterUInt64.check_lower(value.issued_supply)
        _UniffiConverterInt64.check_lower(value.timestamp)
        _UniffiConverterInt64.check_lower(value.added_at)
        _UniffiConverterTypeBalance.check_lower(value.balance)
        _UniffiConverterOptionalTypeTokenLight.check_lower(value.token)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.asset_id, buf)
        _UniffiConverterTypeAssetIface.write(value.asset_iface, buf)
        _UniffiConverterString.write(value.ticker, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.details, buf)
        _UniffiConverterUInt8.write(value.precision, buf)
        _UniffiConverterUInt64.write(value.issued_supply, buf)
        _UniffiConverterInt64.write(value.timestamp, buf)
        _UniffiConverterInt64.write(value.added_at, buf)
        _UniffiConverterTypeBalance.write(value.balance, buf)
        _UniffiConverterOptionalTypeTokenLight.write(value.token, buf)


class Assets:
    nia: "typing.Optional[typing.List[AssetNia]]"
    uda: "typing.Optional[typing.List[AssetUda]]"
    cfa: "typing.Optional[typing.List[AssetCfa]]"
    def __init__(self, *, nia: "typing.Optional[typing.List[AssetNia]]", uda: "typing.Optional[typing.List[AssetUda]]", cfa: "typing.Optional[typing.List[AssetCfa]]"):
        self.nia = nia
        self.uda = uda
        self.cfa = cfa

    def __str__(self):
        return "Assets(nia={}, uda={}, cfa={})".format(self.nia, self.uda, self.cfa)

    def __eq__(self, other):
        if self.nia != other.nia:
            return False
        if self.uda != other.uda:
            return False
        if self.cfa != other.cfa:
            return False
        return True

class _UniffiConverterTypeAssets(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Assets(
            nia=_UniffiConverterOptionalSequenceTypeAssetNia.read(buf),
            uda=_UniffiConverterOptionalSequenceTypeAssetUda.read(buf),
            cfa=_UniffiConverterOptionalSequenceTypeAssetCfa.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalSequenceTypeAssetNia.check_lower(value.nia)
        _UniffiConverterOptionalSequenceTypeAssetUda.check_lower(value.uda)
        _UniffiConverterOptionalSequenceTypeAssetCfa.check_lower(value.cfa)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalSequenceTypeAssetNia.write(value.nia, buf)
        _UniffiConverterOptionalSequenceTypeAssetUda.write(value.uda, buf)
        _UniffiConverterOptionalSequenceTypeAssetCfa.write(value.cfa, buf)


class Balance:
    settled: "int"
    future: "int"
    spendable: "int"
    def __init__(self, *, settled: "int", future: "int", spendable: "int"):
        self.settled = settled
        self.future = future
        self.spendable = spendable

    def __str__(self):
        return "Balance(settled={}, future={}, spendable={})".format(self.settled, self.future, self.spendable)

    def __eq__(self, other):
        if self.settled != other.settled:
            return False
        if self.future != other.future:
            return False
        if self.spendable != other.spendable:
            return False
        return True

class _UniffiConverterTypeBalance(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Balance(
            settled=_UniffiConverterUInt64.read(buf),
            future=_UniffiConverterUInt64.read(buf),
            spendable=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.settled)
        _UniffiConverterUInt64.check_lower(value.future)
        _UniffiConverterUInt64.check_lower(value.spendable)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.settled, buf)
        _UniffiConverterUInt64.write(value.future, buf)
        _UniffiConverterUInt64.write(value.spendable, buf)


class BlockTime:
    height: "int"
    timestamp: "int"
    def __init__(self, *, height: "int", timestamp: "int"):
        self.height = height
        self.timestamp = timestamp

    def __str__(self):
        return "BlockTime(height={}, timestamp={})".format(self.height, self.timestamp)

    def __eq__(self, other):
        if self.height != other.height:
            return False
        if self.timestamp != other.timestamp:
            return False
        return True

class _UniffiConverterTypeBlockTime(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BlockTime(
            height=_UniffiConverterUInt32.read(buf),
            timestamp=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.height)
        _UniffiConverterUInt64.check_lower(value.timestamp)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.height, buf)
        _UniffiConverterUInt64.write(value.timestamp, buf)


class BtcBalance:
    vanilla: "Balance"
    colored: "Balance"
    def __init__(self, *, vanilla: "Balance", colored: "Balance"):
        self.vanilla = vanilla
        self.colored = colored

    def __str__(self):
        return "BtcBalance(vanilla={}, colored={})".format(self.vanilla, self.colored)

    def __eq__(self, other):
        if self.vanilla != other.vanilla:
            return False
        if self.colored != other.colored:
            return False
        return True

class _UniffiConverterTypeBtcBalance(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BtcBalance(
            vanilla=_UniffiConverterTypeBalance.read(buf),
            colored=_UniffiConverterTypeBalance.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeBalance.check_lower(value.vanilla)
        _UniffiConverterTypeBalance.check_lower(value.colored)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeBalance.write(value.vanilla, buf)
        _UniffiConverterTypeBalance.write(value.colored, buf)


class EmbeddedMedia:
    mime: "str"
    data: "typing.List[int]"
    def __init__(self, *, mime: "str", data: "typing.List[int]"):
        self.mime = mime
        self.data = data

    def __str__(self):
        return "EmbeddedMedia(mime={}, data={})".format(self.mime, self.data)

    def __eq__(self, other):
        if self.mime != other.mime:
            return False
        if self.data != other.data:
            return False
        return True

class _UniffiConverterTypeEmbeddedMedia(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return EmbeddedMedia(
            mime=_UniffiConverterString.read(buf),
            data=_UniffiConverterSequenceUInt8.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.mime)
        _UniffiConverterSequenceUInt8.check_lower(value.data)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.mime, buf)
        _UniffiConverterSequenceUInt8.write(value.data, buf)


class InvoiceData:
    recipient_id: "str"
    asset_iface: "typing.Optional[AssetIface]"
    asset_id: "typing.Optional[str]"
    amount: "typing.Optional[int]"
    network: "BitcoinNetwork"
    expiration_timestamp: "typing.Optional[int]"
    transport_endpoints: "typing.List[str]"
    def __init__(self, *, recipient_id: "str", asset_iface: "typing.Optional[AssetIface]", asset_id: "typing.Optional[str]", amount: "typing.Optional[int]", network: "BitcoinNetwork", expiration_timestamp: "typing.Optional[int]", transport_endpoints: "typing.List[str]"):
        self.recipient_id = recipient_id
        self.asset_iface = asset_iface
        self.asset_id = asset_id
        self.amount = amount
        self.network = network
        self.expiration_timestamp = expiration_timestamp
        self.transport_endpoints = transport_endpoints

    def __str__(self):
        return "InvoiceData(recipient_id={}, asset_iface={}, asset_id={}, amount={}, network={}, expiration_timestamp={}, transport_endpoints={})".format(self.recipient_id, self.asset_iface, self.asset_id, self.amount, self.network, self.expiration_timestamp, self.transport_endpoints)

    def __eq__(self, other):
        if self.recipient_id != other.recipient_id:
            return False
        if self.asset_iface != other.asset_iface:
            return False
        if self.asset_id != other.asset_id:
            return False
        if self.amount != other.amount:
            return False
        if self.network != other.network:
            return False
        if self.expiration_timestamp != other.expiration_timestamp:
            return False
        if self.transport_endpoints != other.transport_endpoints:
            return False
        return True

class _UniffiConverterTypeInvoiceData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return InvoiceData(
            recipient_id=_UniffiConverterString.read(buf),
            asset_iface=_UniffiConverterOptionalTypeAssetIface.read(buf),
            asset_id=_UniffiConverterOptionalString.read(buf),
            amount=_UniffiConverterOptionalUInt64.read(buf),
            network=_UniffiConverterTypeBitcoinNetwork.read(buf),
            expiration_timestamp=_UniffiConverterOptionalInt64.read(buf),
            transport_endpoints=_UniffiConverterSequenceString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.recipient_id)
        _UniffiConverterOptionalTypeAssetIface.check_lower(value.asset_iface)
        _UniffiConverterOptionalString.check_lower(value.asset_id)
        _UniffiConverterOptionalUInt64.check_lower(value.amount)
        _UniffiConverterTypeBitcoinNetwork.check_lower(value.network)
        _UniffiConverterOptionalInt64.check_lower(value.expiration_timestamp)
        _UniffiConverterSequenceString.check_lower(value.transport_endpoints)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.recipient_id, buf)
        _UniffiConverterOptionalTypeAssetIface.write(value.asset_iface, buf)
        _UniffiConverterOptionalString.write(value.asset_id, buf)
        _UniffiConverterOptionalUInt64.write(value.amount, buf)
        _UniffiConverterTypeBitcoinNetwork.write(value.network, buf)
        _UniffiConverterOptionalInt64.write(value.expiration_timestamp, buf)
        _UniffiConverterSequenceString.write(value.transport_endpoints, buf)


class Keys:
    mnemonic: "str"
    xpub: "str"
    account_xpub: "str"
    account_xpub_fingerprint: "str"
    def __init__(self, *, mnemonic: "str", xpub: "str", account_xpub: "str", account_xpub_fingerprint: "str"):
        self.mnemonic = mnemonic
        self.xpub = xpub
        self.account_xpub = account_xpub
        self.account_xpub_fingerprint = account_xpub_fingerprint

    def __str__(self):
        return "Keys(mnemonic={}, xpub={}, account_xpub={}, account_xpub_fingerprint={})".format(self.mnemonic, self.xpub, self.account_xpub, self.account_xpub_fingerprint)

    def __eq__(self, other):
        if self.mnemonic != other.mnemonic:
            return False
        if self.xpub != other.xpub:
            return False
        if self.account_xpub != other.account_xpub:
            return False
        if self.account_xpub_fingerprint != other.account_xpub_fingerprint:
            return False
        return True

class _UniffiConverterTypeKeys(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Keys(
            mnemonic=_UniffiConverterString.read(buf),
            xpub=_UniffiConverterString.read(buf),
            account_xpub=_UniffiConverterString.read(buf),
            account_xpub_fingerprint=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.mnemonic)
        _UniffiConverterString.check_lower(value.xpub)
        _UniffiConverterString.check_lower(value.account_xpub)
        _UniffiConverterString.check_lower(value.account_xpub_fingerprint)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.mnemonic, buf)
        _UniffiConverterString.write(value.xpub, buf)
        _UniffiConverterString.write(value.account_xpub, buf)
        _UniffiConverterString.write(value.account_xpub_fingerprint, buf)


class Media:
    file_path: "str"
    digest: "str"
    mime: "str"
    def __init__(self, *, file_path: "str", digest: "str", mime: "str"):
        self.file_path = file_path
        self.digest = digest
        self.mime = mime

    def __str__(self):
        return "Media(file_path={}, digest={}, mime={})".format(self.file_path, self.digest, self.mime)

    def __eq__(self, other):
        if self.file_path != other.file_path:
            return False
        if self.digest != other.digest:
            return False
        if self.mime != other.mime:
            return False
        return True

class _UniffiConverterTypeMedia(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Media(
            file_path=_UniffiConverterString.read(buf),
            digest=_UniffiConverterString.read(buf),
            mime=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.file_path)
        _UniffiConverterString.check_lower(value.digest)
        _UniffiConverterString.check_lower(value.mime)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.file_path, buf)
        _UniffiConverterString.write(value.digest, buf)
        _UniffiConverterString.write(value.mime, buf)


class Metadata:
    asset_iface: "AssetIface"
    asset_schema: "AssetSchema"
    issued_supply: "int"
    timestamp: "int"
    name: "str"
    precision: "int"
    ticker: "typing.Optional[str]"
    details: "typing.Optional[str]"
    token: "typing.Optional[Token]"
    def __init__(self, *, asset_iface: "AssetIface", asset_schema: "AssetSchema", issued_supply: "int", timestamp: "int", name: "str", precision: "int", ticker: "typing.Optional[str]", details: "typing.Optional[str]", token: "typing.Optional[Token]"):
        self.asset_iface = asset_iface
        self.asset_schema = asset_schema
        self.issued_supply = issued_supply
        self.timestamp = timestamp
        self.name = name
        self.precision = precision
        self.ticker = ticker
        self.details = details
        self.token = token

    def __str__(self):
        return "Metadata(asset_iface={}, asset_schema={}, issued_supply={}, timestamp={}, name={}, precision={}, ticker={}, details={}, token={})".format(self.asset_iface, self.asset_schema, self.issued_supply, self.timestamp, self.name, self.precision, self.ticker, self.details, self.token)

    def __eq__(self, other):
        if self.asset_iface != other.asset_iface:
            return False
        if self.asset_schema != other.asset_schema:
            return False
        if self.issued_supply != other.issued_supply:
            return False
        if self.timestamp != other.timestamp:
            return False
        if self.name != other.name:
            return False
        if self.precision != other.precision:
            return False
        if self.ticker != other.ticker:
            return False
        if self.details != other.details:
            return False
        if self.token != other.token:
            return False
        return True

class _UniffiConverterTypeMetadata(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Metadata(
            asset_iface=_UniffiConverterTypeAssetIface.read(buf),
            asset_schema=_UniffiConverterTypeAssetSchema.read(buf),
            issued_supply=_UniffiConverterUInt64.read(buf),
            timestamp=_UniffiConverterInt64.read(buf),
            name=_UniffiConverterString.read(buf),
            precision=_UniffiConverterUInt8.read(buf),
            ticker=_UniffiConverterOptionalString.read(buf),
            details=_UniffiConverterOptionalString.read(buf),
            token=_UniffiConverterOptionalTypeToken.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeAssetIface.check_lower(value.asset_iface)
        _UniffiConverterTypeAssetSchema.check_lower(value.asset_schema)
        _UniffiConverterUInt64.check_lower(value.issued_supply)
        _UniffiConverterInt64.check_lower(value.timestamp)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterUInt8.check_lower(value.precision)
        _UniffiConverterOptionalString.check_lower(value.ticker)
        _UniffiConverterOptionalString.check_lower(value.details)
        _UniffiConverterOptionalTypeToken.check_lower(value.token)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeAssetIface.write(value.asset_iface, buf)
        _UniffiConverterTypeAssetSchema.write(value.asset_schema, buf)
        _UniffiConverterUInt64.write(value.issued_supply, buf)
        _UniffiConverterInt64.write(value.timestamp, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterUInt8.write(value.precision, buf)
        _UniffiConverterOptionalString.write(value.ticker, buf)
        _UniffiConverterOptionalString.write(value.details, buf)
        _UniffiConverterOptionalTypeToken.write(value.token, buf)


class Online:
    id: "int"
    indexer_url: "str"
    def __init__(self, *, id: "int", indexer_url: "str"):
        self.id = id
        self.indexer_url = indexer_url

    def __str__(self):
        return "Online(id={}, indexer_url={})".format(self.id, self.indexer_url)

    def __eq__(self, other):
        if self.id != other.id:
            return False
        if self.indexer_url != other.indexer_url:
            return False
        return True

class _UniffiConverterTypeOnline(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Online(
            id=_UniffiConverterUInt64.read(buf),
            indexer_url=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.id)
        _UniffiConverterString.check_lower(value.indexer_url)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.id, buf)
        _UniffiConverterString.write(value.indexer_url, buf)


class Outpoint:
    txid: "str"
    vout: "int"
    def __init__(self, *, txid: "str", vout: "int"):
        self.txid = txid
        self.vout = vout

    def __str__(self):
        return "Outpoint(txid={}, vout={})".format(self.txid, self.vout)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        return True

class _UniffiConverterTypeOutpoint(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Outpoint(
            txid=_UniffiConverterString.read(buf),
            vout=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.txid)
        _UniffiConverterUInt32.check_lower(value.vout)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterUInt32.write(value.vout, buf)


class ProofOfReserves:
    utxo: "Outpoint"
    proof: "typing.List[int]"
    def __init__(self, *, utxo: "Outpoint", proof: "typing.List[int]"):
        self.utxo = utxo
        self.proof = proof

    def __str__(self):
        return "ProofOfReserves(utxo={}, proof={})".format(self.utxo, self.proof)

    def __eq__(self, other):
        if self.utxo != other.utxo:
            return False
        if self.proof != other.proof:
            return False
        return True

class _UniffiConverterTypeProofOfReserves(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ProofOfReserves(
            utxo=_UniffiConverterTypeOutpoint.read(buf),
            proof=_UniffiConverterSequenceUInt8.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeOutpoint.check_lower(value.utxo)
        _UniffiConverterSequenceUInt8.check_lower(value.proof)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeOutpoint.write(value.utxo, buf)
        _UniffiConverterSequenceUInt8.write(value.proof, buf)


class ReceiveData:
    invoice: "str"
    recipient_id: "str"
    expiration_timestamp: "typing.Optional[int]"
    batch_transfer_idx: "int"
    def __init__(self, *, invoice: "str", recipient_id: "str", expiration_timestamp: "typing.Optional[int]", batch_transfer_idx: "int"):
        self.invoice = invoice
        self.recipient_id = recipient_id
        self.expiration_timestamp = expiration_timestamp
        self.batch_transfer_idx = batch_transfer_idx

    def __str__(self):
        return "ReceiveData(invoice={}, recipient_id={}, expiration_timestamp={}, batch_transfer_idx={})".format(self.invoice, self.recipient_id, self.expiration_timestamp, self.batch_transfer_idx)

    def __eq__(self, other):
        if self.invoice != other.invoice:
            return False
        if self.recipient_id != other.recipient_id:
            return False
        if self.expiration_timestamp != other.expiration_timestamp:
            return False
        if self.batch_transfer_idx != other.batch_transfer_idx:
            return False
        return True

class _UniffiConverterTypeReceiveData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ReceiveData(
            invoice=_UniffiConverterString.read(buf),
            recipient_id=_UniffiConverterString.read(buf),
            expiration_timestamp=_UniffiConverterOptionalInt64.read(buf),
            batch_transfer_idx=_UniffiConverterInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.invoice)
        _UniffiConverterString.check_lower(value.recipient_id)
        _UniffiConverterOptionalInt64.check_lower(value.expiration_timestamp)
        _UniffiConverterInt32.check_lower(value.batch_transfer_idx)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.invoice, buf)
        _UniffiConverterString.write(value.recipient_id, buf)
        _UniffiConverterOptionalInt64.write(value.expiration_timestamp, buf)
        _UniffiConverterInt32.write(value.batch_transfer_idx, buf)


class Recipient:
    recipient_id: "str"
    witness_data: "typing.Optional[WitnessData]"
    amount: "int"
    transport_endpoints: "typing.List[str]"
    def __init__(self, *, recipient_id: "str", witness_data: "typing.Optional[WitnessData]", amount: "int", transport_endpoints: "typing.List[str]"):
        self.recipient_id = recipient_id
        self.witness_data = witness_data
        self.amount = amount
        self.transport_endpoints = transport_endpoints

    def __str__(self):
        return "Recipient(recipient_id={}, witness_data={}, amount={}, transport_endpoints={})".format(self.recipient_id, self.witness_data, self.amount, self.transport_endpoints)

    def __eq__(self, other):
        if self.recipient_id != other.recipient_id:
            return False
        if self.witness_data != other.witness_data:
            return False
        if self.amount != other.amount:
            return False
        if self.transport_endpoints != other.transport_endpoints:
            return False
        return True

class _UniffiConverterTypeRecipient(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Recipient(
            recipient_id=_UniffiConverterString.read(buf),
            witness_data=_UniffiConverterOptionalTypeWitnessData.read(buf),
            amount=_UniffiConverterUInt64.read(buf),
            transport_endpoints=_UniffiConverterSequenceString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.recipient_id)
        _UniffiConverterOptionalTypeWitnessData.check_lower(value.witness_data)
        _UniffiConverterUInt64.check_lower(value.amount)
        _UniffiConverterSequenceString.check_lower(value.transport_endpoints)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.recipient_id, buf)
        _UniffiConverterOptionalTypeWitnessData.write(value.witness_data, buf)
        _UniffiConverterUInt64.write(value.amount, buf)
        _UniffiConverterSequenceString.write(value.transport_endpoints, buf)


class RefreshFilter:
    status: "RefreshTransferStatus"
    incoming: "bool"
    def __init__(self, *, status: "RefreshTransferStatus", incoming: "bool"):
        self.status = status
        self.incoming = incoming

    def __str__(self):
        return "RefreshFilter(status={}, incoming={})".format(self.status, self.incoming)

    def __eq__(self, other):
        if self.status != other.status:
            return False
        if self.incoming != other.incoming:
            return False
        return True

class _UniffiConverterTypeRefreshFilter(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RefreshFilter(
            status=_UniffiConverterTypeRefreshTransferStatus.read(buf),
            incoming=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeRefreshTransferStatus.check_lower(value.status)
        _UniffiConverterBool.check_lower(value.incoming)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeRefreshTransferStatus.write(value.status, buf)
        _UniffiConverterBool.write(value.incoming, buf)


class RefreshedTransfer:
    updated_status: "typing.Optional[TransferStatus]"
    failure: "typing.Optional[RgbLibError]"
    def __init__(self, *, updated_status: "typing.Optional[TransferStatus]", failure: "typing.Optional[RgbLibError]"):
        self.updated_status = updated_status
        self.failure = failure

    def __str__(self):
        return "RefreshedTransfer(updated_status={}, failure={})".format(self.updated_status, self.failure)

    def __eq__(self, other):
        if self.updated_status != other.updated_status:
            return False
        if self.failure != other.failure:
            return False
        return True

class _UniffiConverterTypeRefreshedTransfer(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RefreshedTransfer(
            updated_status=_UniffiConverterOptionalTypeTransferStatus.read(buf),
            failure=_UniffiConverterOptionalTypeRgbLibError.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalTypeTransferStatus.check_lower(value.updated_status)
        _UniffiConverterOptionalTypeRgbLibError.check_lower(value.failure)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalTypeTransferStatus.write(value.updated_status, buf)
        _UniffiConverterOptionalTypeRgbLibError.write(value.failure, buf)


class RgbAllocation:
    asset_id: "typing.Optional[str]"
    amount: "int"
    settled: "bool"
    def __init__(self, *, asset_id: "typing.Optional[str]", amount: "int", settled: "bool"):
        self.asset_id = asset_id
        self.amount = amount
        self.settled = settled

    def __str__(self):
        return "RgbAllocation(asset_id={}, amount={}, settled={})".format(self.asset_id, self.amount, self.settled)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.amount != other.amount:
            return False
        if self.settled != other.settled:
            return False
        return True

class _UniffiConverterTypeRgbAllocation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RgbAllocation(
            asset_id=_UniffiConverterOptionalString.read(buf),
            amount=_UniffiConverterUInt64.read(buf),
            settled=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.asset_id)
        _UniffiConverterUInt64.check_lower(value.amount)
        _UniffiConverterBool.check_lower(value.settled)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.asset_id, buf)
        _UniffiConverterUInt64.write(value.amount, buf)
        _UniffiConverterBool.write(value.settled, buf)


class SendResult:
    txid: "str"
    batch_transfer_idx: "int"
    def __init__(self, *, txid: "str", batch_transfer_idx: "int"):
        self.txid = txid
        self.batch_transfer_idx = batch_transfer_idx

    def __str__(self):
        return "SendResult(txid={}, batch_transfer_idx={})".format(self.txid, self.batch_transfer_idx)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.batch_transfer_idx != other.batch_transfer_idx:
            return False
        return True

class _UniffiConverterTypeSendResult(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SendResult(
            txid=_UniffiConverterString.read(buf),
            batch_transfer_idx=_UniffiConverterInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.txid)
        _UniffiConverterInt32.check_lower(value.batch_transfer_idx)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterInt32.write(value.batch_transfer_idx, buf)


class Token:
    index: "int"
    ticker: "typing.Optional[str]"
    name: "typing.Optional[str]"
    details: "typing.Optional[str]"
    embedded_media: "typing.Optional[EmbeddedMedia]"
    media: "typing.Optional[Media]"
    attachments: "dict[int, Media]"
    reserves: "typing.Optional[ProofOfReserves]"
    def __init__(self, *, index: "int", ticker: "typing.Optional[str]", name: "typing.Optional[str]", details: "typing.Optional[str]", embedded_media: "typing.Optional[EmbeddedMedia]", media: "typing.Optional[Media]", attachments: "dict[int, Media]", reserves: "typing.Optional[ProofOfReserves]"):
        self.index = index
        self.ticker = ticker
        self.name = name
        self.details = details
        self.embedded_media = embedded_media
        self.media = media
        self.attachments = attachments
        self.reserves = reserves

    def __str__(self):
        return "Token(index={}, ticker={}, name={}, details={}, embedded_media={}, media={}, attachments={}, reserves={})".format(self.index, self.ticker, self.name, self.details, self.embedded_media, self.media, self.attachments, self.reserves)

    def __eq__(self, other):
        if self.index != other.index:
            return False
        if self.ticker != other.ticker:
            return False
        if self.name != other.name:
            return False
        if self.details != other.details:
            return False
        if self.embedded_media != other.embedded_media:
            return False
        if self.media != other.media:
            return False
        if self.attachments != other.attachments:
            return False
        if self.reserves != other.reserves:
            return False
        return True

class _UniffiConverterTypeToken(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Token(
            index=_UniffiConverterUInt32.read(buf),
            ticker=_UniffiConverterOptionalString.read(buf),
            name=_UniffiConverterOptionalString.read(buf),
            details=_UniffiConverterOptionalString.read(buf),
            embedded_media=_UniffiConverterOptionalTypeEmbeddedMedia.read(buf),
            media=_UniffiConverterOptionalTypeMedia.read(buf),
            attachments=_UniffiConverterMapUInt8TypeMedia.read(buf),
            reserves=_UniffiConverterOptionalTypeProofOfReserves.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.index)
        _UniffiConverterOptionalString.check_lower(value.ticker)
        _UniffiConverterOptionalString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.details)
        _UniffiConverterOptionalTypeEmbeddedMedia.check_lower(value.embedded_media)
        _UniffiConverterOptionalTypeMedia.check_lower(value.media)
        _UniffiConverterMapUInt8TypeMedia.check_lower(value.attachments)
        _UniffiConverterOptionalTypeProofOfReserves.check_lower(value.reserves)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.index, buf)
        _UniffiConverterOptionalString.write(value.ticker, buf)
        _UniffiConverterOptionalString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.details, buf)
        _UniffiConverterOptionalTypeEmbeddedMedia.write(value.embedded_media, buf)
        _UniffiConverterOptionalTypeMedia.write(value.media, buf)
        _UniffiConverterMapUInt8TypeMedia.write(value.attachments, buf)
        _UniffiConverterOptionalTypeProofOfReserves.write(value.reserves, buf)


class TokenLight:
    index: "int"
    ticker: "typing.Optional[str]"
    name: "typing.Optional[str]"
    details: "typing.Optional[str]"
    embedded_media: "bool"
    media: "typing.Optional[Media]"
    attachments: "dict[int, Media]"
    reserves: "bool"
    def __init__(self, *, index: "int", ticker: "typing.Optional[str]", name: "typing.Optional[str]", details: "typing.Optional[str]", embedded_media: "bool", media: "typing.Optional[Media]", attachments: "dict[int, Media]", reserves: "bool"):
        self.index = index
        self.ticker = ticker
        self.name = name
        self.details = details
        self.embedded_media = embedded_media
        self.media = media
        self.attachments = attachments
        self.reserves = reserves

    def __str__(self):
        return "TokenLight(index={}, ticker={}, name={}, details={}, embedded_media={}, media={}, attachments={}, reserves={})".format(self.index, self.ticker, self.name, self.details, self.embedded_media, self.media, self.attachments, self.reserves)

    def __eq__(self, other):
        if self.index != other.index:
            return False
        if self.ticker != other.ticker:
            return False
        if self.name != other.name:
            return False
        if self.details != other.details:
            return False
        if self.embedded_media != other.embedded_media:
            return False
        if self.media != other.media:
            return False
        if self.attachments != other.attachments:
            return False
        if self.reserves != other.reserves:
            return False
        return True

class _UniffiConverterTypeTokenLight(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TokenLight(
            index=_UniffiConverterUInt32.read(buf),
            ticker=_UniffiConverterOptionalString.read(buf),
            name=_UniffiConverterOptionalString.read(buf),
            details=_UniffiConverterOptionalString.read(buf),
            embedded_media=_UniffiConverterBool.read(buf),
            media=_UniffiConverterOptionalTypeMedia.read(buf),
            attachments=_UniffiConverterMapUInt8TypeMedia.read(buf),
            reserves=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.index)
        _UniffiConverterOptionalString.check_lower(value.ticker)
        _UniffiConverterOptionalString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.details)
        _UniffiConverterBool.check_lower(value.embedded_media)
        _UniffiConverterOptionalTypeMedia.check_lower(value.media)
        _UniffiConverterMapUInt8TypeMedia.check_lower(value.attachments)
        _UniffiConverterBool.check_lower(value.reserves)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.index, buf)
        _UniffiConverterOptionalString.write(value.ticker, buf)
        _UniffiConverterOptionalString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.details, buf)
        _UniffiConverterBool.write(value.embedded_media, buf)
        _UniffiConverterOptionalTypeMedia.write(value.media, buf)
        _UniffiConverterMapUInt8TypeMedia.write(value.attachments, buf)
        _UniffiConverterBool.write(value.reserves, buf)


class Transaction:
    transaction_type: "TransactionType"
    txid: "str"
    received: "int"
    sent: "int"
    fee: "int"
    confirmation_time: "typing.Optional[BlockTime]"
    def __init__(self, *, transaction_type: "TransactionType", txid: "str", received: "int", sent: "int", fee: "int", confirmation_time: "typing.Optional[BlockTime]"):
        self.transaction_type = transaction_type
        self.txid = txid
        self.received = received
        self.sent = sent
        self.fee = fee
        self.confirmation_time = confirmation_time

    def __str__(self):
        return "Transaction(transaction_type={}, txid={}, received={}, sent={}, fee={}, confirmation_time={})".format(self.transaction_type, self.txid, self.received, self.sent, self.fee, self.confirmation_time)

    def __eq__(self, other):
        if self.transaction_type != other.transaction_type:
            return False
        if self.txid != other.txid:
            return False
        if self.received != other.received:
            return False
        if self.sent != other.sent:
            return False
        if self.fee != other.fee:
            return False
        if self.confirmation_time != other.confirmation_time:
            return False
        return True

class _UniffiConverterTypeTransaction(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Transaction(
            transaction_type=_UniffiConverterTypeTransactionType.read(buf),
            txid=_UniffiConverterString.read(buf),
            received=_UniffiConverterUInt64.read(buf),
            sent=_UniffiConverterUInt64.read(buf),
            fee=_UniffiConverterUInt64.read(buf),
            confirmation_time=_UniffiConverterOptionalTypeBlockTime.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeTransactionType.check_lower(value.transaction_type)
        _UniffiConverterString.check_lower(value.txid)
        _UniffiConverterUInt64.check_lower(value.received)
        _UniffiConverterUInt64.check_lower(value.sent)
        _UniffiConverterUInt64.check_lower(value.fee)
        _UniffiConverterOptionalTypeBlockTime.check_lower(value.confirmation_time)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeTransactionType.write(value.transaction_type, buf)
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterUInt64.write(value.received, buf)
        _UniffiConverterUInt64.write(value.sent, buf)
        _UniffiConverterUInt64.write(value.fee, buf)
        _UniffiConverterOptionalTypeBlockTime.write(value.confirmation_time, buf)


class Transfer:
    idx: "int"
    batch_transfer_idx: "int"
    created_at: "int"
    updated_at: "int"
    status: "TransferStatus"
    amount: "int"
    kind: "TransferKind"
    txid: "typing.Optional[str]"
    recipient_id: "typing.Optional[str]"
    receive_utxo: "typing.Optional[Outpoint]"
    change_utxo: "typing.Optional[Outpoint]"
    expiration: "typing.Optional[int]"
    transport_endpoints: "typing.List[TransferTransportEndpoint]"
    def __init__(self, *, idx: "int", batch_transfer_idx: "int", created_at: "int", updated_at: "int", status: "TransferStatus", amount: "int", kind: "TransferKind", txid: "typing.Optional[str]", recipient_id: "typing.Optional[str]", receive_utxo: "typing.Optional[Outpoint]", change_utxo: "typing.Optional[Outpoint]", expiration: "typing.Optional[int]", transport_endpoints: "typing.List[TransferTransportEndpoint]"):
        self.idx = idx
        self.batch_transfer_idx = batch_transfer_idx
        self.created_at = created_at
        self.updated_at = updated_at
        self.status = status
        self.amount = amount
        self.kind = kind
        self.txid = txid
        self.recipient_id = recipient_id
        self.receive_utxo = receive_utxo
        self.change_utxo = change_utxo
        self.expiration = expiration
        self.transport_endpoints = transport_endpoints

    def __str__(self):
        return "Transfer(idx={}, batch_transfer_idx={}, created_at={}, updated_at={}, status={}, amount={}, kind={}, txid={}, recipient_id={}, receive_utxo={}, change_utxo={}, expiration={}, transport_endpoints={})".format(self.idx, self.batch_transfer_idx, self.created_at, self.updated_at, self.status, self.amount, self.kind, self.txid, self.recipient_id, self.receive_utxo, self.change_utxo, self.expiration, self.transport_endpoints)

    def __eq__(self, other):
        if self.idx != other.idx:
            return False
        if self.batch_transfer_idx != other.batch_transfer_idx:
            return False
        if self.created_at != other.created_at:
            return False
        if self.updated_at != other.updated_at:
            return False
        if self.status != other.status:
            return False
        if self.amount != other.amount:
            return False
        if self.kind != other.kind:
            return False
        if self.txid != other.txid:
            return False
        if self.recipient_id != other.recipient_id:
            return False
        if self.receive_utxo != other.receive_utxo:
            return False
        if self.change_utxo != other.change_utxo:
            return False
        if self.expiration != other.expiration:
            return False
        if self.transport_endpoints != other.transport_endpoints:
            return False
        return True

class _UniffiConverterTypeTransfer(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Transfer(
            idx=_UniffiConverterInt32.read(buf),
            batch_transfer_idx=_UniffiConverterInt32.read(buf),
            created_at=_UniffiConverterInt64.read(buf),
            updated_at=_UniffiConverterInt64.read(buf),
            status=_UniffiConverterTypeTransferStatus.read(buf),
            amount=_UniffiConverterUInt64.read(buf),
            kind=_UniffiConverterTypeTransferKind.read(buf),
            txid=_UniffiConverterOptionalString.read(buf),
            recipient_id=_UniffiConverterOptionalString.read(buf),
            receive_utxo=_UniffiConverterOptionalTypeOutpoint.read(buf),
            change_utxo=_UniffiConverterOptionalTypeOutpoint.read(buf),
            expiration=_UniffiConverterOptionalInt64.read(buf),
            transport_endpoints=_UniffiConverterSequenceTypeTransferTransportEndpoint.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterInt32.check_lower(value.idx)
        _UniffiConverterInt32.check_lower(value.batch_transfer_idx)
        _UniffiConverterInt64.check_lower(value.created_at)
        _UniffiConverterInt64.check_lower(value.updated_at)
        _UniffiConverterTypeTransferStatus.check_lower(value.status)
        _UniffiConverterUInt64.check_lower(value.amount)
        _UniffiConverterTypeTransferKind.check_lower(value.kind)
        _UniffiConverterOptionalString.check_lower(value.txid)
        _UniffiConverterOptionalString.check_lower(value.recipient_id)
        _UniffiConverterOptionalTypeOutpoint.check_lower(value.receive_utxo)
        _UniffiConverterOptionalTypeOutpoint.check_lower(value.change_utxo)
        _UniffiConverterOptionalInt64.check_lower(value.expiration)
        _UniffiConverterSequenceTypeTransferTransportEndpoint.check_lower(value.transport_endpoints)

    @staticmethod
    def write(value, buf):
        _UniffiConverterInt32.write(value.idx, buf)
        _UniffiConverterInt32.write(value.batch_transfer_idx, buf)
        _UniffiConverterInt64.write(value.created_at, buf)
        _UniffiConverterInt64.write(value.updated_at, buf)
        _UniffiConverterTypeTransferStatus.write(value.status, buf)
        _UniffiConverterUInt64.write(value.amount, buf)
        _UniffiConverterTypeTransferKind.write(value.kind, buf)
        _UniffiConverterOptionalString.write(value.txid, buf)
        _UniffiConverterOptionalString.write(value.recipient_id, buf)
        _UniffiConverterOptionalTypeOutpoint.write(value.receive_utxo, buf)
        _UniffiConverterOptionalTypeOutpoint.write(value.change_utxo, buf)
        _UniffiConverterOptionalInt64.write(value.expiration, buf)
        _UniffiConverterSequenceTypeTransferTransportEndpoint.write(value.transport_endpoints, buf)


class TransferTransportEndpoint:
    endpoint: "str"
    transport_type: "TransportType"
    used: "bool"
    def __init__(self, *, endpoint: "str", transport_type: "TransportType", used: "bool"):
        self.endpoint = endpoint
        self.transport_type = transport_type
        self.used = used

    def __str__(self):
        return "TransferTransportEndpoint(endpoint={}, transport_type={}, used={})".format(self.endpoint, self.transport_type, self.used)

    def __eq__(self, other):
        if self.endpoint != other.endpoint:
            return False
        if self.transport_type != other.transport_type:
            return False
        if self.used != other.used:
            return False
        return True

class _UniffiConverterTypeTransferTransportEndpoint(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TransferTransportEndpoint(
            endpoint=_UniffiConverterString.read(buf),
            transport_type=_UniffiConverterTypeTransportType.read(buf),
            used=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.endpoint)
        _UniffiConverterTypeTransportType.check_lower(value.transport_type)
        _UniffiConverterBool.check_lower(value.used)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.endpoint, buf)
        _UniffiConverterTypeTransportType.write(value.transport_type, buf)
        _UniffiConverterBool.write(value.used, buf)


class Unspent:
    utxo: "Utxo"
    rgb_allocations: "typing.List[RgbAllocation]"
    def __init__(self, *, utxo: "Utxo", rgb_allocations: "typing.List[RgbAllocation]"):
        self.utxo = utxo
        self.rgb_allocations = rgb_allocations

    def __str__(self):
        return "Unspent(utxo={}, rgb_allocations={})".format(self.utxo, self.rgb_allocations)

    def __eq__(self, other):
        if self.utxo != other.utxo:
            return False
        if self.rgb_allocations != other.rgb_allocations:
            return False
        return True

class _UniffiConverterTypeUnspent(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Unspent(
            utxo=_UniffiConverterTypeUtxo.read(buf),
            rgb_allocations=_UniffiConverterSequenceTypeRgbAllocation.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeUtxo.check_lower(value.utxo)
        _UniffiConverterSequenceTypeRgbAllocation.check_lower(value.rgb_allocations)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeUtxo.write(value.utxo, buf)
        _UniffiConverterSequenceTypeRgbAllocation.write(value.rgb_allocations, buf)


class Utxo:
    outpoint: "Outpoint"
    btc_amount: "int"
    colorable: "bool"
    exists: "bool"
    def __init__(self, *, outpoint: "Outpoint", btc_amount: "int", colorable: "bool", exists: "bool"):
        self.outpoint = outpoint
        self.btc_amount = btc_amount
        self.colorable = colorable
        self.exists = exists

    def __str__(self):
        return "Utxo(outpoint={}, btc_amount={}, colorable={}, exists={})".format(self.outpoint, self.btc_amount, self.colorable, self.exists)

    def __eq__(self, other):
        if self.outpoint != other.outpoint:
            return False
        if self.btc_amount != other.btc_amount:
            return False
        if self.colorable != other.colorable:
            return False
        if self.exists != other.exists:
            return False
        return True

class _UniffiConverterTypeUtxo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Utxo(
            outpoint=_UniffiConverterTypeOutpoint.read(buf),
            btc_amount=_UniffiConverterUInt64.read(buf),
            colorable=_UniffiConverterBool.read(buf),
            exists=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeOutpoint.check_lower(value.outpoint)
        _UniffiConverterUInt64.check_lower(value.btc_amount)
        _UniffiConverterBool.check_lower(value.colorable)
        _UniffiConverterBool.check_lower(value.exists)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeOutpoint.write(value.outpoint, buf)
        _UniffiConverterUInt64.write(value.btc_amount, buf)
        _UniffiConverterBool.write(value.colorable, buf)
        _UniffiConverterBool.write(value.exists, buf)


class WalletData:
    data_dir: "str"
    bitcoin_network: "BitcoinNetwork"
    database_type: "DatabaseType"
    max_allocations_per_utxo: "int"
    pubkey: "str"
    mnemonic: "typing.Optional[str]"
    vanilla_keychain: "typing.Optional[int]"
    def __init__(self, *, data_dir: "str", bitcoin_network: "BitcoinNetwork", database_type: "DatabaseType", max_allocations_per_utxo: "int", pubkey: "str", mnemonic: "typing.Optional[str]", vanilla_keychain: "typing.Optional[int]"):
        self.data_dir = data_dir
        self.bitcoin_network = bitcoin_network
        self.database_type = database_type
        self.max_allocations_per_utxo = max_allocations_per_utxo
        self.pubkey = pubkey
        self.mnemonic = mnemonic
        self.vanilla_keychain = vanilla_keychain

    def __str__(self):
        return "WalletData(data_dir={}, bitcoin_network={}, database_type={}, max_allocations_per_utxo={}, pubkey={}, mnemonic={}, vanilla_keychain={})".format(self.data_dir, self.bitcoin_network, self.database_type, self.max_allocations_per_utxo, self.pubkey, self.mnemonic, self.vanilla_keychain)

    def __eq__(self, other):
        if self.data_dir != other.data_dir:
            return False
        if self.bitcoin_network != other.bitcoin_network:
            return False
        if self.database_type != other.database_type:
            return False
        if self.max_allocations_per_utxo != other.max_allocations_per_utxo:
            return False
        if self.pubkey != other.pubkey:
            return False
        if self.mnemonic != other.mnemonic:
            return False
        if self.vanilla_keychain != other.vanilla_keychain:
            return False
        return True

class _UniffiConverterTypeWalletData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return WalletData(
            data_dir=_UniffiConverterString.read(buf),
            bitcoin_network=_UniffiConverterTypeBitcoinNetwork.read(buf),
            database_type=_UniffiConverterTypeDatabaseType.read(buf),
            max_allocations_per_utxo=_UniffiConverterUInt32.read(buf),
            pubkey=_UniffiConverterString.read(buf),
            mnemonic=_UniffiConverterOptionalString.read(buf),
            vanilla_keychain=_UniffiConverterOptionalUInt8.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.data_dir)
        _UniffiConverterTypeBitcoinNetwork.check_lower(value.bitcoin_network)
        _UniffiConverterTypeDatabaseType.check_lower(value.database_type)
        _UniffiConverterUInt32.check_lower(value.max_allocations_per_utxo)
        _UniffiConverterString.check_lower(value.pubkey)
        _UniffiConverterOptionalString.check_lower(value.mnemonic)
        _UniffiConverterOptionalUInt8.check_lower(value.vanilla_keychain)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.data_dir, buf)
        _UniffiConverterTypeBitcoinNetwork.write(value.bitcoin_network, buf)
        _UniffiConverterTypeDatabaseType.write(value.database_type, buf)
        _UniffiConverterUInt32.write(value.max_allocations_per_utxo, buf)
        _UniffiConverterString.write(value.pubkey, buf)
        _UniffiConverterOptionalString.write(value.mnemonic, buf)
        _UniffiConverterOptionalUInt8.write(value.vanilla_keychain, buf)


class WitnessData:
    amount_sat: "int"
    blinding: "typing.Optional[int]"
    def __init__(self, *, amount_sat: "int", blinding: "typing.Optional[int]"):
        self.amount_sat = amount_sat
        self.blinding = blinding

    def __str__(self):
        return "WitnessData(amount_sat={}, blinding={})".format(self.amount_sat, self.blinding)

    def __eq__(self, other):
        if self.amount_sat != other.amount_sat:
            return False
        if self.blinding != other.blinding:
            return False
        return True

class _UniffiConverterTypeWitnessData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return WitnessData(
            amount_sat=_UniffiConverterUInt64.read(buf),
            blinding=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.amount_sat)
        _UniffiConverterOptionalUInt64.check_lower(value.blinding)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.amount_sat, buf)
        _UniffiConverterOptionalUInt64.write(value.blinding, buf)





class AssetIface(enum.Enum):
    RGB20 = 0
    
    RGB21 = 1
    
    RGB25 = 2
    


class _UniffiConverterTypeAssetIface(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return AssetIface.RGB20
        if variant == 2:
            return AssetIface.RGB21
        if variant == 3:
            return AssetIface.RGB25
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == AssetIface.RGB20:
            return
        if value == AssetIface.RGB21:
            return
        if value == AssetIface.RGB25:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == AssetIface.RGB20:
            buf.write_i32(1)
        if value == AssetIface.RGB21:
            buf.write_i32(2)
        if value == AssetIface.RGB25:
            buf.write_i32(3)







class AssetSchema(enum.Enum):
    NIA = 0
    
    UDA = 1
    
    CFA = 2
    


class _UniffiConverterTypeAssetSchema(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return AssetSchema.NIA
        if variant == 2:
            return AssetSchema.UDA
        if variant == 3:
            return AssetSchema.CFA
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == AssetSchema.NIA:
            return
        if value == AssetSchema.UDA:
            return
        if value == AssetSchema.CFA:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == AssetSchema.NIA:
            buf.write_i32(1)
        if value == AssetSchema.UDA:
            buf.write_i32(2)
        if value == AssetSchema.CFA:
            buf.write_i32(3)







class BitcoinNetwork(enum.Enum):
    MAINNET = 0
    
    TESTNET = 1
    
    SIGNET = 2
    
    REGTEST = 3
    


class _UniffiConverterTypeBitcoinNetwork(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return BitcoinNetwork.MAINNET
        if variant == 2:
            return BitcoinNetwork.TESTNET
        if variant == 3:
            return BitcoinNetwork.SIGNET
        if variant == 4:
            return BitcoinNetwork.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == BitcoinNetwork.MAINNET:
            return
        if value == BitcoinNetwork.TESTNET:
            return
        if value == BitcoinNetwork.SIGNET:
            return
        if value == BitcoinNetwork.REGTEST:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == BitcoinNetwork.MAINNET:
            buf.write_i32(1)
        if value == BitcoinNetwork.TESTNET:
            buf.write_i32(2)
        if value == BitcoinNetwork.SIGNET:
            buf.write_i32(3)
        if value == BitcoinNetwork.REGTEST:
            buf.write_i32(4)







class DatabaseType(enum.Enum):
    SQLITE = 0
    


class _UniffiConverterTypeDatabaseType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return DatabaseType.SQLITE
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == DatabaseType.SQLITE:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == DatabaseType.SQLITE:
            buf.write_i32(1)







class RecipientType(enum.Enum):
    BLIND = 0
    
    WITNESS = 1
    


class _UniffiConverterTypeRecipientType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return RecipientType.BLIND
        if variant == 2:
            return RecipientType.WITNESS
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == RecipientType.BLIND:
            return
        if value == RecipientType.WITNESS:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == RecipientType.BLIND:
            buf.write_i32(1)
        if value == RecipientType.WITNESS:
            buf.write_i32(2)







class RefreshTransferStatus(enum.Enum):
    WAITING_COUNTERPARTY = 0
    
    WAITING_CONFIRMATIONS = 1
    


class _UniffiConverterTypeRefreshTransferStatus(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return RefreshTransferStatus.WAITING_COUNTERPARTY
        if variant == 2:
            return RefreshTransferStatus.WAITING_CONFIRMATIONS
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == RefreshTransferStatus.WAITING_COUNTERPARTY:
            return
        if value == RefreshTransferStatus.WAITING_CONFIRMATIONS:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == RefreshTransferStatus.WAITING_COUNTERPARTY:
            buf.write_i32(1)
        if value == RefreshTransferStatus.WAITING_CONFIRMATIONS:
            buf.write_i32(2)




# RgbLibError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class RgbLibError(Exception):
    pass

_UniffiTempRgbLibError = RgbLibError

class RgbLibError:  # type: ignore
    class AllocationsAlreadyAvailable(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.AllocationsAlreadyAvailable({})".format(str(self))
    _UniffiTempRgbLibError.AllocationsAlreadyAvailable = AllocationsAlreadyAvailable # type: ignore
    class AssetIfaceMismatch(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.AssetIfaceMismatch({})".format(str(self))
    _UniffiTempRgbLibError.AssetIfaceMismatch = AssetIfaceMismatch # type: ignore
    class AssetNotFound(_UniffiTempRgbLibError):
        def __init__(self, asset_id):
            super().__init__(", ".join([
                "asset_id={!r}".format(asset_id),
            ]))
            self.asset_id = asset_id

        def __repr__(self):
            return "RgbLibError.AssetNotFound({})".format(str(self))
    _UniffiTempRgbLibError.AssetNotFound = AssetNotFound # type: ignore
    class BatchTransferNotFound(_UniffiTempRgbLibError):
        def __init__(self, idx):
            super().__init__(", ".join([
                "idx={!r}".format(idx),
            ]))
            self.idx = idx

        def __repr__(self):
            return "RgbLibError.BatchTransferNotFound({})".format(str(self))
    _UniffiTempRgbLibError.BatchTransferNotFound = BatchTransferNotFound # type: ignore
    class BitcoinNetworkMismatch(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.BitcoinNetworkMismatch({})".format(str(self))
    _UniffiTempRgbLibError.BitcoinNetworkMismatch = BitcoinNetworkMismatch # type: ignore
    class CannotChangeOnline(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.CannotChangeOnline({})".format(str(self))
    _UniffiTempRgbLibError.CannotChangeOnline = CannotChangeOnline # type: ignore
    class CannotDeleteBatchTransfer(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.CannotDeleteBatchTransfer({})".format(str(self))
    _UniffiTempRgbLibError.CannotDeleteBatchTransfer = CannotDeleteBatchTransfer # type: ignore
    class CannotEstimateFees(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.CannotEstimateFees({})".format(str(self))
    _UniffiTempRgbLibError.CannotEstimateFees = CannotEstimateFees # type: ignore
    class CannotFailBatchTransfer(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.CannotFailBatchTransfer({})".format(str(self))
    _UniffiTempRgbLibError.CannotFailBatchTransfer = CannotFailBatchTransfer # type: ignore
    class EmptyFile(_UniffiTempRgbLibError):
        def __init__(self, file_path):
            super().__init__(", ".join([
                "file_path={!r}".format(file_path),
            ]))
            self.file_path = file_path

        def __repr__(self):
            return "RgbLibError.EmptyFile({})".format(str(self))
    _UniffiTempRgbLibError.EmptyFile = EmptyFile # type: ignore
    class FailedBdkSync(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.FailedBdkSync({})".format(str(self))
    _UniffiTempRgbLibError.FailedBdkSync = FailedBdkSync # type: ignore
    class FailedBroadcast(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.FailedBroadcast({})".format(str(self))
    _UniffiTempRgbLibError.FailedBroadcast = FailedBroadcast # type: ignore
    class FailedIssuance(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.FailedIssuance({})".format(str(self))
    _UniffiTempRgbLibError.FailedIssuance = FailedIssuance # type: ignore
    class FileAlreadyExists(_UniffiTempRgbLibError):
        def __init__(self, path):
            super().__init__(", ".join([
                "path={!r}".format(path),
            ]))
            self.path = path

        def __repr__(self):
            return "RgbLibError.FileAlreadyExists({})".format(str(self))
    _UniffiTempRgbLibError.FileAlreadyExists = FileAlreadyExists # type: ignore
    class Io(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.Io({})".format(str(self))
    _UniffiTempRgbLibError.Io = Io # type: ignore
    class Inconsistency(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.Inconsistency({})".format(str(self))
    _UniffiTempRgbLibError.Inconsistency = Inconsistency # type: ignore
    class Indexer(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.Indexer({})".format(str(self))
    _UniffiTempRgbLibError.Indexer = Indexer # type: ignore
    class InexistentDataDir(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InexistentDataDir({})".format(str(self))
    _UniffiTempRgbLibError.InexistentDataDir = InexistentDataDir # type: ignore
    class InsufficientAllocationSlots(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InsufficientAllocationSlots({})".format(str(self))
    _UniffiTempRgbLibError.InsufficientAllocationSlots = InsufficientAllocationSlots # type: ignore
    class InsufficientBitcoins(_UniffiTempRgbLibError):
        def __init__(self, needed, available):
            super().__init__(", ".join([
                "needed={!r}".format(needed),
                "available={!r}".format(available),
            ]))
            self.needed = needed
            self.available = available

        def __repr__(self):
            return "RgbLibError.InsufficientBitcoins({})".format(str(self))
    _UniffiTempRgbLibError.InsufficientBitcoins = InsufficientBitcoins # type: ignore
    class InsufficientSpendableAssets(_UniffiTempRgbLibError):
        def __init__(self, asset_id):
            super().__init__(", ".join([
                "asset_id={!r}".format(asset_id),
            ]))
            self.asset_id = asset_id

        def __repr__(self):
            return "RgbLibError.InsufficientSpendableAssets({})".format(str(self))
    _UniffiTempRgbLibError.InsufficientSpendableAssets = InsufficientSpendableAssets # type: ignore
    class InsufficientTotalAssets(_UniffiTempRgbLibError):
        def __init__(self, asset_id):
            super().__init__(", ".join([
                "asset_id={!r}".format(asset_id),
            ]))
            self.asset_id = asset_id

        def __repr__(self):
            return "RgbLibError.InsufficientTotalAssets({})".format(str(self))
    _UniffiTempRgbLibError.InsufficientTotalAssets = InsufficientTotalAssets # type: ignore
    class Internal(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.Internal({})".format(str(self))
    _UniffiTempRgbLibError.Internal = Internal # type: ignore
    class InvalidAddress(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidAddress({})".format(str(self))
    _UniffiTempRgbLibError.InvalidAddress = InvalidAddress # type: ignore
    class InvalidAmountZero(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidAmountZero({})".format(str(self))
    _UniffiTempRgbLibError.InvalidAmountZero = InvalidAmountZero # type: ignore
    class InvalidAssetId(_UniffiTempRgbLibError):
        def __init__(self, asset_id):
            super().__init__(", ".join([
                "asset_id={!r}".format(asset_id),
            ]))
            self.asset_id = asset_id

        def __repr__(self):
            return "RgbLibError.InvalidAssetId({})".format(str(self))
    _UniffiTempRgbLibError.InvalidAssetId = InvalidAssetId # type: ignore
    class InvalidAttachments(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidAttachments({})".format(str(self))
    _UniffiTempRgbLibError.InvalidAttachments = InvalidAttachments # type: ignore
    class InvalidBitcoinKeys(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidBitcoinKeys({})".format(str(self))
    _UniffiTempRgbLibError.InvalidBitcoinKeys = InvalidBitcoinKeys # type: ignore
    class InvalidBitcoinNetwork(_UniffiTempRgbLibError):
        def __init__(self, network):
            super().__init__(", ".join([
                "network={!r}".format(network),
            ]))
            self.network = network

        def __repr__(self):
            return "RgbLibError.InvalidBitcoinNetwork({})".format(str(self))
    _UniffiTempRgbLibError.InvalidBitcoinNetwork = InvalidBitcoinNetwork # type: ignore
    class InvalidColoringInfo(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidColoringInfo({})".format(str(self))
    _UniffiTempRgbLibError.InvalidColoringInfo = InvalidColoringInfo # type: ignore
    class InvalidConsignment(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidConsignment({})".format(str(self))
    _UniffiTempRgbLibError.InvalidConsignment = InvalidConsignment # type: ignore
    class InvalidDetails(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidDetails({})".format(str(self))
    _UniffiTempRgbLibError.InvalidDetails = InvalidDetails # type: ignore
    class InvalidElectrum(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidElectrum({})".format(str(self))
    _UniffiTempRgbLibError.InvalidElectrum = InvalidElectrum # type: ignore
    class InvalidEstimationBlocks(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidEstimationBlocks({})".format(str(self))
    _UniffiTempRgbLibError.InvalidEstimationBlocks = InvalidEstimationBlocks # type: ignore
    class InvalidFeeRate(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidFeeRate({})".format(str(self))
    _UniffiTempRgbLibError.InvalidFeeRate = InvalidFeeRate # type: ignore
    class InvalidFilePath(_UniffiTempRgbLibError):
        def __init__(self, file_path):
            super().__init__(", ".join([
                "file_path={!r}".format(file_path),
            ]))
            self.file_path = file_path

        def __repr__(self):
            return "RgbLibError.InvalidFilePath({})".format(str(self))
    _UniffiTempRgbLibError.InvalidFilePath = InvalidFilePath # type: ignore
    class InvalidIndexer(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidIndexer({})".format(str(self))
    _UniffiTempRgbLibError.InvalidIndexer = InvalidIndexer # type: ignore
    class InvalidInvoice(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidInvoice({})".format(str(self))
    _UniffiTempRgbLibError.InvalidInvoice = InvalidInvoice # type: ignore
    class InvalidMnemonic(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidMnemonic({})".format(str(self))
    _UniffiTempRgbLibError.InvalidMnemonic = InvalidMnemonic # type: ignore
    class InvalidName(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidName({})".format(str(self))
    _UniffiTempRgbLibError.InvalidName = InvalidName # type: ignore
    class InvalidPrecision(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidPrecision({})".format(str(self))
    _UniffiTempRgbLibError.InvalidPrecision = InvalidPrecision # type: ignore
    class InvalidProxyProtocol(_UniffiTempRgbLibError):
        def __init__(self, version):
            super().__init__(", ".join([
                "version={!r}".format(version),
            ]))
            self.version = version

        def __repr__(self):
            return "RgbLibError.InvalidProxyProtocol({})".format(str(self))
    _UniffiTempRgbLibError.InvalidProxyProtocol = InvalidProxyProtocol # type: ignore
    class InvalidPsbt(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidPsbt({})".format(str(self))
    _UniffiTempRgbLibError.InvalidPsbt = InvalidPsbt # type: ignore
    class InvalidPubkey(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidPubkey({})".format(str(self))
    _UniffiTempRgbLibError.InvalidPubkey = InvalidPubkey # type: ignore
    class InvalidRecipientData(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidRecipientData({})".format(str(self))
    _UniffiTempRgbLibError.InvalidRecipientData = InvalidRecipientData # type: ignore
    class InvalidRecipientId(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidRecipientId({})".format(str(self))
    _UniffiTempRgbLibError.InvalidRecipientId = InvalidRecipientId # type: ignore
    class InvalidRecipientNetwork(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidRecipientNetwork({})".format(str(self))
    _UniffiTempRgbLibError.InvalidRecipientNetwork = InvalidRecipientNetwork # type: ignore
    class InvalidTicker(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidTicker({})".format(str(self))
    _UniffiTempRgbLibError.InvalidTicker = InvalidTicker # type: ignore
    class InvalidTransportEndpoint(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidTransportEndpoint({})".format(str(self))
    _UniffiTempRgbLibError.InvalidTransportEndpoint = InvalidTransportEndpoint # type: ignore
    class InvalidTransportEndpoints(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.InvalidTransportEndpoints({})".format(str(self))
    _UniffiTempRgbLibError.InvalidTransportEndpoints = InvalidTransportEndpoints # type: ignore
    class InvalidTxid(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidTxid({})".format(str(self))
    _UniffiTempRgbLibError.InvalidTxid = InvalidTxid # type: ignore
    class InvalidVanillaKeychain(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.InvalidVanillaKeychain({})".format(str(self))
    _UniffiTempRgbLibError.InvalidVanillaKeychain = InvalidVanillaKeychain # type: ignore
    class MaxFeeExceeded(_UniffiTempRgbLibError):
        def __init__(self, txid):
            super().__init__(", ".join([
                "txid={!r}".format(txid),
            ]))
            self.txid = txid

        def __repr__(self):
            return "RgbLibError.MaxFeeExceeded({})".format(str(self))
    _UniffiTempRgbLibError.MaxFeeExceeded = MaxFeeExceeded # type: ignore
    class MinFeeNotMet(_UniffiTempRgbLibError):
        def __init__(self, txid):
            super().__init__(", ".join([
                "txid={!r}".format(txid),
            ]))
            self.txid = txid

        def __repr__(self):
            return "RgbLibError.MinFeeNotMet({})".format(str(self))
    _UniffiTempRgbLibError.MinFeeNotMet = MinFeeNotMet # type: ignore
    class Network(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.Network({})".format(str(self))
    _UniffiTempRgbLibError.Network = Network # type: ignore
    class NoConsignment(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.NoConsignment({})".format(str(self))
    _UniffiTempRgbLibError.NoConsignment = NoConsignment # type: ignore
    class NoIssuanceAmounts(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.NoIssuanceAmounts({})".format(str(self))
    _UniffiTempRgbLibError.NoIssuanceAmounts = NoIssuanceAmounts # type: ignore
    class NoValidTransportEndpoint(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.NoValidTransportEndpoint({})".format(str(self))
    _UniffiTempRgbLibError.NoValidTransportEndpoint = NoValidTransportEndpoint # type: ignore
    class Offline(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.Offline({})".format(str(self))
    _UniffiTempRgbLibError.Offline = Offline # type: ignore
    class OnlineNeeded(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.OnlineNeeded({})".format(str(self))
    _UniffiTempRgbLibError.OnlineNeeded = OnlineNeeded # type: ignore
    class OutputBelowDustLimit(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.OutputBelowDustLimit({})".format(str(self))
    _UniffiTempRgbLibError.OutputBelowDustLimit = OutputBelowDustLimit # type: ignore
    class Proxy(_UniffiTempRgbLibError):
        def __init__(self, details):
            super().__init__(", ".join([
                "details={!r}".format(details),
            ]))
            self.details = details

        def __repr__(self):
            return "RgbLibError.Proxy({})".format(str(self))
    _UniffiTempRgbLibError.Proxy = Proxy # type: ignore
    class RecipientIdAlreadyUsed(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.RecipientIdAlreadyUsed({})".format(str(self))
    _UniffiTempRgbLibError.RecipientIdAlreadyUsed = RecipientIdAlreadyUsed # type: ignore
    class RecipientIdDuplicated(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.RecipientIdDuplicated({})".format(str(self))
    _UniffiTempRgbLibError.RecipientIdDuplicated = RecipientIdDuplicated # type: ignore
    class SyncNeeded(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.SyncNeeded({})".format(str(self))
    _UniffiTempRgbLibError.SyncNeeded = SyncNeeded # type: ignore
    class TooHighIssuanceAmounts(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.TooHighIssuanceAmounts({})".format(str(self))
    _UniffiTempRgbLibError.TooHighIssuanceAmounts = TooHighIssuanceAmounts # type: ignore
    class UnknownRgbInterface(_UniffiTempRgbLibError):
        def __init__(self, interface):
            super().__init__(", ".join([
                "interface={!r}".format(interface),
            ]))
            self.interface = interface

        def __repr__(self):
            return "RgbLibError.UnknownRgbInterface({})".format(str(self))
    _UniffiTempRgbLibError.UnknownRgbInterface = UnknownRgbInterface # type: ignore
    class UnknownRgbSchema(_UniffiTempRgbLibError):
        def __init__(self, schema_id):
            super().__init__(", ".join([
                "schema_id={!r}".format(schema_id),
            ]))
            self.schema_id = schema_id

        def __repr__(self):
            return "RgbLibError.UnknownRgbSchema({})".format(str(self))
    _UniffiTempRgbLibError.UnknownRgbSchema = UnknownRgbSchema # type: ignore
    class UnsupportedBackupVersion(_UniffiTempRgbLibError):
        def __init__(self, version):
            super().__init__(", ".join([
                "version={!r}".format(version),
            ]))
            self.version = version

        def __repr__(self):
            return "RgbLibError.UnsupportedBackupVersion({})".format(str(self))
    _UniffiTempRgbLibError.UnsupportedBackupVersion = UnsupportedBackupVersion # type: ignore
    class UnsupportedLayer1(_UniffiTempRgbLibError):
        def __init__(self, layer_1):
            super().__init__(", ".join([
                "layer_1={!r}".format(layer_1),
            ]))
            self.layer_1 = layer_1

        def __repr__(self):
            return "RgbLibError.UnsupportedLayer1({})".format(str(self))
    _UniffiTempRgbLibError.UnsupportedLayer1 = UnsupportedLayer1 # type: ignore
    class UnsupportedTransportType(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.UnsupportedTransportType({})".format(str(self))
    _UniffiTempRgbLibError.UnsupportedTransportType = UnsupportedTransportType # type: ignore
    class WalletDirAlreadyExists(_UniffiTempRgbLibError):
        def __init__(self, path):
            super().__init__(", ".join([
                "path={!r}".format(path),
            ]))
            self.path = path

        def __repr__(self):
            return "RgbLibError.WalletDirAlreadyExists({})".format(str(self))
    _UniffiTempRgbLibError.WalletDirAlreadyExists = WalletDirAlreadyExists # type: ignore
    class WatchOnly(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.WatchOnly({})".format(str(self))
    _UniffiTempRgbLibError.WatchOnly = WatchOnly # type: ignore
    class WrongPassword(_UniffiTempRgbLibError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RgbLibError.WrongPassword({})".format(str(self))
    _UniffiTempRgbLibError.WrongPassword = WrongPassword # type: ignore

RgbLibError = _UniffiTempRgbLibError # type: ignore
del _UniffiTempRgbLibError


class _UniffiConverterTypeRgbLibError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return RgbLibError.AllocationsAlreadyAvailable(
            )
        if variant == 2:
            return RgbLibError.AssetIfaceMismatch(
            )
        if variant == 3:
            return RgbLibError.AssetNotFound(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return RgbLibError.BatchTransferNotFound(
                _UniffiConverterInt32.read(buf),
            )
        if variant == 5:
            return RgbLibError.BitcoinNetworkMismatch(
            )
        if variant == 6:
            return RgbLibError.CannotChangeOnline(
            )
        if variant == 7:
            return RgbLibError.CannotDeleteBatchTransfer(
            )
        if variant == 8:
            return RgbLibError.CannotEstimateFees(
            )
        if variant == 9:
            return RgbLibError.CannotFailBatchTransfer(
            )
        if variant == 10:
            return RgbLibError.EmptyFile(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return RgbLibError.FailedBdkSync(
                _UniffiConverterString.read(buf),
            )
        if variant == 12:
            return RgbLibError.FailedBroadcast(
                _UniffiConverterString.read(buf),
            )
        if variant == 13:
            return RgbLibError.FailedIssuance(
                _UniffiConverterString.read(buf),
            )
        if variant == 14:
            return RgbLibError.FileAlreadyExists(
                _UniffiConverterString.read(buf),
            )
        if variant == 15:
            return RgbLibError.Io(
                _UniffiConverterString.read(buf),
            )
        if variant == 16:
            return RgbLibError.Inconsistency(
                _UniffiConverterString.read(buf),
            )
        if variant == 17:
            return RgbLibError.Indexer(
                _UniffiConverterString.read(buf),
            )
        if variant == 18:
            return RgbLibError.InexistentDataDir(
            )
        if variant == 19:
            return RgbLibError.InsufficientAllocationSlots(
            )
        if variant == 20:
            return RgbLibError.InsufficientBitcoins(
                _UniffiConverterUInt64.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 21:
            return RgbLibError.InsufficientSpendableAssets(
                _UniffiConverterString.read(buf),
            )
        if variant == 22:
            return RgbLibError.InsufficientTotalAssets(
                _UniffiConverterString.read(buf),
            )
        if variant == 23:
            return RgbLibError.Internal(
                _UniffiConverterString.read(buf),
            )
        if variant == 24:
            return RgbLibError.InvalidAddress(
                _UniffiConverterString.read(buf),
            )
        if variant == 25:
            return RgbLibError.InvalidAmountZero(
            )
        if variant == 26:
            return RgbLibError.InvalidAssetId(
                _UniffiConverterString.read(buf),
            )
        if variant == 27:
            return RgbLibError.InvalidAttachments(
                _UniffiConverterString.read(buf),
            )
        if variant == 28:
            return RgbLibError.InvalidBitcoinKeys(
            )
        if variant == 29:
            return RgbLibError.InvalidBitcoinNetwork(
                _UniffiConverterString.read(buf),
            )
        if variant == 30:
            return RgbLibError.InvalidColoringInfo(
                _UniffiConverterString.read(buf),
            )
        if variant == 31:
            return RgbLibError.InvalidConsignment(
            )
        if variant == 32:
            return RgbLibError.InvalidDetails(
                _UniffiConverterString.read(buf),
            )
        if variant == 33:
            return RgbLibError.InvalidElectrum(
                _UniffiConverterString.read(buf),
            )
        if variant == 34:
            return RgbLibError.InvalidEstimationBlocks(
            )
        if variant == 35:
            return RgbLibError.InvalidFeeRate(
                _UniffiConverterString.read(buf),
            )
        if variant == 36:
            return RgbLibError.InvalidFilePath(
                _UniffiConverterString.read(buf),
            )
        if variant == 37:
            return RgbLibError.InvalidIndexer(
                _UniffiConverterString.read(buf),
            )
        if variant == 38:
            return RgbLibError.InvalidInvoice(
                _UniffiConverterString.read(buf),
            )
        if variant == 39:
            return RgbLibError.InvalidMnemonic(
                _UniffiConverterString.read(buf),
            )
        if variant == 40:
            return RgbLibError.InvalidName(
                _UniffiConverterString.read(buf),
            )
        if variant == 41:
            return RgbLibError.InvalidPrecision(
                _UniffiConverterString.read(buf),
            )
        if variant == 42:
            return RgbLibError.InvalidProxyProtocol(
                _UniffiConverterString.read(buf),
            )
        if variant == 43:
            return RgbLibError.InvalidPsbt(
                _UniffiConverterString.read(buf),
            )
        if variant == 44:
            return RgbLibError.InvalidPubkey(
                _UniffiConverterString.read(buf),
            )
        if variant == 45:
            return RgbLibError.InvalidRecipientData(
                _UniffiConverterString.read(buf),
            )
        if variant == 46:
            return RgbLibError.InvalidRecipientId(
            )
        if variant == 47:
            return RgbLibError.InvalidRecipientNetwork(
            )
        if variant == 48:
            return RgbLibError.InvalidTicker(
                _UniffiConverterString.read(buf),
            )
        if variant == 49:
            return RgbLibError.InvalidTransportEndpoint(
                _UniffiConverterString.read(buf),
            )
        if variant == 50:
            return RgbLibError.InvalidTransportEndpoints(
                _UniffiConverterString.read(buf),
            )
        if variant == 51:
            return RgbLibError.InvalidTxid(
            )
        if variant == 52:
            return RgbLibError.InvalidVanillaKeychain(
            )
        if variant == 53:
            return RgbLibError.MaxFeeExceeded(
                _UniffiConverterString.read(buf),
            )
        if variant == 54:
            return RgbLibError.MinFeeNotMet(
                _UniffiConverterString.read(buf),
            )
        if variant == 55:
            return RgbLibError.Network(
                _UniffiConverterString.read(buf),
            )
        if variant == 56:
            return RgbLibError.NoConsignment(
            )
        if variant == 57:
            return RgbLibError.NoIssuanceAmounts(
            )
        if variant == 58:
            return RgbLibError.NoValidTransportEndpoint(
            )
        if variant == 59:
            return RgbLibError.Offline(
            )
        if variant == 60:
            return RgbLibError.OnlineNeeded(
            )
        if variant == 61:
            return RgbLibError.OutputBelowDustLimit(
            )
        if variant == 62:
            return RgbLibError.Proxy(
                _UniffiConverterString.read(buf),
            )
        if variant == 63:
            return RgbLibError.RecipientIdAlreadyUsed(
            )
        if variant == 64:
            return RgbLibError.RecipientIdDuplicated(
            )
        if variant == 65:
            return RgbLibError.SyncNeeded(
            )
        if variant == 66:
            return RgbLibError.TooHighIssuanceAmounts(
            )
        if variant == 67:
            return RgbLibError.UnknownRgbInterface(
                _UniffiConverterString.read(buf),
            )
        if variant == 68:
            return RgbLibError.UnknownRgbSchema(
                _UniffiConverterString.read(buf),
            )
        if variant == 69:
            return RgbLibError.UnsupportedBackupVersion(
                _UniffiConverterString.read(buf),
            )
        if variant == 70:
            return RgbLibError.UnsupportedLayer1(
                _UniffiConverterString.read(buf),
            )
        if variant == 71:
            return RgbLibError.UnsupportedTransportType(
            )
        if variant == 72:
            return RgbLibError.WalletDirAlreadyExists(
                _UniffiConverterString.read(buf),
            )
        if variant == 73:
            return RgbLibError.WatchOnly(
            )
        if variant == 74:
            return RgbLibError.WrongPassword(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, RgbLibError.AllocationsAlreadyAvailable):
            return
        if isinstance(value, RgbLibError.AssetIfaceMismatch):
            return
        if isinstance(value, RgbLibError.AssetNotFound):
            _UniffiConverterString.check_lower(value.asset_id)
            return
        if isinstance(value, RgbLibError.BatchTransferNotFound):
            _UniffiConverterInt32.check_lower(value.idx)
            return
        if isinstance(value, RgbLibError.BitcoinNetworkMismatch):
            return
        if isinstance(value, RgbLibError.CannotChangeOnline):
            return
        if isinstance(value, RgbLibError.CannotDeleteBatchTransfer):
            return
        if isinstance(value, RgbLibError.CannotEstimateFees):
            return
        if isinstance(value, RgbLibError.CannotFailBatchTransfer):
            return
        if isinstance(value, RgbLibError.EmptyFile):
            _UniffiConverterString.check_lower(value.file_path)
            return
        if isinstance(value, RgbLibError.FailedBdkSync):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.FailedBroadcast):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.FailedIssuance):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.FileAlreadyExists):
            _UniffiConverterString.check_lower(value.path)
            return
        if isinstance(value, RgbLibError.Io):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.Inconsistency):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.Indexer):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InexistentDataDir):
            return
        if isinstance(value, RgbLibError.InsufficientAllocationSlots):
            return
        if isinstance(value, RgbLibError.InsufficientBitcoins):
            _UniffiConverterUInt64.check_lower(value.needed)
            _UniffiConverterUInt64.check_lower(value.available)
            return
        if isinstance(value, RgbLibError.InsufficientSpendableAssets):
            _UniffiConverterString.check_lower(value.asset_id)
            return
        if isinstance(value, RgbLibError.InsufficientTotalAssets):
            _UniffiConverterString.check_lower(value.asset_id)
            return
        if isinstance(value, RgbLibError.Internal):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidAddress):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidAmountZero):
            return
        if isinstance(value, RgbLibError.InvalidAssetId):
            _UniffiConverterString.check_lower(value.asset_id)
            return
        if isinstance(value, RgbLibError.InvalidAttachments):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidBitcoinKeys):
            return
        if isinstance(value, RgbLibError.InvalidBitcoinNetwork):
            _UniffiConverterString.check_lower(value.network)
            return
        if isinstance(value, RgbLibError.InvalidColoringInfo):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidConsignment):
            return
        if isinstance(value, RgbLibError.InvalidDetails):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidElectrum):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidEstimationBlocks):
            return
        if isinstance(value, RgbLibError.InvalidFeeRate):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidFilePath):
            _UniffiConverterString.check_lower(value.file_path)
            return
        if isinstance(value, RgbLibError.InvalidIndexer):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidInvoice):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidMnemonic):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidName):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidPrecision):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidProxyProtocol):
            _UniffiConverterString.check_lower(value.version)
            return
        if isinstance(value, RgbLibError.InvalidPsbt):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidPubkey):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidRecipientData):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidRecipientId):
            return
        if isinstance(value, RgbLibError.InvalidRecipientNetwork):
            return
        if isinstance(value, RgbLibError.InvalidTicker):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidTransportEndpoint):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidTransportEndpoints):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.InvalidTxid):
            return
        if isinstance(value, RgbLibError.InvalidVanillaKeychain):
            return
        if isinstance(value, RgbLibError.MaxFeeExceeded):
            _UniffiConverterString.check_lower(value.txid)
            return
        if isinstance(value, RgbLibError.MinFeeNotMet):
            _UniffiConverterString.check_lower(value.txid)
            return
        if isinstance(value, RgbLibError.Network):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.NoConsignment):
            return
        if isinstance(value, RgbLibError.NoIssuanceAmounts):
            return
        if isinstance(value, RgbLibError.NoValidTransportEndpoint):
            return
        if isinstance(value, RgbLibError.Offline):
            return
        if isinstance(value, RgbLibError.OnlineNeeded):
            return
        if isinstance(value, RgbLibError.OutputBelowDustLimit):
            return
        if isinstance(value, RgbLibError.Proxy):
            _UniffiConverterString.check_lower(value.details)
            return
        if isinstance(value, RgbLibError.RecipientIdAlreadyUsed):
            return
        if isinstance(value, RgbLibError.RecipientIdDuplicated):
            return
        if isinstance(value, RgbLibError.SyncNeeded):
            return
        if isinstance(value, RgbLibError.TooHighIssuanceAmounts):
            return
        if isinstance(value, RgbLibError.UnknownRgbInterface):
            _UniffiConverterString.check_lower(value.interface)
            return
        if isinstance(value, RgbLibError.UnknownRgbSchema):
            _UniffiConverterString.check_lower(value.schema_id)
            return
        if isinstance(value, RgbLibError.UnsupportedBackupVersion):
            _UniffiConverterString.check_lower(value.version)
            return
        if isinstance(value, RgbLibError.UnsupportedLayer1):
            _UniffiConverterString.check_lower(value.layer_1)
            return
        if isinstance(value, RgbLibError.UnsupportedTransportType):
            return
        if isinstance(value, RgbLibError.WalletDirAlreadyExists):
            _UniffiConverterString.check_lower(value.path)
            return
        if isinstance(value, RgbLibError.WatchOnly):
            return
        if isinstance(value, RgbLibError.WrongPassword):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, RgbLibError.AllocationsAlreadyAvailable):
            buf.write_i32(1)
        if isinstance(value, RgbLibError.AssetIfaceMismatch):
            buf.write_i32(2)
        if isinstance(value, RgbLibError.AssetNotFound):
            buf.write_i32(3)
            _UniffiConverterString.write(value.asset_id, buf)
        if isinstance(value, RgbLibError.BatchTransferNotFound):
            buf.write_i32(4)
            _UniffiConverterInt32.write(value.idx, buf)
        if isinstance(value, RgbLibError.BitcoinNetworkMismatch):
            buf.write_i32(5)
        if isinstance(value, RgbLibError.CannotChangeOnline):
            buf.write_i32(6)
        if isinstance(value, RgbLibError.CannotDeleteBatchTransfer):
            buf.write_i32(7)
        if isinstance(value, RgbLibError.CannotEstimateFees):
            buf.write_i32(8)
        if isinstance(value, RgbLibError.CannotFailBatchTransfer):
            buf.write_i32(9)
        if isinstance(value, RgbLibError.EmptyFile):
            buf.write_i32(10)
            _UniffiConverterString.write(value.file_path, buf)
        if isinstance(value, RgbLibError.FailedBdkSync):
            buf.write_i32(11)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.FailedBroadcast):
            buf.write_i32(12)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.FailedIssuance):
            buf.write_i32(13)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.FileAlreadyExists):
            buf.write_i32(14)
            _UniffiConverterString.write(value.path, buf)
        if isinstance(value, RgbLibError.Io):
            buf.write_i32(15)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.Inconsistency):
            buf.write_i32(16)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.Indexer):
            buf.write_i32(17)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InexistentDataDir):
            buf.write_i32(18)
        if isinstance(value, RgbLibError.InsufficientAllocationSlots):
            buf.write_i32(19)
        if isinstance(value, RgbLibError.InsufficientBitcoins):
            buf.write_i32(20)
            _UniffiConverterUInt64.write(value.needed, buf)
            _UniffiConverterUInt64.write(value.available, buf)
        if isinstance(value, RgbLibError.InsufficientSpendableAssets):
            buf.write_i32(21)
            _UniffiConverterString.write(value.asset_id, buf)
        if isinstance(value, RgbLibError.InsufficientTotalAssets):
            buf.write_i32(22)
            _UniffiConverterString.write(value.asset_id, buf)
        if isinstance(value, RgbLibError.Internal):
            buf.write_i32(23)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidAddress):
            buf.write_i32(24)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidAmountZero):
            buf.write_i32(25)
        if isinstance(value, RgbLibError.InvalidAssetId):
            buf.write_i32(26)
            _UniffiConverterString.write(value.asset_id, buf)
        if isinstance(value, RgbLibError.InvalidAttachments):
            buf.write_i32(27)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidBitcoinKeys):
            buf.write_i32(28)
        if isinstance(value, RgbLibError.InvalidBitcoinNetwork):
            buf.write_i32(29)
            _UniffiConverterString.write(value.network, buf)
        if isinstance(value, RgbLibError.InvalidColoringInfo):
            buf.write_i32(30)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidConsignment):
            buf.write_i32(31)
        if isinstance(value, RgbLibError.InvalidDetails):
            buf.write_i32(32)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidElectrum):
            buf.write_i32(33)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidEstimationBlocks):
            buf.write_i32(34)
        if isinstance(value, RgbLibError.InvalidFeeRate):
            buf.write_i32(35)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidFilePath):
            buf.write_i32(36)
            _UniffiConverterString.write(value.file_path, buf)
        if isinstance(value, RgbLibError.InvalidIndexer):
            buf.write_i32(37)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidInvoice):
            buf.write_i32(38)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidMnemonic):
            buf.write_i32(39)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidName):
            buf.write_i32(40)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidPrecision):
            buf.write_i32(41)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidProxyProtocol):
            buf.write_i32(42)
            _UniffiConverterString.write(value.version, buf)
        if isinstance(value, RgbLibError.InvalidPsbt):
            buf.write_i32(43)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidPubkey):
            buf.write_i32(44)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidRecipientData):
            buf.write_i32(45)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidRecipientId):
            buf.write_i32(46)
        if isinstance(value, RgbLibError.InvalidRecipientNetwork):
            buf.write_i32(47)
        if isinstance(value, RgbLibError.InvalidTicker):
            buf.write_i32(48)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidTransportEndpoint):
            buf.write_i32(49)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidTransportEndpoints):
            buf.write_i32(50)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.InvalidTxid):
            buf.write_i32(51)
        if isinstance(value, RgbLibError.InvalidVanillaKeychain):
            buf.write_i32(52)
        if isinstance(value, RgbLibError.MaxFeeExceeded):
            buf.write_i32(53)
            _UniffiConverterString.write(value.txid, buf)
        if isinstance(value, RgbLibError.MinFeeNotMet):
            buf.write_i32(54)
            _UniffiConverterString.write(value.txid, buf)
        if isinstance(value, RgbLibError.Network):
            buf.write_i32(55)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.NoConsignment):
            buf.write_i32(56)
        if isinstance(value, RgbLibError.NoIssuanceAmounts):
            buf.write_i32(57)
        if isinstance(value, RgbLibError.NoValidTransportEndpoint):
            buf.write_i32(58)
        if isinstance(value, RgbLibError.Offline):
            buf.write_i32(59)
        if isinstance(value, RgbLibError.OnlineNeeded):
            buf.write_i32(60)
        if isinstance(value, RgbLibError.OutputBelowDustLimit):
            buf.write_i32(61)
        if isinstance(value, RgbLibError.Proxy):
            buf.write_i32(62)
            _UniffiConverterString.write(value.details, buf)
        if isinstance(value, RgbLibError.RecipientIdAlreadyUsed):
            buf.write_i32(63)
        if isinstance(value, RgbLibError.RecipientIdDuplicated):
            buf.write_i32(64)
        if isinstance(value, RgbLibError.SyncNeeded):
            buf.write_i32(65)
        if isinstance(value, RgbLibError.TooHighIssuanceAmounts):
            buf.write_i32(66)
        if isinstance(value, RgbLibError.UnknownRgbInterface):
            buf.write_i32(67)
            _UniffiConverterString.write(value.interface, buf)
        if isinstance(value, RgbLibError.UnknownRgbSchema):
            buf.write_i32(68)
            _UniffiConverterString.write(value.schema_id, buf)
        if isinstance(value, RgbLibError.UnsupportedBackupVersion):
            buf.write_i32(69)
            _UniffiConverterString.write(value.version, buf)
        if isinstance(value, RgbLibError.UnsupportedLayer1):
            buf.write_i32(70)
            _UniffiConverterString.write(value.layer_1, buf)
        if isinstance(value, RgbLibError.UnsupportedTransportType):
            buf.write_i32(71)
        if isinstance(value, RgbLibError.WalletDirAlreadyExists):
            buf.write_i32(72)
            _UniffiConverterString.write(value.path, buf)
        if isinstance(value, RgbLibError.WatchOnly):
            buf.write_i32(73)
        if isinstance(value, RgbLibError.WrongPassword):
            buf.write_i32(74)





class TransactionType(enum.Enum):
    RGB_SEND = 0
    
    DRAIN = 1
    
    CREATE_UTXOS = 2
    
    USER = 3
    


class _UniffiConverterTypeTransactionType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return TransactionType.RGB_SEND
        if variant == 2:
            return TransactionType.DRAIN
        if variant == 3:
            return TransactionType.CREATE_UTXOS
        if variant == 4:
            return TransactionType.USER
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == TransactionType.RGB_SEND:
            return
        if value == TransactionType.DRAIN:
            return
        if value == TransactionType.CREATE_UTXOS:
            return
        if value == TransactionType.USER:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == TransactionType.RGB_SEND:
            buf.write_i32(1)
        if value == TransactionType.DRAIN:
            buf.write_i32(2)
        if value == TransactionType.CREATE_UTXOS:
            buf.write_i32(3)
        if value == TransactionType.USER:
            buf.write_i32(4)







class TransferKind(enum.Enum):
    ISSUANCE = 0
    
    RECEIVE_BLIND = 1
    
    RECEIVE_WITNESS = 2
    
    SEND = 3
    


class _UniffiConverterTypeTransferKind(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return TransferKind.ISSUANCE
        if variant == 2:
            return TransferKind.RECEIVE_BLIND
        if variant == 3:
            return TransferKind.RECEIVE_WITNESS
        if variant == 4:
            return TransferKind.SEND
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == TransferKind.ISSUANCE:
            return
        if value == TransferKind.RECEIVE_BLIND:
            return
        if value == TransferKind.RECEIVE_WITNESS:
            return
        if value == TransferKind.SEND:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == TransferKind.ISSUANCE:
            buf.write_i32(1)
        if value == TransferKind.RECEIVE_BLIND:
            buf.write_i32(2)
        if value == TransferKind.RECEIVE_WITNESS:
            buf.write_i32(3)
        if value == TransferKind.SEND:
            buf.write_i32(4)







class TransferStatus(enum.Enum):
    WAITING_COUNTERPARTY = 0
    
    WAITING_CONFIRMATIONS = 1
    
    SETTLED = 2
    
    FAILED = 3
    


class _UniffiConverterTypeTransferStatus(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return TransferStatus.WAITING_COUNTERPARTY
        if variant == 2:
            return TransferStatus.WAITING_CONFIRMATIONS
        if variant == 3:
            return TransferStatus.SETTLED
        if variant == 4:
            return TransferStatus.FAILED
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == TransferStatus.WAITING_COUNTERPARTY:
            return
        if value == TransferStatus.WAITING_CONFIRMATIONS:
            return
        if value == TransferStatus.SETTLED:
            return
        if value == TransferStatus.FAILED:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == TransferStatus.WAITING_COUNTERPARTY:
            buf.write_i32(1)
        if value == TransferStatus.WAITING_CONFIRMATIONS:
            buf.write_i32(2)
        if value == TransferStatus.SETTLED:
            buf.write_i32(3)
        if value == TransferStatus.FAILED:
            buf.write_i32(4)







class TransportType(enum.Enum):
    JSON_RPC = 0
    


class _UniffiConverterTypeTransportType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return TransportType.JSON_RPC
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == TransportType.JSON_RPC:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == TransportType.JSON_RPC:
            buf.write_i32(1)





class _UniffiConverterOptionalUInt8(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt8.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt8.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt8.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeBlockTime(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeBlockTime.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeBlockTime.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeBlockTime.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeEmbeddedMedia(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeEmbeddedMedia.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeEmbeddedMedia.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeEmbeddedMedia.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeMedia(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeMedia.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeMedia.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeMedia.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeOnline(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeOnline.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeOnline.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeOnline.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeOutpoint(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeOutpoint.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeOutpoint.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeOutpoint.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeProofOfReserves(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeProofOfReserves.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeProofOfReserves.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeProofOfReserves.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeToken(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeToken.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeToken.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeToken.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTokenLight(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTokenLight.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTokenLight.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTokenLight.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeWitnessData(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeWitnessData.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeWitnessData.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeWitnessData.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAssetIface(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAssetIface.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAssetIface.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAssetIface.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeRgbLibError(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeRgbLibError.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeRgbLibError.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeRgbLibError.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTransferStatus(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTransferStatus.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTransferStatus.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTransferStatus.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypeAssetCfa(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypeAssetCfa.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypeAssetCfa.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypeAssetCfa.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypeAssetNia(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypeAssetNia.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypeAssetNia.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypeAssetNia.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypeAssetUda(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypeAssetUda.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypeAssetUda.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypeAssetUda.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceUInt8(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterUInt8.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterUInt8.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterUInt8.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterUInt64.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterUInt64.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterUInt64.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterString.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterString.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterString.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAssetCfa(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAssetCfa.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAssetCfa.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAssetCfa.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAssetNia(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAssetNia.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAssetNia.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAssetNia.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAssetUda(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAssetUda.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAssetUda.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAssetUda.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRecipient(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRecipient.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRecipient.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRecipient.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRefreshFilter(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRefreshFilter.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRefreshFilter.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRefreshFilter.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRgbAllocation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRgbAllocation.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRgbAllocation.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRgbAllocation.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTransaction(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTransaction.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTransaction.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTransaction.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTransfer(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTransfer.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTransfer.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTransfer.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTransferTransportEndpoint(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTransferTransportEndpoint.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTransferTransportEndpoint.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTransferTransportEndpoint.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeUnspent(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeUnspent.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeUnspent.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeUnspent.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAssetSchema(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAssetSchema.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAssetSchema.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAssetSchema.read(buf) for i in range(count)
        ]



class _UniffiConverterMapUInt8TypeMedia(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterUInt8.check_lower(key)
            _UniffiConverterTypeMedia.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterUInt8.write(key, buf)
            _UniffiConverterTypeMedia.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterUInt8.read(buf)
            val = _UniffiConverterTypeMedia.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapInt32TypeRefreshedTransfer(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterInt32.check_lower(key)
            _UniffiConverterTypeRefreshedTransfer.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterInt32.write(key, buf)
            _UniffiConverterTypeRefreshedTransfer.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterInt32.read(buf)
            val = _UniffiConverterTypeRefreshedTransfer.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapStringSequenceTypeRecipient(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterString.check_lower(key)
            _UniffiConverterSequenceTypeRecipient.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterString.write(key, buf)
            _UniffiConverterSequenceTypeRecipient.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterString.read(buf)
            val = _UniffiConverterSequenceTypeRecipient.read(buf)
            d[key] = val
        return d

# Async support

def generate_keys(bitcoin_network: "BitcoinNetwork") -> "Keys":
    _UniffiConverterTypeBitcoinNetwork.check_lower(bitcoin_network)
    
    return _UniffiConverterTypeKeys.lift(_uniffi_rust_call(_UniffiLib.uniffi_rgblibuniffi_fn_func_generate_keys,
        _UniffiConverterTypeBitcoinNetwork.lower(bitcoin_network)))


def restore_backup(backup_path: "str",password: "str",data_dir: "str") -> None:
    _UniffiConverterString.check_lower(backup_path)
    
    _UniffiConverterString.check_lower(password)
    
    _UniffiConverterString.check_lower(data_dir)
    
    _uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_func_restore_backup,
        _UniffiConverterString.lower(backup_path),
        _UniffiConverterString.lower(password),
        _UniffiConverterString.lower(data_dir))


def restore_keys(bitcoin_network: "BitcoinNetwork",mnemonic: "str") -> "Keys":
    _UniffiConverterTypeBitcoinNetwork.check_lower(bitcoin_network)
    
    _UniffiConverterString.check_lower(mnemonic)
    
    return _UniffiConverterTypeKeys.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeRgbLibError,_UniffiLib.uniffi_rgblibuniffi_fn_func_restore_keys,
        _UniffiConverterTypeBitcoinNetwork.lower(bitcoin_network),
        _UniffiConverterString.lower(mnemonic)))


__all__ = [
    "InternalError",
    "AssetIface",
    "AssetSchema",
    "BitcoinNetwork",
    "DatabaseType",
    "RecipientType",
    "RefreshTransferStatus",
    "RgbLibError",
    "TransactionType",
    "TransferKind",
    "TransferStatus",
    "TransportType",
    "AssetCfa",
    "AssetNia",
    "AssetUda",
    "Assets",
    "Balance",
    "BlockTime",
    "BtcBalance",
    "EmbeddedMedia",
    "InvoiceData",
    "Keys",
    "Media",
    "Metadata",
    "Online",
    "Outpoint",
    "ProofOfReserves",
    "ReceiveData",
    "Recipient",
    "RefreshFilter",
    "RefreshedTransfer",
    "RgbAllocation",
    "SendResult",
    "Token",
    "TokenLight",
    "Transaction",
    "Transfer",
    "TransferTransportEndpoint",
    "Unspent",
    "Utxo",
    "WalletData",
    "WitnessData",
    "generate_keys",
    "restore_backup",
    "restore_keys",
    "Address",
    "Invoice",
    "RecipientInfo",
    "TransportEndpoint",
    "Wallet",
]

