
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ...types.secure_value import TypeSecureValue
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_secure_value import TypeInputSecureValue


class SaveSecureValue(TLRequest[TypeSecureValue]):
    """
    Securely save [Telegram Passport](https://core.telegram.org/passport) document, [for more info see the passport docs](https://core.telegram.org/passport/encryption#encryption)

    Raises:
        `400`PasswordRequiredError: A [2FA password](https://core.telegram.org/api/srp) must be configured to use Telegram Passport.
        `400`SecureSecretRequiredError: A secure secret is required.

    """

    _id = 0X899FE31D
    _result_id = 0XF39C206D

    def __init__(
        self,
        value: 'TypeInputSecureValue',
        secure_secret_id: int
    ):

        """
        Securely save [Telegram Passport](https://core.telegram.org/passport) document, [for more info see the passport docs](https://core.telegram.org/passport/encryption#encryption)

        Args:
            value ('TypeInputSecureValue'): Secure value, [for more info see the passport docs](https://core.telegram.org/passport/encryption#encryption)
            secure_secret_id (int): Passport secret hash, [for more info see the passport docs](https://core.telegram.org/passport/encryption#encryption)
        """

        self.value = value
        self.secure_secret_id = secure_secret_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1d\xe3\x9f\x89' if boxed else b'') as writer:
            writer.object(
                self.value,
                group_id=0X248E826F
            )
            writer.long(self.secure_secret_id)

            return writer.getvalue()