
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.data_json import TypeDataJSON
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.data_json import TypeDataJSON


class SendCustomRequest(TLRequest[TypeDataJSON]):
    """
    Sends a custom request **for bots only**

    Raises:
        `400`DataJsonInvalidError: The provided JSON data is invalid.
        `400`MethodInvalidError: The specified method is invalid.
        `400`UserBotRequiredError: This method can only be called by a bot.
        `403`UserBotInvalidError: User accounts must provide the `bot` method parameter when calling this method. If there is no such method parameter, this method can only be invoked by bot accounts.

    """

    _id = 0XAA2769ED
    _result_id = 0XE95B0798

    def __init__(
        self,
        custom_method: str,
        params: 'TypeDataJSON'
    ):

        """
        Sends a custom request **for bots only**

        Args:
            custom_method (str): The method name
            params ('TypeDataJSON'): JSON-serialized method parameters
        """

        self.custom_method = custom_method
        self.params = params

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xedi'\xaa" if boxed else b'') as writer:
            writer.string(self.custom_method)
            writer.object(
                self.params,
                group_id=0XE95B0798
            )

            return writer.getvalue()