
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_channel import TypeInputChannel
    from ...types.chat_admin_rights import TypeChatAdminRights


class EditAdmin(TLRequest[TypeUpdates]):
    """
    Modify the admin rights of a user in a [supergroup/channel](https://core.telegram.org/api/channel).

    **Bots can use this method**

    Raises:
        `400`AdminsTooMuchError: There are too many admins.
        `400`AdminRankEmojiNotAllowedError: An admin rank cannot contain emojis.
        `400`AdminRankInvalidError: The specified admin rank is invalid.
        `400`BotsTooMuchError: There are too many bots in this chat/channel.
        `400`BotChannelsNaError: Bots can't edit admin privileges.
        `400`BotGroupsBlockedError: This bot can't be added to groups.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UsersTooMuchError: The maximum number of users has been exceeded (to create a chat, for example).
        `400`UserBlockedError: User blocked.
        `400`UserCreatorError: For channels.editAdmin: you've tried to edit the admin rights of the owner, but you're not the owner; for channels.leaveChannel: you can't leave this channel, because you're its creator.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `403`ChatAdminInviteRequiredError: You do not have the rights to do this.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`RightForbiddenError: Your admin rights do not allow you to do this.
        `403`UserChannelsTooMuchError: One of the users you tried to add is already in too many channels/supergroups.
        `403`UserNotMutualContactError: The provided user is not a mutual contact.
        `403`UserPrivacyRestrictedError: The user's privacy settings do not allow you to do this.
        `403`UserRestrictedError: You're spamreported, you can't create channels or chats.
        `406`FreshChangeAdminsForbiddenError: You were just elected admin, you can't add or modify other admins yet.

    """

    _id = 0XD33C8902
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        user_id: 'TypeInputUser',
        admin_rights: 'TypeChatAdminRights',
        rank: str
    ):

        """
        Modify the admin rights of a user in a [supergroup/channel](https://core.telegram.org/api/channel).

        **Bots can use this method**

        Args:
            channel ('TypeInputChannel'): The [supergroup/channel](https://core.telegram.org/api/channel).
            user_id ('TypeInputUser'): The ID of the user whose admin rights should be modified
            admin_rights ('TypeChatAdminRights'): The admin rights
            rank (str): Indicates the role (rank) of the admin in the group: just an arbitrary string
        """

        self.channel = channel
        self.user_id = user_id
        self.admin_rights = admin_rights
        self.rank = rank

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x02\x89<\xd3' if boxed else b'') as writer:
            writer.object(
                self.channel,
                group_id=0X42691CEF
            )
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )
            writer.object(
                self.admin_rights,
                group_id=0X2A03C5CB
            )
            writer.string(self.rank)

            return writer.getvalue()