
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.affected_history import TypeMessagesAffectedHistory


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class DeleteHistory(TLRequest[TypeMessagesAffectedHistory]):
    """
    Deletes communication history.

    Raises:
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ChatRevokeDateUnsupportedError: `min_date` and `max_date` are not available for using with non-user peers.
        `400`MaxDateInvalidError: The specified maximum date is invalid.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`MinDateInvalidError: The specified minimum date is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XB08F922A
    _result_id = 0XC038BDBA

    def __init__(
        self,
        peer: 'TypeInputPeer',
        max_id: int,
        just_clear: bool = False,
        revoke: bool = False,
        min_date: Optional[int] = None,
        max_date: Optional[int] = None
    ):

        """
        Deletes communication history.

        Args:
            peer ('TypeInputPeer'): User or chat, communication history of which will be deleted
            max_id (int): Maximum ID of message to delete
            just_clear (bool, optional): Just clear history for the current user, without actually removing messages for every chat user
            revoke (bool, optional): Whether to delete the message history for all chat participants
            min_date (Optional[int], optional): Delete all messages newer than this UNIX timestamp
            max_date (Optional[int], optional): Delete all messages older than this UNIX timestamp
        """

        self.peer = peer
        self.max_id = max_id
        self.just_clear = just_clear
        self.revoke = revoke
        self.min_date = min_date
        self.max_date = max_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'*\x92\x8f\xb0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.just_clear, 0)
                flags(self.revoke, 1)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.max_id)

                if flags(self.min_date, 2):
                    writer.int(self.min_date)

                if flags(self.max_date, 3):
                    writer.int(self.max_date)

            return writer.getvalue()