
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.exported_chat_invite import TypeExportedChatInvite


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.stars_subscription_pricing import TypeStarsSubscriptionPricing


class ExportChatInvite(TLRequest[TypeExportedChatInvite]):
    """
    Export an invite link for a chat

    **Bots can use this method**

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ExpireDateInvalidError: The specified expiration date is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`PricingChatInvalidError: The pricing for the [subscription](https://core.telegram.org/api/subscriptions) is invalid, the maximum price is specified in the [`stars_subscription_amount_max` config key &raquo;](https://core.telegram.org/api/config#stars-subscription-amount-max).
        `400`SubscriptionPeriodInvalidError: The specified subscription_pricing.period is invalid.
        `400`UsageLimitInvalidError: The specified usage limit is invalid.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0XA455DE90
    _result_id = 0X4C7FB2E0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        legacy_revoke_permanent: bool = False,
        request_needed: bool = False,
        expire_date: Optional[int] = None,
        usage_limit: Optional[int] = None,
        title: Optional[str] = None,
        subscription_pricing: Optional['TypeStarsSubscriptionPricing'] = None
    ):

        """
        Export an invite link for a chat

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Chat
            legacy_revoke_permanent (bool, optional): Legacy flag, reproducing legacy behavior of this method: if set, revokes all previous links before creating a new one. Kept for bot API BC, should not be used by modern clients.
            request_needed (bool, optional): Whether admin confirmation is required before admitting each separate user into the chat
            expire_date (Optional[int], optional): Expiration date
            usage_limit (Optional[int], optional): Maximum number of users that can join using this link
            title (Optional[str], optional): Description of the invite link, visible only to administrators
            subscription_pricing (Optional['TypeStarsSubscriptionPricing'], optional): For [Telegram Star subscriptions](https://core.telegram.org/api/stars#star-subscriptions), contains the pricing of the subscription the user must activate to join the private channel.
        """

        self.peer = peer
        self.legacy_revoke_permanent = legacy_revoke_permanent
        self.request_needed = request_needed
        self.expire_date = expire_date
        self.usage_limit = usage_limit
        self.title = title
        self.subscription_pricing = subscription_pricing

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x90\xdeU\xa4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.legacy_revoke_permanent, 2)
                flags(self.request_needed, 3)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.expire_date, 0):
                    writer.int(self.expire_date)

                if flags(self.usage_limit, 1):
                    writer.int(self.usage_limit)

                if flags(self.title, 4):
                    writer.string(self.title)

                if flags(self.subscription_pricing, 5):
                    writer.object(
                        self.subscription_pricing,
                        group_id=0XB0E97E9F
                    )

            return writer.getvalue()