
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_dialog_peer import TypeInputDialogPeer


class MarkDialogUnread(TLRequest[bool]):
    """
    Manually mark dialog as unread

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X8C5006F8
    _result_id = 0X43B904E1

    def __init__(
        self,
        peer: 'TypeInputDialogPeer',
        unread: bool = False,
        parent_peer: Optional['TypeInputPeer'] = None
    ):

        """
        Manually mark dialog as unread

        Args:
            peer ('TypeInputDialogPeer'): Dialog
            unread (bool, optional): Mark as unread/read
            parent_peer (Optional['TypeInputPeer'], optional): ...
        """

        self.peer = peer
        self.unread = unread
        self.parent_peer = parent_peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf8\x06P\x8c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.unread, 0)

                if flags(self.parent_peer, 1):
                    writer.object(
                        self.parent_peer,
                        group_id=0X995DB9DF
                    )
                writer.object(
                    self.peer,
                    group_id=0XE22959A
                )

            return writer.getvalue()