
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer, Long
from ...types.messages.sent_encrypted_message import TypeMessagesSentEncryptedMessage


if TYPE_CHECKING:
    from ...types.input_encrypted_chat import TypeInputEncryptedChat
    from ...types.input_encrypted_file import TypeInputEncryptedFile


class SendEncryptedFile(TLRequest[TypeMessagesSentEncryptedMessage]):
    """
    Sends a message with a file attachment to a secret chat

    Raises:
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`DataTooLongError: Data too long.
        `400`EncryptionDeclinedError: The secret chat was declined.
        `400`FileEmtpyError: An empty file was provided.
        `400`Md5ChecksumInvalidError: The MD5 checksums do not match.
        `400`MsgWaitFailedError: A waiting call returned an error.

    """

    _id = 0X5559481D
    _result_id = 0XFA58ED64

    def __init__(
        self,
        peer: 'TypeInputEncryptedChat',
        data: bytes,
        file: 'TypeInputEncryptedFile',
        silent: bool = False,
        random_id: int = None
    ):

        """
        Sends a message with a file attachment to a secret chat

        Args:
            peer ('TypeInputEncryptedChat'): Secret chat ID
            data (bytes): TL-serialization of [DecryptedMessage](https://core.telegram.org/type/DecryptedMessage) type, encrypted with a key generated during chat initialization
            file ('TypeInputEncryptedFile'): File attachment for the secret chat
            silent (bool, optional): Whether to send the file without triggering a notification
            random_id (int, optional): Unique client message ID necessary to prevent message resending
        """

        self.peer = peer
        self.data = data
        self.file = file
        self.silent = silent
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1dHYU' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 0)
                writer.object(
                    self.peer,
                    group_id=0X947D3E78
                )
                writer.long(self.random_id)
                writer.bytes(self.data)
                writer.object(
                    self.file,
                    group_id=0X7D7FFAC2
                )

            return writer.getvalue()