
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer, Long


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_media import TypeInputMedia
    from ...types.reply_markup import TypeReplyMarkup
    from ...types.input_reply_to import TypeInputReplyTo
    from ...types.message_entity import TypeMessageEntity
    from ...types.suggested_post import TypeSuggestedPost
    from ...types.input_quick_reply_shortcut import TypeInputQuickReplyShortcut


class SendMedia(TLRequest[TypeUpdates]):
    """
    Send a media

    **Bots can use this method**

    Raises:
        `400`BotGamesDisabledError: Games can't be sent to channels.
        `400`BotPaymentsDisabledError: Please enable bot payments in botfather before calling this method.
        `400`BroadcastPublicVotersForbiddenError: You can't forward polls with public voters.
        `400`BusinessPeerInvalidError: Messages can't be set to the specified peer through the current [business connection](https://core.telegram.org/api/business#connected-bots).
        `400`ButtonCopyTextInvalidError: The specified [keyboardButtonCopy](https://core.telegram.org/constructor/keyboardButtonCopy).`copy_text` is invalid.
        `400`ButtonDataInvalidError: The data of one or more of the buttons you provided is invalid.
        `400`ButtonPosInvalidError: The position of one of the keyboard buttons is invalid (i.e. a Game or Pay button not in the first position, and so on...).
        `400`ButtonTypeInvalidError: The type of one or more of the buttons you provided is invalid.
        `400`ButtonUrlInvalidError: Button URL invalid.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatForwardsRestrictedError: You can't forward messages from a protected chat.
        `400`ChatRestrictedError: You can't send messages in this chat, you were restricted.
        `400`CurrencyTotalAmountInvalidError: The total amount of all prices is invalid.
        `400`DocumentInvalidError: The specified document is invalid.
        `400`EmoticonInvalidError: The specified emoji is invalid.
        `400`EntityBoundsInvalidError: A specified [entity offset or length](https://core.telegram.org/api/entities#entity-length) is invalid, see [here &raquo;](https://core.telegram.org/api/entities#entity-length) for info on how to properly compute the entity offset/length.
        `400`ExtendedMediaAmountInvalidError: The specified `stars_amount` of the passed [inputMediaPaidMedia](https://core.telegram.org/constructor/inputMediaPaidMedia) is invalid.
        `400`ExternalUrlInvalidError: External URL invalid.
        `400`FilePartsInvalidError: The number of file parts is invalid.
        `400`FilePartLengthInvalidError: The length of a file part is invalid.
        `400`FileReferenceEmptyError: An empty [file reference](https://core.telegram.org/api/file_reference) was specified.
        `400`FileReferenceExpiredError: File reference expired, it must be refetched as described in [the documentation](https://core.telegram.org/api/file_reference).
        `400`GameBotInvalidError: Bots can't send another bot's game.
        `400`ImageProcessFailedError: Failure while processing image.
        `400`InputFileInvalidError: The specified [InputFile](https://core.telegram.org/type/InputFile) is invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`InvoicePayloadInvalidError: The specified invoice payload is invalid.
        `400`Md5ChecksumInvalidError: The MD5 checksums do not match.
        `400`MediaCaptionTooLongError: The caption is too long.
        `400`MediaEmptyError: The provided media object is invalid.
        `400`MediaInvalidError: Media invalid.
        `400`MessageEmptyError: The provided message is empty.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PaymentProviderInvalidError: The specified payment provider is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`PhotoExtInvalidError: The extension of the photo is invalid.
        `400`PhotoInvalidDimensionsError: The photo dimensions are invalid.
        `400`PhotoSaveFileInvalidError: Internal issues, try again later.
        `400`PollAnswersInvalidError: Invalid poll answers were provided.
        `400`PollAnswerInvalidError: One of the poll answers is not acceptable.
        `400`PollOptionDuplicateError: Duplicate poll options provided.
        `400`PollOptionInvalidError: Invalid poll option provided.
        `400`PollQuestionInvalidError: One of the poll questions is not acceptable.
        `400`QuickRepliesTooMuchError: A maximum of [appConfig.`quick_replies_limit`](https://core.telegram.org/api/config#quick-replies-limit) shortcuts may be created, the limit was reached.
        `400`QuizCorrectAnswersEmptyError: No correct quiz answer was specified.
        `400`QuizCorrectAnswersTooMuchError: You specified too many correct answers in a quiz, quizzes can only have one right answer!
        `400`QuizCorrectAnswerInvalidError: An invalid value was provided to the correct_answers field.
        `400`QuizMultipleInvalidError: Quizzes can't have the multiple_choice flag set!
        `400`ReplyMarkupBuyEmptyError: Reply markup for buy button empty.
        `400`ReplyMarkupGameEmptyError: A game message is being edited, but the newly provided keyboard doesn't have a keyboardButtonGame button.
        `400`ReplyMarkupInvalidError: The provided reply markup is invalid.
        `400`ReplyMarkupTooLongError: The specified reply_markup is too long.
        `400`ReplyMessagesTooMuchError: Each shortcut can contain a maximum of [appConfig.`quick_reply_messages_limit`](https://core.telegram.org/api/config#quick-reply-messages-limit) messages, the limit was reached.
        `400`ScheduleBotNotAllowedError: Bots cannot schedule messages.
        `400`ScheduleDateTooLateError: You can't schedule a message this far in the future.
        `400`ScheduleTooMuchError: There are too many scheduled messages.
        `400`SendAsPeerInvalidError: You can't send messages as the specified peer.
        `400`StarsInvoiceInvalidError: The specified Telegram Star invoice is invalid.
        `400`StoryIdInvalidError: The specified story ID is invalid.
        `400`SubscriptionExportMissingError: You cannot send a [bot subscription invoice](https://core.telegram.org/api/subscriptions#bot-subscriptions) directly, you may only create invoice links using [payments.exportInvoice](https://core.telegram.org/method/payments.exportInvoice).
        `400`TermsUrlInvalidError: The specified [invoice](https://core.telegram.org/constructor/invoice).`terms_url` is invalid.
        `400`TtlMediaInvalidError: Invalid media Time To Live was provided.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `400`UserIsBotError: Bots can't send messages to other bots.
        `400`VideoContentTypeInvalidError: The video's content type is invalid.
        `400`VoiceMessagesForbiddenError: This user's privacy settings forbid you from sending voice messages.
        `400`WebdocumentMimeInvalidError: Invalid webdocument mime type provided.
        `400`WebpageCurlFailedError: Failure while fetching the webpage with cURL.
        `400`WebpageMediaEmptyError: Webpage media empty.
        `400`WebpageNotFoundError: A preview for the specified webpage `url` could not be generated.
        `400`WebpageUrlInvalidError: The specified webpage `url` is invalid.
        `400`YouBlockedUserError: You blocked this user.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `406`TopicClosedError: This topic was closed, you can't send messages to it anymore.
        `406`TopicDeletedError: The specified topic was deleted.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatGuestSendForbiddenError: You join the discussion group before commenting, see [here &raquo;](https://core.telegram.org/api/discussion#requiring-users-to-join-the-group) for more info.
        `403`ChatSendAudiosForbiddenError: You can't send audio messages in this chat.
        `403`ChatSendDocsForbiddenError: You can't send documents in this chat.
        `403`ChatSendGifsForbiddenError: You can't send gifs in this chat.
        `403`ChatSendMediaForbiddenError: You can't send media in this chat.
        `403`ChatSendPhotosForbiddenError: You can't send photos in this chat.
        `403`ChatSendPlainForbiddenError: You can't send non-media (text) messages in this chat.
        `403`ChatSendPollForbiddenError: You can't send polls in this chat.
        `403`ChatSendRoundvideosForbiddenError: You can't send round videos to this chat.
        `403`ChatSendStickersForbiddenError: You can't send stickers in this chat.
        `403`ChatSendVideosForbiddenError: You can't send videos in this chat.
        `403`ChatSendVoicesForbiddenError: You can't send voice recordings in this chat.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`PremiumAccountRequiredError: A premium account is required to execute this action.
        `403`PrivacyPremiumRequiredError: You need a [Telegram Premium subscription](https://core.telegram.org/api/premium) to send a message to this user.
        `403`UserIsBlockedError: You were blocked by this user.
        `500`RandomIdDuplicateError: You provided a random ID that was already used.
        `420`SlowmodeWaitError: Slowmode is enabled in this chat: wait {seconds} seconds before sending another message to this chat.

    """

    _id = 0XAC55D9C1
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        media: 'TypeInputMedia',
        message: str,
        silent: bool = False,
        background: bool = False,
        clear_draft: bool = False,
        noforwards: bool = False,
        update_stickersets_order: bool = False,
        invert_media: bool = False,
        allow_paid_floodskip: bool = False,
        reply_to: Optional['TypeInputReplyTo'] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        schedule_date: Optional[int] = None,
        send_as: Optional['TypeInputPeer'] = None,
        quick_reply_shortcut: Optional['TypeInputQuickReplyShortcut'] = None,
        effect: Optional[int] = None,
        allow_paid_stars: Optional[int] = None,
        suggested_post: Optional['TypeSuggestedPost'] = None,
        random_id: int = None
    ):

        """
        Send a media

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Destination
            media ('TypeInputMedia'): Attached media
            message (str): Caption
            silent (bool, optional): Send message silently (no notification should be triggered)
            background (bool, optional): Send message in background
            clear_draft (bool, optional): Clear the draft
            noforwards (bool, optional): Only for bots, disallows forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
            update_stickersets_order (bool, optional): Whether to move used stickersets to top, [see here for more info on this flag](https://core.telegram.org/api/stickers#recent-stickersets)
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            allow_paid_floodskip (bool, optional): Bots only: if set, allows sending up to 1000 messages per second, ignoring [broadcasting limits](https://core.telegram.org/bots/faq#how-can-i-message-all-of-my-bot-39s-subscribers-at-once) for a fee of 0.1 Telegram Stars per message. The relevant Stars will be withdrawn from the bot's balance.
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the message should be sent in reply to the specified message or story.
            reply_markup (Optional['TypeReplyMarkup'], optional): Reply markup for bot keyboards
            entities (Optional[List['TypeMessageEntity']], optional): Message [entities](https://core.telegram.org/api/entities) for styled text
            schedule_date (Optional[int], optional): Scheduled message date for [scheduled messages](https://core.telegram.org/api/scheduled-messages)
            send_as (Optional['TypeInputPeer'], optional): Send this message as the specified peer
            quick_reply_shortcut (Optional['TypeInputQuickReplyShortcut'], optional): Add the message to the specified [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts), instead.
            effect (Optional[int], optional): Specifies a [message effect](https://core.telegram.org/api/effects) to use for the message.
            allow_paid_stars (Optional[int], optional): ...
            suggested_post (Optional['TypeSuggestedPost'], optional): ...
            random_id (int, optional): Random ID to avoid resending the same message
        """

        self.peer = peer
        self.media = media
        self.message = message
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.noforwards = noforwards
        self.update_stickersets_order = update_stickersets_order
        self.invert_media = invert_media
        self.allow_paid_floodskip = allow_paid_floodskip
        self.reply_to = reply_to
        self.reply_markup = reply_markup
        self.entities = entities
        self.schedule_date = schedule_date
        self.send_as = send_as
        self.quick_reply_shortcut = quick_reply_shortcut
        self.effect = effect
        self.allow_paid_stars = allow_paid_stars
        self.suggested_post = suggested_post
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc1\xd9U\xac' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 5)
                flags(self.background, 6)
                flags(self.clear_draft, 7)
                flags(self.noforwards, 14)
                flags(self.update_stickersets_order, 15)
                flags(self.invert_media, 16)
                flags(self.allow_paid_floodskip, 19)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.reply_to, 0):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )
                writer.object(
                    self.media,
                    group_id=0XCEC6DE21
                )
                writer.string(self.message)
                writer.long(self.random_id)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

                if flags(self.entities, 3):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.schedule_date, 10):
                    writer.int(self.schedule_date)

                if flags(self.send_as, 13):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

                if flags(self.quick_reply_shortcut, 17):
                    writer.object(
                        self.quick_reply_shortcut,
                        group_id=0X60706B98
                    )

                if flags(self.effect, 18):
                    writer.long(self.effect)

                if flags(self.allow_paid_stars, 21):
                    writer.long(self.allow_paid_stars)

                if flags(self.suggested_post, 22):
                    writer.object(
                        self.suggested_post,
                        group_id=0X7DC96856
                    )

            return writer.getvalue()