
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer, Long


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.paid_reaction_privacy import TypePaidReactionPrivacy


class SendPaidReaction(TLRequest[TypeUpdates]):
    """
    Sends one or more [paid Telegram Star reactions](https://core.telegram.org/api/reactions#paid-reactions), transferring [Telegram Stars](https://core.telegram.org/api/stars) to a channel's balance.

    Raises:
        `400`MessageIdInvalidError: The provided message id is invalid.

    """

    _id = 0X58BBCB50
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int,
        count: int,
        private: Optional['TypePaidReactionPrivacy'] = None,
        random_id: int = None
    ):

        """
        Sends one or more [paid Telegram Star reactions](https://core.telegram.org/api/reactions#paid-reactions), transferring [Telegram Stars](https://core.telegram.org/api/stars) to a channel's balance.

        Args:
            peer ('TypeInputPeer'): The channel
            msg_id (int): The message to react to
            count (int): The number of [stars](https://core.telegram.org/api/stars) to send (each will increment the reaction counter by one).
            private (Optional['TypePaidReactionPrivacy'], optional): Each post with star reactions has a leaderboard with the top senders, but users can opt out of appearing there if they prefer more privacy.  If the user explicitly chose to make their paid reaction(s) private, pass [boolTrue](https://core.telegram.org/constructor/boolTrue) to [messages.sendPaidReaction](https://core.telegram.org/method/messages.sendPaidReaction). private.  If the user explicitly chose to make their paid reaction(s) private, pass [boolFalse](https://core.telegram.org/constructor/boolTrue) to [messages.sendPaidReaction](https://core.telegram.org/method/messages.sendPaidReaction). private.  If the user did not make any explicit choice about the privacy of their paid reaction(s) (i.e. when reacting by clicking on an existing star reaction on a message), do not populate the [messages.sendPaidReaction](https://core.telegram.org/method/messages.sendPaidReaction). private flag.
            random_id (int, optional): Unique client message ID required to prevent message resending
        """

        self.peer = peer
        self.msg_id = msg_id
        self.count = count
        self.private = private
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'P\xcb\xbbX' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.msg_id)
                writer.int(self.count)
                writer.long(self.random_id)

                if flags(self.private, 0):
                    writer.object(
                        self.private,
                        group_id=0XA09546B0
                    )

            return writer.getvalue()