
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.payments.validated_requested_info import TypePaymentsValidatedRequestedInfo


if TYPE_CHECKING:
    from ...types.input_invoice import TypeInputInvoice
    from ...types.payment_requested_info import TypePaymentRequestedInfo


class ValidateRequestedInfo(TLRequest[TypePaymentsValidatedRequestedInfo]):
    """
    Submit requested order information for validation

    Raises:
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XB6C8F12B
    _result_id = 0X829A8E1A

    def __init__(
        self,
        invoice: 'TypeInputInvoice',
        info: 'TypePaymentRequestedInfo',
        save: bool = False
    ):

        """
        Submit requested order information for validation

        Args:
            invoice ('TypeInputInvoice'): Invoice
            info ('TypePaymentRequestedInfo'): Requested order information
            save (bool, optional): Save order information to re-use it for future orders
        """

        self.invoice = invoice
        self.info = info
        self.save = save

    def to_bytes(self, boxed: bool=True):
        with Writer(b'+\xf1\xc8\xb6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.save, 0)
                writer.object(
                    self.invoice,
                    group_id=0X70F585EC
                )
                writer.object(
                    self.info,
                    group_id=0X89AE5563
                )

            return writer.getvalue()