
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ...types.photos.photo import TypePhotosPhoto
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_photo import TypeInputPhoto


class UpdateProfilePhoto(TLRequest[TypePhotosPhoto]):
    """
    Installs a previously uploaded photo as a profile photo.

    **Bots can use this method**

    Raises:
        `400`AlbumPhotosTooManyError: You have uploaded too many profile photos, delete some before retrying.
        `400`FilePartsInvalidError: The number of file parts is invalid.
        `400`ImageProcessFailedError: Failure while processing image.
        `400`LocationInvalidError: The provided location is invalid.
        `400`PhotoCropSizeSmallError: Photo is too small.
        `400`PhotoExtInvalidError: The extension of the photo is invalid.
        `400`PhotoIdInvalidError: Photo ID invalid.

    """

    _id = 0X9E82039
    _result_id = 0X6F58FEF2

    def __init__(
        self,
        id: 'TypeInputPhoto',
        fallback: bool = False,
        bot: Optional['TypeInputUser'] = None
    ):

        """
        Installs a previously uploaded photo as a profile photo.

        **Bots can use this method**

        Args:
            id ('TypeInputPhoto'): Input photo
            fallback (bool, optional): If set, the chosen profile photo will be shown to users that can't display your main profile photo due to your privacy settings.
            bot (Optional['TypeInputUser'], optional): Can contain info of a bot we own, to change the profile photo of that bot, instead of the current user.
        """

        self.id = id
        self.fallback = fallback
        self.bot = bot

    def to_bytes(self, boxed: bool=True):
        with Writer(b'9 \xe8\t' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.fallback, 0)

                if flags(self.bot, 1):
                    writer.object(
                        self.bot,
                        group_id=0XB628962F
                    )
                writer.object(
                    self.id,
                    group_id=0XB05DFB35
                )

            return writer.getvalue()