
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ...types.photos.photo import TypePhotosPhoto
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_file import TypeInputFile
    from ...types.video_size import TypeVideoSize


class UploadProfilePhoto(TLRequest[TypePhotosPhoto]):
    """
    Updates current user profile photo.

    **Bots can use this method**

    Raises:
        `400`AlbumPhotosTooManyError: You have uploaded too many profile photos, delete some before retrying.
        `400`BotInvalidError: This is not a valid bot.
        `400`EmojiMarkupInvalidError: The specified `video_emoji_markup` was invalid.
        `400`FilePartsInvalidError: The number of file parts is invalid.
        `400`ImageProcessFailedError: Failure while processing image.
        `400`PhotoCropFileMissingError: Photo crop file missing.
        `400`PhotoCropSizeSmallError: Photo is too small.
        `400`PhotoExtInvalidError: The extension of the photo is invalid.
        `400`PhotoFileMissingError: Profile photo file missing.
        `400`PhotoInvalidError: Photo invalid.
        `400`StickerMimeInvalidError: The specified sticker MIME type is invalid.
        `400`VideoFileInvalidError: The specified video file is invalid.

    """

    _id = 0X388A3B5
    _result_id = 0X6F58FEF2

    def __init__(
        self,
        fallback: bool = False,
        bot: Optional['TypeInputUser'] = None,
        file: Optional['TypeInputFile'] = None,
        video: Optional['TypeInputFile'] = None,
        video_start_ts: Optional[float] = None,
        video_emoji_markup: Optional['TypeVideoSize'] = None
    ):

        """
        Updates current user profile photo.

        **Bots can use this method**

        Args:
            fallback (bool, optional): If set, the chosen profile photo will be shown to users that can't display your main profile photo due to your privacy settings.
            bot (Optional['TypeInputUser'], optional): Can contain info of a bot we own, to change the profile photo of that bot, instead of the current user.
            file (Optional['TypeInputFile'], optional): Profile photo
            video (Optional['TypeInputFile'], optional): [Animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) video
            video_start_ts (Optional[float], optional): Floating point UNIX timestamp in seconds, indicating the frame of the video/sticker that should be used as static preview; can only be used if video or video_emoji_markup is set.
            video_emoji_markup (Optional['TypeVideoSize'], optional): Animated sticker profile picture, must contain either a [videoSizeEmojiMarkup](https://core.telegram.org/constructor/videoSizeEmojiMarkup) or a [videoSizeStickerMarkup](https://core.telegram.org/constructor/videoSizeStickerMarkup) constructor.
        """

        self.fallback = fallback
        self.bot = bot
        self.file = file
        self.video = video
        self.video_start_ts = video_start_ts
        self.video_emoji_markup = video_emoji_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb5\xa3\x88\x03' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.fallback, 3)

                if flags(self.bot, 5):
                    writer.object(
                        self.bot,
                        group_id=0XB628962F
                    )

                if flags(self.file, 0):
                    writer.object(
                        self.file,
                        group_id=0XB7247676
                    )

                if flags(self.video, 1):
                    writer.object(
                        self.video,
                        group_id=0XB7247676
                    )

                if flags(self.video_start_ts, 2):
                    writer.double(self.video_start_ts)

                if flags(self.video_emoji_markup, 4):
                    writer.object(
                        self.video_emoji_markup,
                        group_id=0X32B0FC60
                    )

            return writer.getvalue()