
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.stats.message_stats import TypeStatsMessageStats


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class GetMessageStats(TLRequest[TypeStatsMessageStats]):
    """
    Get [message statistics](https://core.telegram.org/api/stats)

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XB6E0A3F5
    _result_id = 0XBC497417

    def __init__(
        self,
        channel: 'TypeInputChannel',
        msg_id: int,
        dark: bool = False
    ):

        """
        Get [message statistics](https://core.telegram.org/api/stats)

        Args:
            channel ('TypeInputChannel'): Channel ID
            msg_id (int): Message ID
            dark (bool, optional): Whether to enable dark theme for graph colors
        """

        self.channel = channel
        self.msg_id = msg_id
        self.dark = dark

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf5\xa3\xe0\xb6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.dark, 0)
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.int(self.msg_id)

            return writer.getvalue()