
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.sticker_set import TypeMessagesStickerSet


if TYPE_CHECKING:
    from ...types.input_sticker_set import TypeInputStickerSet
    from ...types.input_sticker_set_item import TypeInputStickerSetItem


class AddStickerToSet(TLRequest[TypeMessagesStickerSet]):
    """
    Add a sticker to a stickerset. The sticker set must have been created by the current user/bot.

    **Bots can use this method**

    Raises:
        `400`StickerpackStickersTooMuchError: There are too many stickers in this stickerpack, you can't add any more.
        `400`StickersTooMuchError: There are too many stickers in this stickerpack, you can't add any more.
        `400`StickerPngNopngError: One of the specified stickers is not a valid PNG file.
        `400`StickerTgsNotgsError: Invalid TGS sticker provided.
        `406`StickersetInvalidError: The provided sticker set is invalid.

    """

    _id = 0X8653FEBE
    _result_id = 0X5CC84E96

    def __init__(
        self,
        stickerset: 'TypeInputStickerSet',
        sticker: 'TypeInputStickerSetItem'
    ):

        """
        Add a sticker to a stickerset. The sticker set must have been created by the current user/bot.

        **Bots can use this method**

        Args:
            stickerset ('TypeInputStickerSet'): The stickerset
            sticker ('TypeInputStickerSetItem'): The sticker
        """

        self.stickerset = stickerset
        self.sticker = sticker

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbe\xfeS\x86' if boxed else b'') as writer:
            writer.object(
                self.stickerset,
                group_id=0X919D8BA5
            )
            writer.object(
                self.sticker,
                group_id=0X6B1BC0F3
            )

            return writer.getvalue()