
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List
from ...types.file_hash import TypeFileHash
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class GetCdnFileHashes(TLRequest[List[TypeFileHash]]):
    """
    Get SHA256 hashes for verifying downloaded [CDN](https://core.telegram.org/cdn) files

    **Bots can use this method**

    Raises:
        `400`CdnMethodInvalidError: You can't call this method in a CDN DC.
        `400`FileTokenInvalidError: The master DC did not accept the `file_token` (e.g., the token has expired). Continue downloading the file from the master DC using upload.getFile.
        `400`RsaDecryptFailedError: Internal RSA decryption failed.

    """

    _id = 0X91DC3F31

    def __init__(
        self,
        file_token: bytes,
        offset: int
    ):

        """
        Get SHA256 hashes for verifying downloaded [CDN](https://core.telegram.org/cdn) files

        **Bots can use this method**

        Args:
            file_token (bytes): File
            offset (int): Offset from which to start getting hashes
        """

        self.file_token = file_token
        self.offset = offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'1?\xdc\x91' if boxed else b'') as writer:
            writer.bytes(self.file_token)
            writer.long(self.offset)

            return writer.getvalue()