
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..secure_value import TypeSecureValue
    from ..secure_value_error import TypeSecureValueError
    from ....gadgets.byteutils import Reader
    from ..secure_required_type import TypeSecureRequiredType


class AuthorizationForm(TLObject, family='TypeAccountAuthorizationForm'):
    """
    [Telegram Passport](https://core.telegram.org/passport) authorization form
    """

    _id = 0XAD2E1CD8
    _group_id = 0XE509B860

    def __init__(
        self,
        required_types: List['TypeSecureRequiredType'],
        values: List['TypeSecureValue'],
        errors: List['TypeSecureValueError'],
        users: List['TypeUser'],
        privacy_policy_url: Optional[str] = None
    ):

        """
        [Telegram Passport](https://core.telegram.org/passport) authorization form

        Args:
            required_types (List['TypeSecureRequiredType']): Required [Telegram Passport](https://core.telegram.org/passport) documents
            values (List['TypeSecureValue']): Already submitted [Telegram Passport](https://core.telegram.org/passport) documents
            errors (List['TypeSecureValueError']): [Telegram Passport](https://core.telegram.org/passport) errors
            users (List['TypeUser']): Info about the bot to which the form will be submitted
            privacy_policy_url (Optional[str], optional): URL of the service's privacy policy
        """

        self.required_types = required_types
        self.values = values
        self.errors = errors
        self.users = users
        self.privacy_policy_url = privacy_policy_url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd8\x1c.\xad' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.vector(
                    self.required_types,
                    lambda value: writer.object(
                        value,
                        group_id=0X84707AB2
                    )
                )
                writer.vector(
                    self.values,
                    lambda value: writer.object(
                        value,
                        group_id=0XF39C206D
                    )
                )
                writer.vector(
                    self.errors,
                    lambda value: writer.object(
                        value,
                        group_id=0X96147C5D
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

                if flags(self.privacy_policy_url, 0):
                    writer.string(self.privacy_policy_url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        required_types_ = reader.vector(
            lambda: reader.object(
                group_id=0X84707AB2
            )
        )

        values_ = reader.vector(
            lambda: reader.object(
                group_id=0XF39C206D
            )
        )

        errors_ = reader.vector(
            lambda: reader.object(
                group_id=0X96147C5D
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        privacy_policy_url_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            required_types=required_types_,
            values=values_,
            errors=errors_,
            users=users_,
            privacy_policy_url=privacy_policy_url_
        )

TypeAccountAuthorizationForm = AuthorizationForm