
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class TmpPassword(TLObject, family='TypeAccountTmpPassword'):
    """
    Temporary payment password
    """

    _id = 0XDB64FD34
    _group_id = 0XE4512AE1

    def __init__(
        self,
        tmp_password: bytes,
        valid_until: int
    ):

        """
        Temporary payment password

        Args:
            tmp_password (bytes): Temporary password
            valid_until (int): Validity period
        """

        self.tmp_password = tmp_password
        self.valid_until = valid_until

    def to_bytes(self, boxed: bool=True):
        with Writer(b'4\xfdd\xdb' if boxed else b'') as writer:
            writer.bytes(self.tmp_password)
            writer.int(self.valid_until)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        tmp_password_ = reader.bytes()
        valid_until_ = reader.int()

        return cls(
            tmp_password=tmp_password_,
            valid_until=valid_until_
        )

TypeAccountTmpPassword = TmpPassword