
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from .document import TypeDocument
    from .web_document import TypeWebDocument
    from .bot_inline_message import TypeBotInlineMessage
    from ...gadgets.byteutils import Reader


class BotInlineResult(TLObject, family='TypeBotInlineResult'):
    """
    Generic result
    """

    _id = 0X11965F3A
    _group_id = 0X940CB1DA

    def __init__(
        self,
        id: str,
        type: str,
        send_message: 'TypeBotInlineMessage',
        title: Optional[str] = None,
        description: Optional[str] = None,
        url: Optional[str] = None,
        thumb: Optional['TypeWebDocument'] = None,
        content: Optional['TypeWebDocument'] = None
    ):

        """
        Generic result

        Args:
            id (str): Result ID
            type (str): Result type (see [bot API docs](https://core.telegram.org/bots/api#inlinequeryresult))
            send_message ('TypeBotInlineMessage'): Message to send
            title (Optional[str], optional): Result title
            description (Optional[str], optional): Result description
            url (Optional[str], optional): URL of article or webpage
            thumb (Optional['TypeWebDocument'], optional): Thumbnail for the result
            content (Optional['TypeWebDocument'], optional): Content of the result
        """

        self.id = id
        self.type = type
        self.send_message = send_message
        self.title = title
        self.description = description
        self.url = url
        self.thumb = thumb
        self.content = content

    def to_bytes(self, boxed: bool=True):
        with Writer(b':_\x96\x11' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.id)
                writer.string(self.type)

                if flags(self.title, 1):
                    writer.string(self.title)

                if flags(self.description, 2):
                    writer.string(self.description)

                if flags(self.url, 3):
                    writer.string(self.url)

                if flags(self.thumb, 4):
                    writer.object(
                        self.thumb,
                        group_id=0XCDE930D7
                    )

                if flags(self.content, 5):
                    writer.object(
                        self.content,
                        group_id=0XCDE930D7
                    )
                writer.object(
                    self.send_message,
                    group_id=0X54822C1B
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.string()
        type_ = reader.string()
        title_ = (
            reader.string()
            if flags(1) else None
        )

        description_ = (
            reader.string()
            if flags(2) else None
        )

        url_ = (
            reader.string()
            if flags(3) else None
        )

        thumb_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(4) else None
        )

        content_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(5) else None
        )

        send_message_ = reader.object(
            group_id=0X54822C1B
        )

        return cls(
            id=id_,
            type=type_,
            send_message=send_message_,
            title=title_,
            description=description_,
            url=url_,
            thumb=thumb_,
            content=content_
        )

class BotInlineMediaResult(TLObject, family='TypeBotInlineResult'):
    """
    Media result
    """

    _id = 0X17DB940B
    _group_id = 0X940CB1DA

    def __init__(
        self,
        id: str,
        type: str,
        send_message: 'TypeBotInlineMessage',
        photo: Optional['TypePhoto'] = None,
        document: Optional['TypeDocument'] = None,
        title: Optional[str] = None,
        description: Optional[str] = None
    ):

        """
        Media result

        Args:
            id (str): Result ID
            type (str): Result type (see [bot API docs](https://core.telegram.org/bots/api#inlinequeryresult))
            send_message ('TypeBotInlineMessage'): Depending on the type and on the [constructor](https://core.telegram.org/type/BotInlineMessage), contains the caption of the media or the content of the message to be sent instead of the media
            photo (Optional['TypePhoto'], optional): If type is photo, the photo to send
            document (Optional['TypeDocument'], optional): If type is document, the document to send
            title (Optional[str], optional): Result title
            description (Optional[str], optional): Description
        """

        self.id = id
        self.type = type
        self.send_message = send_message
        self.photo = photo
        self.document = document
        self.title = title
        self.description = description

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0b\x94\xdb\x17' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.id)
                writer.string(self.type)

                if flags(self.photo, 0):
                    writer.object(
                        self.photo,
                        group_id=0XDDAD9CAC
                    )

                if flags(self.document, 1):
                    writer.object(
                        self.document,
                        group_id=0X6547BD50
                    )

                if flags(self.title, 2):
                    writer.string(self.title)

                if flags(self.description, 3):
                    writer.string(self.description)
                writer.object(
                    self.send_message,
                    group_id=0X54822C1B
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.string()
        type_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(0) else None
        )

        document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(1) else None
        )

        title_ = (
            reader.string()
            if flags(2) else None
        )

        description_ = (
            reader.string()
            if flags(3) else None
        )

        send_message_ = reader.object(
            group_id=0X54822C1B
        )

        return cls(
            id=id_,
            type=type_,
            send_message=send_message_,
            photo=photo_,
            document=document_,
            title=title_,
            description=description_
        )

TypeBotInlineResult = Union[
    BotInlineResult,
    BotInlineMediaResult
]