
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .business_recipients import TypeBusinessRecipients
    from ...gadgets.byteutils import Reader
    from .business_away_message_schedule import TypeBusinessAwayMessageSchedule


class BusinessAwayMessage(TLObject, family='TypeBusinessAwayMessage'):
    """
    Describes a [Telegram Business away message](https://core.telegram.org/api/business#away-messages), automatically sent to users writing to us when we're offline, during closing hours, while we're on vacation, or in some other custom time period when we cannot immediately answer to the user.
    """

    _id = 0XEF156A5C
    _group_id = 0X34919EA2

    def __init__(
        self,
        shortcut_id: int,
        schedule: 'TypeBusinessAwayMessageSchedule',
        recipients: 'TypeBusinessRecipients',
        offline_only: bool = False
    ):

        """
        Describes a [Telegram Business away message](https://core.telegram.org/api/business#away-messages), automatically sent to users writing to us when we're offline, during closing hours, while we're on vacation, or in some other custom time period when we cannot immediately answer to the user.

        Args:
            shortcut_id (int): ID of a [quick reply shorcut, containing the away messages to send, see here  for more info](https://core.telegram.org/api/business#quick-reply-shortcuts).
            schedule ('TypeBusinessAwayMessageSchedule'): Specifies when should the away messages be sent.
            recipients ('TypeBusinessRecipients'): Allowed recipients for the away messages.
            offline_only (bool, optional): If set, the messages will not be sent if the account was online in the last 10 minutes.
        """

        self.shortcut_id = shortcut_id
        self.schedule = schedule
        self.recipients = recipients
        self.offline_only = offline_only

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\j\x15\xef' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.offline_only, 0)
                writer.int(self.shortcut_id)
                writer.object(
                    self.schedule,
                    group_id=0X764A459D
                )
                writer.object(
                    self.recipients,
                    group_id=0XAA8E16FE
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        shortcut_id_ = reader.int()
        schedule_ = reader.object(
            group_id=0X764A459D
        )

        recipients_ = reader.object(
            group_id=0XAA8E16FE
        )

        return cls(
            shortcut_id=shortcut_id_,
            schedule=schedule_,
            recipients=recipients_,
            offline_only=flags(0)
        )

TypeBusinessAwayMessage = BusinessAwayMessage