
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from .message import TypeMessage
    from .peer_color import TypePeerColor
    from .wall_paper import TypeWallPaper
    from .forum_topic import TypeForumTopic
    from .emoji_status import TypeEmojiStatus
    from .chat_reactions import TypeChatReactions
    from .channel_location import TypeChannelLocation
    from .input_group_call import TypeInputGroupCall
    from .input_sticker_set import TypeInputStickerSet
    from .chat_banned_rights import TypeChatBannedRights
    from ...gadgets.byteutils import Reader
    from .channel_participant import TypeChannelParticipant
    from .exported_chat_invite import TypeExportedChatInvite
    from .group_call_participant import TypeGroupCallParticipant


class ChannelAdminLogEventActionChangeTitle(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    Channel/supergroup title was changed
    """

    _id = 0XE6DFB825
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: str,
        new_value: str
    ):

        """
        Channel/supergroup title was changed

        Args:
            prev_value (str): Previous title
            new_value (str): New title
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'%\xb8\xdf\xe6' if boxed else b'') as writer:
            writer.string(self.prev_value)
            writer.string(self.new_value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.string()
        new_value_ = reader.string()

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeAbout(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The description was changed
    """

    _id = 0X55188A2E
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: str,
        new_value: str
    ):

        """
        The description was changed

        Args:
            prev_value (str): Previous description
            new_value (str): New description
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'.\x8a\x18U' if boxed else b'') as writer:
            writer.string(self.prev_value)
            writer.string(self.new_value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.string()
        new_value_ = reader.string()

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeUsername(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    Channel/supergroup username was changed
    """

    _id = 0X6A4AFC38
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: str,
        new_value: str
    ):

        """
        Channel/supergroup username was changed

        Args:
            prev_value (str): Old username
            new_value (str): New username
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'8\xfcJj' if boxed else b'') as writer:
            writer.string(self.prev_value)
            writer.string(self.new_value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.string()
        new_value_ = reader.string()

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangePhoto(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The channel/supergroup's picture was changed
    """

    _id = 0X434BD2AF
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_photo: 'TypePhoto',
        new_photo: 'TypePhoto'
    ):

        """
        The channel/supergroup's picture was changed

        Args:
            prev_photo ('TypePhoto'): Previous picture
            new_photo ('TypePhoto'): New picture
        """

        self.prev_photo = prev_photo
        self.new_photo = new_photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xaf\xd2KC' if boxed else b'') as writer:
            writer.object(
                self.prev_photo,
                group_id=0XDDAD9CAC
            )
            writer.object(
                self.new_photo,
                group_id=0XDDAD9CAC
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        new_photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        return cls(
            prev_photo=prev_photo_,
            new_photo=new_photo_
        )

class ChannelAdminLogEventActionToggleInvites(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    Invites were enabled/disabled
    """

    _id = 0X1B7907AE
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        """
        Invites were enabled/disabled

        Args:
            new_value (bool): New value
        """

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xae\x07y\x1b' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

class ChannelAdminLogEventActionToggleSignatures(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    Channel signatures were enabled/disabled
    """

    _id = 0X26AE0971
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        """
        Channel signatures were enabled/disabled

        Args:
            new_value (bool): New value
        """

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'q\t\xae&' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

class ChannelAdminLogEventActionUpdatePinned(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A message was pinned
    """

    _id = 0XE9E82C18
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        message: 'TypeMessage'
    ):

        """
        A message was pinned

        Args:
            message ('TypeMessage'): The message that was pinned
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x18,\xe8\xe9' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_
        )

class ChannelAdminLogEventActionEditMessage(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A message was edited
    """

    _id = 0X709B2405
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_message: 'TypeMessage',
        new_message: 'TypeMessage'
    ):

        """
        A message was edited

        Args:
            prev_message ('TypeMessage'): Old message
            new_message ('TypeMessage'): New message
        """

        self.prev_message = prev_message
        self.new_message = new_message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x05$\x9bp' if boxed else b'') as writer:
            writer.object(
                self.prev_message,
                group_id=0X25780A8F
            )
            writer.object(
                self.new_message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_message_ = reader.object(
            group_id=0X25780A8F
        )

        new_message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            prev_message=prev_message_,
            new_message=new_message_
        )

class ChannelAdminLogEventActionDeleteMessage(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A message was deleted
    """

    _id = 0X42E047BB
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        message: 'TypeMessage'
    ):

        """
        A message was deleted

        Args:
            message ('TypeMessage'): The message that was deleted
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbbG\xe0B' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_
        )

class ChannelAdminLogEventActionParticipantJoin(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A user has joined the group (in the case of big groups, info of the user that has joined isn't shown)
    """

    _id = 0X183040D3
    _group_id = 0X3EA54A8B


    def to_bytes(self, boxed: bool=True):
        return b'\xd3@0\x18' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChannelAdminLogEventActionParticipantLeave(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A user left the channel/supergroup (in the case of big groups, info of the user that has joined isn't shown)
    """

    _id = 0XF89777F2
    _group_id = 0X3EA54A8B


    def to_bytes(self, boxed: bool=True):
        return b'\xf2w\x97\xf8' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChannelAdminLogEventActionParticipantInvite(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A user was invited to the group
    """

    _id = 0XE31C34D8
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        participant: 'TypeChannelParticipant'
    ):

        """
        A user was invited to the group

        Args:
            participant ('TypeChannelParticipant'): The user that was invited
        """

        self.participant = participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd84\x1c\xe3' if boxed else b'') as writer:
            writer.object(
                self.participant,
                group_id=0X21CCC4A0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        participant_ = reader.object(
            group_id=0X21CCC4A0
        )

        return cls(
            participant=participant_
        )

class ChannelAdminLogEventActionParticipantToggleBan(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The banned [rights](https://core.telegram.org/api/rights) of a user were changed
    """

    _id = 0XE6D83D7E
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_participant: 'TypeChannelParticipant',
        new_participant: 'TypeChannelParticipant'
    ):

        """
        The banned [rights](https://core.telegram.org/api/rights) of a user were changed

        Args:
            prev_participant ('TypeChannelParticipant'): Old banned rights of user
            new_participant ('TypeChannelParticipant'): New banned rights of user
        """

        self.prev_participant = prev_participant
        self.new_participant = new_participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'~=\xd8\xe6' if boxed else b'') as writer:
            writer.object(
                self.prev_participant,
                group_id=0X21CCC4A0
            )
            writer.object(
                self.new_participant,
                group_id=0X21CCC4A0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_participant_ = reader.object(
            group_id=0X21CCC4A0
        )

        new_participant_ = reader.object(
            group_id=0X21CCC4A0
        )

        return cls(
            prev_participant=prev_participant_,
            new_participant=new_participant_
        )

class ChannelAdminLogEventActionParticipantToggleAdmin(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The admin [rights](https://core.telegram.org/api/rights) of a user were changed
    """

    _id = 0XD5676710
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_participant: 'TypeChannelParticipant',
        new_participant: 'TypeChannelParticipant'
    ):

        """
        The admin [rights](https://core.telegram.org/api/rights) of a user were changed

        Args:
            prev_participant ('TypeChannelParticipant'): Previous admin rights
            new_participant ('TypeChannelParticipant'): New admin rights
        """

        self.prev_participant = prev_participant
        self.new_participant = new_participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x10gg\xd5' if boxed else b'') as writer:
            writer.object(
                self.prev_participant,
                group_id=0X21CCC4A0
            )
            writer.object(
                self.new_participant,
                group_id=0X21CCC4A0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_participant_ = reader.object(
            group_id=0X21CCC4A0
        )

        new_participant_ = reader.object(
            group_id=0X21CCC4A0
        )

        return cls(
            prev_participant=prev_participant_,
            new_participant=new_participant_
        )

class ChannelAdminLogEventActionChangeStickerSet(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The supergroup's stickerset was changed
    """

    _id = 0XB1C3CAA7
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_stickerset: 'TypeInputStickerSet',
        new_stickerset: 'TypeInputStickerSet'
    ):

        """
        The supergroup's stickerset was changed

        Args:
            prev_stickerset ('TypeInputStickerSet'): Previous stickerset
            new_stickerset ('TypeInputStickerSet'): New stickerset
        """

        self.prev_stickerset = prev_stickerset
        self.new_stickerset = new_stickerset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa7\xca\xc3\xb1' if boxed else b'') as writer:
            writer.object(
                self.prev_stickerset,
                group_id=0X919D8BA5
            )
            writer.object(
                self.new_stickerset,
                group_id=0X919D8BA5
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        new_stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        return cls(
            prev_stickerset=prev_stickerset_,
            new_stickerset=new_stickerset_
        )

class ChannelAdminLogEventActionTogglePreHistoryHidden(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The hidden prehistory setting was [changed](https://core.telegram.org/method/channels.togglePreHistoryHidden)
    """

    _id = 0X5F5C95F1
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        """
        The hidden prehistory setting was [changed](https://core.telegram.org/method/channels.togglePreHistoryHidden)

        Args:
            new_value (bool): New value
        """

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf1\x95\\_' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

class ChannelAdminLogEventActionDefaultBannedRights(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The default banned rights were modified
    """

    _id = 0X2DF5FC0A
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_banned_rights: 'TypeChatBannedRights',
        new_banned_rights: 'TypeChatBannedRights'
    ):

        """
        The default banned rights were modified

        Args:
            prev_banned_rights ('TypeChatBannedRights'): Previous global [banned rights](https://core.telegram.org/api/rights)
            new_banned_rights ('TypeChatBannedRights'): New global [banned rights](https://core.telegram.org/api/rights).
        """

        self.prev_banned_rights = prev_banned_rights
        self.new_banned_rights = new_banned_rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\n\xfc\xf5-' if boxed else b'') as writer:
            writer.object(
                self.prev_banned_rights,
                group_id=0XDB47663A
            )
            writer.object(
                self.new_banned_rights,
                group_id=0XDB47663A
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_banned_rights_ = reader.object(
            group_id=0XDB47663A
        )

        new_banned_rights_ = reader.object(
            group_id=0XDB47663A
        )

        return cls(
            prev_banned_rights=prev_banned_rights_,
            new_banned_rights=new_banned_rights_
        )

class ChannelAdminLogEventActionStopPoll(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A poll was stopped
    """

    _id = 0X8F079643
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        message: 'TypeMessage'
    ):

        """
        A poll was stopped

        Args:
            message ('TypeMessage'): The poll that was stopped
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'C\x96\x07\x8f' if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_
        )

class ChannelAdminLogEventActionChangeLinkedChat(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The linked chat was changed
    """

    _id = 0X50C7AC8
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: int,
        new_value: int
    ):

        """
        The linked chat was changed

        Args:
            prev_value (int): Previous linked chat
            new_value (int): New linked chat
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc8z\x0c\x05' if boxed else b'') as writer:
            writer.long(self.prev_value)
            writer.long(self.new_value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.long()
        new_value_ = reader.long()

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeLocation(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The geogroup location was changed
    """

    _id = 0XE6B76AE
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: 'TypeChannelLocation',
        new_value: 'TypeChannelLocation'
    ):

        """
        The geogroup location was changed

        Args:
            prev_value ('TypeChannelLocation'): Previous location
            new_value ('TypeChannelLocation'): New location
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xaevk\x0e' if boxed else b'') as writer:
            writer.object(
                self.prev_value,
                group_id=0X40180970
            )
            writer.object(
                self.new_value,
                group_id=0X40180970
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.object(
            group_id=0X40180970
        )

        new_value_ = reader.object(
            group_id=0X40180970
        )

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionToggleSlowMode(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    [Slow mode setting for supergroups was changed](https://core.telegram.org/method/channels.toggleSlowMode)
    """

    _id = 0X53909779
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: int,
        new_value: int
    ):

        """
        [Slow mode setting for supergroups was changed](https://core.telegram.org/method/channels.toggleSlowMode)

        Args:
            prev_value (int): Previous slow mode value
            new_value (int): New slow mode value
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'y\x97\x90S' if boxed else b'') as writer:
            writer.int(self.prev_value)
            writer.int(self.new_value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.int()
        new_value_ = reader.int()

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionStartGroupCall(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A group call was started
    """

    _id = 0X23209745
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        call: 'TypeInputGroupCall'
    ):

        """
        A group call was started

        Args:
            call ('TypeInputGroupCall'): Group call
        """

        self.call = call

    def to_bytes(self, boxed: bool=True):
        with Writer(b'E\x97 #' if boxed else b'') as writer:
            writer.object(
                self.call,
                group_id=0XDA9A559A
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        return cls(
            call=call_
        )

class ChannelAdminLogEventActionDiscardGroupCall(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A group call was terminated
    """

    _id = 0XDB9F9140
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        call: 'TypeInputGroupCall'
    ):

        """
        A group call was terminated

        Args:
            call ('TypeInputGroupCall'): The group call that was terminated
        """

        self.call = call

    def to_bytes(self, boxed: bool=True):
        with Writer(b'@\x91\x9f\xdb' if boxed else b'') as writer:
            writer.object(
                self.call,
                group_id=0XDA9A559A
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        return cls(
            call=call_
        )

class ChannelAdminLogEventActionParticipantMute(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A group call participant was muted
    """

    _id = 0XF92424D2
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        participant: 'TypeGroupCallParticipant'
    ):

        """
        A group call participant was muted

        Args:
            participant ('TypeGroupCallParticipant'): The participant that was muted
        """

        self.participant = participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd2$$\xf9' if boxed else b'') as writer:
            writer.object(
                self.participant,
                group_id=0XC404CB69
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        participant_ = reader.object(
            group_id=0XC404CB69
        )

        return cls(
            participant=participant_
        )

class ChannelAdminLogEventActionParticipantUnmute(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A group call participant was unmuted
    """

    _id = 0XE64429C0
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        participant: 'TypeGroupCallParticipant'
    ):

        """
        A group call participant was unmuted

        Args:
            participant ('TypeGroupCallParticipant'): The participant that was unmuted
        """

        self.participant = participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc0)D\xe6' if boxed else b'') as writer:
            writer.object(
                self.participant,
                group_id=0XC404CB69
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        participant_ = reader.object(
            group_id=0XC404CB69
        )

        return cls(
            participant=participant_
        )

class ChannelAdminLogEventActionToggleGroupCallSetting(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    Group call settings were changed
    """

    _id = 0X56D6A247
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        join_muted: bool
    ):

        """
        Group call settings were changed

        Args:
            join_muted (bool): Whether all users are muted by default upon joining
        """

        self.join_muted = join_muted

    def to_bytes(self, boxed: bool=True):
        with Writer(b'G\xa2\xd6V' if boxed else b'') as writer:
            writer.object(
                self.join_muted,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        join_muted_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            join_muted=join_muted_
        )

class ChannelAdminLogEventActionParticipantJoinByInvite(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A user joined the [supergroup/channel](https://core.telegram.org/api/channel) using a specific invite link
    """

    _id = 0XFE9FC158
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        invite: 'TypeExportedChatInvite',
        via_chatlist: bool = False
    ):

        """
        A user joined the [supergroup/channel](https://core.telegram.org/api/channel) using a specific invite link

        Args:
            invite ('TypeExportedChatInvite'): The invite link used to join the [supergroup/channel](https://core.telegram.org/api/channel)
            via_chatlist (bool, optional): The participant joined by importing a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).
        """

        self.invite = invite
        self.via_chatlist = via_chatlist

    def to_bytes(self, boxed: bool=True):
        with Writer(b'X\xc1\x9f\xfe' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.via_chatlist, 0)
                writer.object(
                    self.invite,
                    group_id=0X4C7FB2E0
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        invite_ = reader.object(
            group_id=0X4C7FB2E0
        )

        return cls(
            invite=invite_,
            via_chatlist=flags(0)
        )

class ChannelAdminLogEventActionExportedInviteDelete(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A chat invite was deleted
    """

    _id = 0X5A50FCA4
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        invite: 'TypeExportedChatInvite'
    ):

        """
        A chat invite was deleted

        Args:
            invite ('TypeExportedChatInvite'): The deleted chat invite
        """

        self.invite = invite

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa4\xfcPZ' if boxed else b'') as writer:
            writer.object(
                self.invite,
                group_id=0X4C7FB2E0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        invite_ = reader.object(
            group_id=0X4C7FB2E0
        )

        return cls(
            invite=invite_
        )

class ChannelAdminLogEventActionExportedInviteRevoke(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A specific invite link was revoked
    """

    _id = 0X410A134E
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        invite: 'TypeExportedChatInvite'
    ):

        """
        A specific invite link was revoked

        Args:
            invite ('TypeExportedChatInvite'): The invite link that was revoked
        """

        self.invite = invite

    def to_bytes(self, boxed: bool=True):
        with Writer(b'N\x13\nA' if boxed else b'') as writer:
            writer.object(
                self.invite,
                group_id=0X4C7FB2E0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        invite_ = reader.object(
            group_id=0X4C7FB2E0
        )

        return cls(
            invite=invite_
        )

class ChannelAdminLogEventActionExportedInviteEdit(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A chat invite was edited
    """

    _id = 0XE90EBB59
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_invite: 'TypeExportedChatInvite',
        new_invite: 'TypeExportedChatInvite'
    ):

        """
        A chat invite was edited

        Args:
            prev_invite ('TypeExportedChatInvite'): Previous chat invite information
            new_invite ('TypeExportedChatInvite'): New chat invite information
        """

        self.prev_invite = prev_invite
        self.new_invite = new_invite

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Y\xbb\x0e\xe9' if boxed else b'') as writer:
            writer.object(
                self.prev_invite,
                group_id=0X4C7FB2E0
            )
            writer.object(
                self.new_invite,
                group_id=0X4C7FB2E0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_invite_ = reader.object(
            group_id=0X4C7FB2E0
        )

        new_invite_ = reader.object(
            group_id=0X4C7FB2E0
        )

        return cls(
            prev_invite=prev_invite_,
            new_invite=new_invite_
        )

class ChannelAdminLogEventActionParticipantVolume(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    channelAdminLogEvent.user_id has set the volume of participant.peer to participant.volume
    """

    _id = 0X3E7F6847
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        participant: 'TypeGroupCallParticipant'
    ):

        """
        channelAdminLogEvent.user_id has set the volume of participant.peer to participant.volume

        Args:
            participant ('TypeGroupCallParticipant'): The participant whose volume was changed
        """

        self.participant = participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Gh\x7f>' if boxed else b'') as writer:
            writer.object(
                self.participant,
                group_id=0XC404CB69
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        participant_ = reader.object(
            group_id=0XC404CB69
        )

        return cls(
            participant=participant_
        )

class ChannelAdminLogEventActionChangeHistoryTTL(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The Time-To-Live of messages in this chat was changed
    """

    _id = 0X6E941A38
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: int,
        new_value: int
    ):

        """
        The Time-To-Live of messages in this chat was changed

        Args:
            prev_value (int): Previous value
            new_value (int): New value
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'8\x1a\x94n' if boxed else b'') as writer:
            writer.int(self.prev_value)
            writer.int(self.new_value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.int()
        new_value_ = reader.int()

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionParticipantJoinByRequest(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A new member was accepted to the chat by an admin
    """

    _id = 0XAFB6144A
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        invite: 'TypeExportedChatInvite',
        approved_by: int
    ):

        """
        A new member was accepted to the chat by an admin

        Args:
            invite ('TypeExportedChatInvite'): The invite link that was used to join the chat
            approved_by (int): ID of the admin that approved the invite
        """

        self.invite = invite
        self.approved_by = approved_by

    def to_bytes(self, boxed: bool=True):
        with Writer(b'J\x14\xb6\xaf' if boxed else b'') as writer:
            writer.object(
                self.invite,
                group_id=0X4C7FB2E0
            )
            writer.long(self.approved_by)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        invite_ = reader.object(
            group_id=0X4C7FB2E0
        )

        approved_by_ = reader.long()

        return cls(
            invite=invite_,
            approved_by=approved_by_
        )

class ChannelAdminLogEventActionToggleNoForwards(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    Forwards were enabled or disabled
    """

    _id = 0XCB2AC766
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        """
        Forwards were enabled or disabled

        Args:
            new_value (bool): Old value
        """

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'f\xc7*\xcb' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

class ChannelAdminLogEventActionSendMessage(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A message was posted in a channel
    """

    _id = 0X278F2868
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        message: 'TypeMessage'
    ):

        """
        A message was posted in a channel

        Args:
            message ('TypeMessage'): The message that was sent
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b"h(\x8f'" if boxed else b'') as writer:
            writer.object(
                self.message,
                group_id=0X25780A8F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.object(
            group_id=0X25780A8F
        )

        return cls(
            message=message_
        )

class ChannelAdminLogEventActionChangeAvailableReactions(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The set of allowed [message reactions](https://core.telegram.org/api/reactions) for this channel has changed
    """

    _id = 0XBE4E0EF8
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: 'TypeChatReactions',
        new_value: 'TypeChatReactions'
    ):

        """
        The set of allowed [message reactions](https://core.telegram.org/api/reactions) for this channel has changed

        Args:
            prev_value ('TypeChatReactions'): Previously allowed reaction emojis
            new_value ('TypeChatReactions'): New allowed reaction emojis
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf8\x0eN\xbe' if boxed else b'') as writer:
            writer.object(
                self.prev_value,
                group_id=0XE0A5CEE3
            )
            writer.object(
                self.new_value,
                group_id=0XE0A5CEE3
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.object(
            group_id=0XE0A5CEE3
        )

        new_value_ = reader.object(
            group_id=0XE0A5CEE3
        )

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeUsernames(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The list of usernames associated with the channel was changed
    """

    _id = 0XF04FB3A9
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: List[str],
        new_value: List[str]
    ):

        """
        The list of usernames associated with the channel was changed

        Args:
            prev_value (List[str]): Previous set of usernames
            new_value (List[str]): New set of usernames
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa9\xb3O\xf0' if boxed else b'') as writer:
            writer.vector(
                self.prev_value,
                writer.string
            )
            writer.vector(
                self.new_value,
                writer.string
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.vector(
            reader.string
        )

        new_value_ = reader.vector(
            reader.string
        )

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionToggleForum(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    [Forum](https://core.telegram.org/api/forum) functionality was enabled or disabled.
    """

    _id = 0X2CC6383
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        """
        [Forum](https://core.telegram.org/api/forum) functionality was enabled or disabled.

        Args:
            new_value (bool): Whether [forum](https://core.telegram.org/api/forum) functionality was enabled or disabled.
        """

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x83c\xcc\x02' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

class ChannelAdminLogEventActionCreateTopic(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A [forum topic](https://core.telegram.org/api/forum#forum-topics) was created
    """

    _id = 0X58707D28
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        topic: 'TypeForumTopic'
    ):

        """
        A [forum topic](https://core.telegram.org/api/forum#forum-topics) was created

        Args:
            topic ('TypeForumTopic'): The [forum topic](https://core.telegram.org/api/forum#forum-topics) that was created
        """

        self.topic = topic

    def to_bytes(self, boxed: bool=True):
        with Writer(b'(}pX' if boxed else b'') as writer:
            writer.object(
                self.topic,
                group_id=0XB926BAD6
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        topic_ = reader.object(
            group_id=0XB926BAD6
        )

        return cls(
            topic=topic_
        )

class ChannelAdminLogEventActionEditTopic(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A [forum topic](https://core.telegram.org/api/forum#forum-topics) was edited
    """

    _id = 0XF06FE208
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_topic: 'TypeForumTopic',
        new_topic: 'TypeForumTopic'
    ):

        """
        A [forum topic](https://core.telegram.org/api/forum#forum-topics) was edited

        Args:
            prev_topic ('TypeForumTopic'): Previous topic information
            new_topic ('TypeForumTopic'): New topic information
        """

        self.prev_topic = prev_topic
        self.new_topic = new_topic

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\xe2o\xf0' if boxed else b'') as writer:
            writer.object(
                self.prev_topic,
                group_id=0XB926BAD6
            )
            writer.object(
                self.new_topic,
                group_id=0XB926BAD6
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_topic_ = reader.object(
            group_id=0XB926BAD6
        )

        new_topic_ = reader.object(
            group_id=0XB926BAD6
        )

        return cls(
            prev_topic=prev_topic_,
            new_topic=new_topic_
        )

class ChannelAdminLogEventActionDeleteTopic(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A [forum topic](https://core.telegram.org/api/forum#forum-topics) was deleted
    """

    _id = 0XAE168909
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        topic: 'TypeForumTopic'
    ):

        """
        A [forum topic](https://core.telegram.org/api/forum#forum-topics) was deleted

        Args:
            topic ('TypeForumTopic'): The [forum topic](https://core.telegram.org/api/forum#forum-topics) that was deleted
        """

        self.topic = topic

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\t\x89\x16\xae' if boxed else b'') as writer:
            writer.object(
                self.topic,
                group_id=0XB926BAD6
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        topic_ = reader.object(
            group_id=0XB926BAD6
        )

        return cls(
            topic=topic_
        )

class ChannelAdminLogEventActionPinTopic(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A [forum topic](https://core.telegram.org/api/forum#forum-topics) was pinned or unpinned
    """

    _id = 0X5D8D353B
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_topic: Optional['TypeForumTopic'] = None,
        new_topic: Optional['TypeForumTopic'] = None
    ):

        """
        A [forum topic](https://core.telegram.org/api/forum#forum-topics) was pinned or unpinned

        Args:
            prev_topic (Optional['TypeForumTopic'], optional): Previous topic information
            new_topic (Optional['TypeForumTopic'], optional): New topic information
        """

        self.prev_topic = prev_topic
        self.new_topic = new_topic

    def to_bytes(self, boxed: bool=True):
        with Writer(b';5\x8d]' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.prev_topic, 0):
                    writer.object(
                        self.prev_topic,
                        group_id=0XB926BAD6
                    )

                if flags(self.new_topic, 1):
                    writer.object(
                        self.new_topic,
                        group_id=0XB926BAD6
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        prev_topic_ = (
            reader.object(
                group_id=0XB926BAD6
            )
            if flags(0) else None
        )

        new_topic_ = (
            reader.object(
                group_id=0XB926BAD6
            )
            if flags(1) else None
        )

        return cls(
            prev_topic=prev_topic_,
            new_topic=new_topic_
        )

class ChannelAdminLogEventActionToggleAntiSpam(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    [Native antispam](https://core.telegram.org/api/antispam) functionality was enabled or disabled.
    """

    _id = 0X64F36DFC
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        """
        [Native antispam](https://core.telegram.org/api/antispam) functionality was enabled or disabled.

        Args:
            new_value (bool): Whether antispam functionality was enabled or disabled.
        """

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfcm\xf3d' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangePeerColor(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The [message accent color](https://core.telegram.org/api/colors) was changed
    """

    _id = 0X5796E780
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: 'TypePeerColor',
        new_value: 'TypePeerColor'
    ):

        """
        The [message accent color](https://core.telegram.org/api/colors) was changed

        Args:
            prev_value ('TypePeerColor'): Previous accent palette
            new_value ('TypePeerColor'): New accent palette
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x80\xe7\x96W' if boxed else b'') as writer:
            writer.object(
                self.prev_value,
                group_id=0XA2C08D16
            )
            writer.object(
                self.new_value,
                group_id=0XA2C08D16
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.object(
            group_id=0XA2C08D16
        )

        new_value_ = reader.object(
            group_id=0XA2C08D16
        )

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeProfilePeerColor(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The [profile accent color](https://core.telegram.org/api/colors) was changed
    """

    _id = 0X5E477B25
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: 'TypePeerColor',
        new_value: 'TypePeerColor'
    ):

        """
        The [profile accent color](https://core.telegram.org/api/colors) was changed

        Args:
            prev_value ('TypePeerColor'): Previous accent palette
            new_value ('TypePeerColor'): New accent palette
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'%{G^' if boxed else b'') as writer:
            writer.object(
                self.prev_value,
                group_id=0XA2C08D16
            )
            writer.object(
                self.new_value,
                group_id=0XA2C08D16
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.object(
            group_id=0XA2C08D16
        )

        new_value_ = reader.object(
            group_id=0XA2C08D16
        )

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeWallpaper(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The [wallpaper](https://core.telegram.org/api/wallpapers) was changed
    """

    _id = 0X31BB5D52
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: 'TypeWallPaper',
        new_value: 'TypeWallPaper'
    ):

        """
        The [wallpaper](https://core.telegram.org/api/wallpapers) was changed

        Args:
            prev_value ('TypeWallPaper'): Previous wallpaper
            new_value ('TypeWallPaper'): New wallpaper
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'R]\xbb1' if boxed else b'') as writer:
            writer.object(
                self.prev_value,
                group_id=0XC6E3E0E2
            )
            writer.object(
                self.new_value,
                group_id=0XC6E3E0E2
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.object(
            group_id=0XC6E3E0E2
        )

        new_value_ = reader.object(
            group_id=0XC6E3E0E2
        )

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeEmojiStatus(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The [emoji status](https://core.telegram.org/api/emoji-status) was changed
    """

    _id = 0X3EA9FEB1
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_value: 'TypeEmojiStatus',
        new_value: 'TypeEmojiStatus'
    ):

        """
        The [emoji status](https://core.telegram.org/api/emoji-status) was changed

        Args:
            prev_value ('TypeEmojiStatus'): Previous emoji status
            new_value ('TypeEmojiStatus'): New emoji status
        """

        self.prev_value = prev_value
        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb1\xfe\xa9>' if boxed else b'') as writer:
            writer.object(
                self.prev_value,
                group_id=0XFBDA9FB
            )
            writer.object(
                self.new_value,
                group_id=0XFBDA9FB
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_value_ = reader.object(
            group_id=0XFBDA9FB
        )

        new_value_ = reader.object(
            group_id=0XFBDA9FB
        )

        return cls(
            prev_value=prev_value_,
            new_value=new_value_
        )

class ChannelAdminLogEventActionChangeEmojiStickerSet(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    The supergroup's [custom emoji stickerset](https://core.telegram.org/api/boost#setting-a-custom-emoji-stickerset-for-supergroups) was changed.
    """

    _id = 0X46D840AB
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_stickerset: 'TypeInputStickerSet',
        new_stickerset: 'TypeInputStickerSet'
    ):

        """
        The supergroup's [custom emoji stickerset](https://core.telegram.org/api/boost#setting-a-custom-emoji-stickerset-for-supergroups) was changed.

        Args:
            prev_stickerset ('TypeInputStickerSet'): Old value
            new_stickerset ('TypeInputStickerSet'): New value
        """

        self.prev_stickerset = prev_stickerset
        self.new_stickerset = new_stickerset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xab@\xd8F' if boxed else b'') as writer:
            writer.object(
                self.prev_stickerset,
                group_id=0X919D8BA5
            )
            writer.object(
                self.new_stickerset,
                group_id=0X919D8BA5
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        new_stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        return cls(
            prev_stickerset=prev_stickerset_,
            new_stickerset=new_stickerset_
        )

class ChannelAdminLogEventActionToggleSignatureProfiles(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    Channel signature profiles were enabled/disabled.
    """

    _id = 0X60A79C79
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        """
        Channel signature profiles were enabled/disabled.

        Args:
            new_value (bool): New value
        """

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'y\x9c\xa7`' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

class ChannelAdminLogEventActionParticipantSubExtend(TLObject, family='TypeChannelAdminLogEventAction'):
    """
    A paid subscriber has extended their [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions).
    """

    _id = 0X64642DB3
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        prev_participant: 'TypeChannelParticipant',
        new_participant: 'TypeChannelParticipant'
    ):

        """
        A paid subscriber has extended their [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions).

        Args:
            prev_participant ('TypeChannelParticipant'): Same as new_participant.
            new_participant ('TypeChannelParticipant'): The subscriber that extended the subscription.
        """

        self.prev_participant = prev_participant
        self.new_participant = new_participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb3-dd' if boxed else b'') as writer:
            writer.object(
                self.prev_participant,
                group_id=0X21CCC4A0
            )
            writer.object(
                self.new_participant,
                group_id=0X21CCC4A0
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prev_participant_ = reader.object(
            group_id=0X21CCC4A0
        )

        new_participant_ = reader.object(
            group_id=0X21CCC4A0
        )

        return cls(
            prev_participant=prev_participant_,
            new_participant=new_participant_
        )

class ChannelAdminLogEventActionToggleAutotranslation(TLObject, family='TypeChannelAdminLogEventAction'):
    _id = 0XC517F77E
    _group_id = 0X3EA54A8B

    def __init__(
        self,
        new_value: bool
    ):

        self.new_value = new_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'~\xf7\x17\xc5' if boxed else b'') as writer:
            writer.object(
                self.new_value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            new_value=new_value_
        )

TypeChannelAdminLogEventAction = Union[
    ChannelAdminLogEventActionChangeTitle,
    ChannelAdminLogEventActionChangeAbout,
    ChannelAdminLogEventActionChangeUsername,
    ChannelAdminLogEventActionChangePhoto,
    ChannelAdminLogEventActionToggleInvites,
    ChannelAdminLogEventActionToggleSignatures,
    ChannelAdminLogEventActionUpdatePinned,
    ChannelAdminLogEventActionEditMessage,
    ChannelAdminLogEventActionDeleteMessage,
    ChannelAdminLogEventActionParticipantJoin,
    ChannelAdminLogEventActionParticipantLeave,
    ChannelAdminLogEventActionParticipantInvite,
    ChannelAdminLogEventActionParticipantToggleBan,
    ChannelAdminLogEventActionParticipantToggleAdmin,
    ChannelAdminLogEventActionChangeStickerSet,
    ChannelAdminLogEventActionTogglePreHistoryHidden,
    ChannelAdminLogEventActionDefaultBannedRights,
    ChannelAdminLogEventActionStopPoll,
    ChannelAdminLogEventActionChangeLinkedChat,
    ChannelAdminLogEventActionChangeLocation,
    ChannelAdminLogEventActionToggleSlowMode,
    ChannelAdminLogEventActionStartGroupCall,
    ChannelAdminLogEventActionDiscardGroupCall,
    ChannelAdminLogEventActionParticipantMute,
    ChannelAdminLogEventActionParticipantUnmute,
    ChannelAdminLogEventActionToggleGroupCallSetting,
    ChannelAdminLogEventActionParticipantJoinByInvite,
    ChannelAdminLogEventActionExportedInviteDelete,
    ChannelAdminLogEventActionExportedInviteRevoke,
    ChannelAdminLogEventActionExportedInviteEdit,
    ChannelAdminLogEventActionParticipantVolume,
    ChannelAdminLogEventActionChangeHistoryTTL,
    ChannelAdminLogEventActionParticipantJoinByRequest,
    ChannelAdminLogEventActionToggleNoForwards,
    ChannelAdminLogEventActionSendMessage,
    ChannelAdminLogEventActionChangeAvailableReactions,
    ChannelAdminLogEventActionChangeUsernames,
    ChannelAdminLogEventActionToggleForum,
    ChannelAdminLogEventActionCreateTopic,
    ChannelAdminLogEventActionEditTopic,
    ChannelAdminLogEventActionDeleteTopic,
    ChannelAdminLogEventActionPinTopic,
    ChannelAdminLogEventActionToggleAntiSpam,
    ChannelAdminLogEventActionChangePeerColor,
    ChannelAdminLogEventActionChangeProfilePeerColor,
    ChannelAdminLogEventActionChangeWallpaper,
    ChannelAdminLogEventActionChangeEmojiStatus,
    ChannelAdminLogEventActionChangeEmojiStickerSet,
    ChannelAdminLogEventActionToggleSignatureProfiles,
    ChannelAdminLogEventActionParticipantSubExtend,
    ChannelAdminLogEventActionToggleAutotranslation
]